/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBeeEntity;
import cy.jdkdigital.productivebees.common.item.StoneChip;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import cy.jdkdigital.productivebees.common.tileentity.FeederTileEntity;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.integrations.resourcefulbees.ResourcefulBeesCompat;
import cy.jdkdigital.productivebees.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeHelper {
    public static BeeEntity itemInteract(BeeEntity entity, ItemStack itemStack, World world, CompoundNBT nbt, PlayerEntity player, Hand hand, Direction direction) {
        BeeEntity bee = null;
        if (!entity.func_70631_g_()) {
            IdentifierInventory beeInv = new IdentifierInventory(entity, itemStack.func_77973_b().getRegistryName() + "");
            ArrayList<BeeConversionRecipe> recipes = new ArrayList<BeeConversionRecipe>();
            Map allRecipes = world.func_199532_z().func_215366_a(BeeConversionRecipe.BEE_CONVERSION);
            for (Map.Entry entry : allRecipes.entrySet()) {
                BeeConversionRecipe recipe = (BeeConversionRecipe)entry.getValue();
                if (!recipe.func_77569_a(beeInv, world)) continue;
                recipes.add(recipe);
            }
            if (!recipes.isEmpty()) {
                BeeConversionRecipe recipe = (BeeConversionRecipe)recipes.get(ProductiveBees.rand.nextInt(recipes.size()));
                if (ProductiveBees.rand.nextInt(100) < recipe.chance && (bee = (BeeEntity)((BeeIngredient)recipe.result.get()).getBeeEntity().func_200721_a(world)) instanceof ConfigurableBeeEntity) {
                    ((ConfigurableBeeEntity)bee).setBeeType(((BeeIngredient)recipe.result.get()).getBeeType().toString());
                    ((ConfigurableBeeEntity)bee).setAttributes();
                }
            }
        }
        if (bee != null) {
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            BeeHelper.prepareBeeSpawn(bee, entity.func_180425_c(), direction, entity.func_70874_b());
            return bee;
        }
        return null;
    }

    public static void prepareBeeSpawn(BeeEntity bee, BlockPos pos, Direction direction, int age) {
        if (bee != null) {
            double x = (double)pos.func_177958_n() + (double)direction.func_82601_c();
            double y = (double)pos.func_177956_o() + 0.5 - (double)(bee.func_213302_cg() / 2.0f);
            double z = (double)pos.func_177952_p() + (double)direction.func_82599_e();
            bee.func_70012_b(x, y, z, bee.field_70177_z, bee.field_70125_A);
            if (age > 0) {
                bee.func_70873_a(age);
            }
        }
    }

    @Nullable
    public static BeeEntity getBreedingResult(BeeEntity beeEntity, AgeableEntity targetEntity, World world) {
        ResourceLocation type;
        CompoundNBT nbt;
        Map<Lazy<BeeIngredient>, Integer> possibleOffspring;
        BeeBreedingRecipe recipe = BeeHelper.getRandomBreedingRecipe(beeEntity, targetEntity, world);
        if (recipe != null && (possibleOffspring = recipe.offspring) != null && possibleOffspring.size() > 0) {
            int maxWeight = 0;
            for (Map.Entry<Lazy<BeeIngredient>, Integer> entry : possibleOffspring.entrySet()) {
                maxWeight += entry.getValue().intValue();
            }
            BeeIngredient beeIngredient = null;
            int i = ProductiveBees.rand.nextInt(maxWeight);
            int currentWeight = 0;
            for (Map.Entry<Lazy<BeeIngredient>, Integer> entry : possibleOffspring.entrySet()) {
                if (i >= (currentWeight += entry.getValue().intValue())) continue;
                beeIngredient = (BeeIngredient)entry.getKey().get();
            }
            if (beeIngredient != null) {
                BeeEntity newBee = (BeeEntity)beeIngredient.getBeeEntity().func_200721_a(world);
                if (newBee instanceof ConfigurableBeeEntity) {
                    ((ConfigurableBeeEntity)newBee).setBeeType(beeIngredient.getBeeType().toString());
                    ((ConfigurableBeeEntity)newBee).setAttributes();
                }
                return newBee;
            }
        }
        if (beeEntity instanceof ConfigurableBeeEntity && (nbt = BeeReloadListener.INSTANCE.getData((type = new ResourceLocation(((ConfigurableBeeEntity)beeEntity).getBeeType())).toString())) != null && ((ConfigurableBeeEntity)beeEntity).canSelfBreed()) {
            ConfigurableBeeEntity newBee = (ConfigurableBeeEntity)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).func_200721_a(world);
            newBee.setBeeType(type.toString());
            newBee.setAttributes();
            return newBee;
        }
        if (!(beeEntity instanceof ProductiveBeeEntity) || ((ProductiveBeeEntity)beeEntity).canSelfBreed()) {
            return (BeeEntity)((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(beeEntity.func_70022_Q()))).func_200721_a(world);
        }
        return null;
    }

    public static BeeBreedingRecipe getRandomBreedingRecipe(BeeEntity beeEntity, AgeableEntity targetEntity, World world) {
        IdentifierInventory beeInv = new IdentifierInventory(beeEntity, (BeeEntity)targetEntity);
        ArrayList<BeeBreedingRecipe> recipes = new ArrayList<BeeBreedingRecipe>();
        Map allRecipes = world.func_199532_z().func_215366_a(BeeBreedingRecipe.BEE_BREEDING);
        for (Map.Entry entry : allRecipes.entrySet()) {
            BeeBreedingRecipe recipe = (BeeBreedingRecipe)entry.getValue();
            if (!recipe.func_77569_a(beeInv, world)) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            return (BeeBreedingRecipe)recipes.get(ProductiveBees.rand.nextInt(recipes.size()));
        }
        return null;
    }

    public static List<ItemStack> getBeeProduce(World world, BeeEntity beeEntity, boolean hasCombBlockUpgrade) {
        Block flowerBlock;
        ResourceLocation id;
        AdvancedBeehiveRecipe matchedRecipe = null;
        BlockPos flowerPos = beeEntity.func_226424_eq_();
        String beeId = beeEntity.func_70022_Q();
        if (beeEntity instanceof ConfigurableBeeEntity) {
            beeId = ((ConfigurableBeeEntity)beeEntity).getBeeType();
        }
        if ((id = new ResourceLocation(beeId)).func_110624_b().equals("resourcefulbees")) {
            return Collections.singletonList(ResourcefulBeesCompat.getHoneyComb(id.func_110623_a()));
        }
        Map allRecipes = world.func_199532_z().func_215366_a(AdvancedBeehiveRecipe.ADVANCED_BEEHIVE);
        IdentifierInventory beeInv = new IdentifierInventory(beeId);
        for (Map.Entry entry : allRecipes.entrySet()) {
            AdvancedBeehiveRecipe recipe = (AdvancedBeehiveRecipe)entry.getValue();
            if (!recipe.func_77569_a(beeInv, world)) continue;
            matchedRecipe = recipe;
        }
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (matchedRecipe != null) {
            matchedRecipe.getRecipeOutputs().forEach((itemStack, bounds) -> {
                if (ProductiveBees.rand.nextInt(100) <= bounds.get(2).func_150287_d()) {
                    int count = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)MathHelper.func_76141_d((float)bounds.get(0).func_150287_d()), (int)MathHelper.func_76141_d((float)bounds.get(1).func_150287_d()));
                    ItemStack stack = itemStack.func_77946_l();
                    stack.func_190920_e(count);
                    if (hasCombBlockUpgrade) {
                        stack = BeeHelper.convertToCombBlock(stack);
                    }
                    outputList.add(stack);
                }
            });
        } else if (beeId.equals("productivebees:lumber_bee")) {
            if (flowerPos != null) {
                flowerBlock = BeeHelper.getFloweringBlock(world, flowerPos, (Tag<Block>)BlockTags.field_200031_h);
                ItemStack woodChip = hasCombBlockUpgrade ? new ItemStack((IItemProvider)flowerBlock.func_199767_j()) : WoodChip.getStack(flowerBlock, world.field_73012_v.nextInt(6) + 1);
                outputList.add(woodChip);
            }
        } else if (beeId.equals("productivebees:quarry_bee")) {
            if (flowerPos != null) {
                flowerBlock = BeeHelper.getFloweringBlock(world, flowerPos, ModTags.QUARRY);
                ItemStack stoneChip = hasCombBlockUpgrade ? new ItemStack((IItemProvider)flowerBlock.func_199767_j()) : StoneChip.getStack(flowerBlock, world.field_73012_v.nextInt(6) + 1);
                outputList.add(stoneChip);
            }
        } else if (beeId.equals("productivebees:dye_bee") && flowerPos != null) {
            flowerBlock = BeeHelper.getFloweringBlock(world, flowerPos, (Tag<Block>)BlockTags.field_226149_I_);
            Item flowerItem = flowerBlock.func_199767_j();
            Map recipes = world.func_199532_z().func_215366_a(IRecipeType.field_222149_a);
            Optional flowerRecipe = recipes.values().stream().flatMap(craftingRecipe -> {
                Ingredient ingredient;
                ItemStack[] stacks;
                AtomicBoolean hasMatchingItem = new AtomicBoolean(false);
                NonNullList ingredients = craftingRecipe.func_192400_c();
                if (ingredients.size() == 1 && (stacks = (ingredient = (Ingredient)ingredients.get(0)).func_193365_a()).length > 0 && stacks[0].func_77973_b().equals(flowerItem)) {
                    hasMatchingItem.set(true);
                }
                return Util.func_215081_a(hasMatchingItem.get() ? Optional.of(craftingRecipe) : Optional.empty());
            }).findFirst();
            flowerRecipe.ifPresent(craftingInventoryIRecipe -> {
                ItemStack dye = new ItemStack((IItemProvider)craftingInventoryIRecipe.func_77571_b().func_77973_b(), 1);
                outputList.add(dye);
            });
        }
        return outputList;
    }

    private static ItemStack convertToCombBlock(ItemStack stack) {
        ItemStack newStack = null;
        if (stack.func_77973_b().equals(Items.field_226635_pU_)) {
            newStack = new ItemStack((IItemProvider)Items.field_226640_pZ_, stack.func_190916_E());
        } else if (stack.func_77973_b().equals(ModItems.CONFIGURABLE_HONEYCOMB.get())) {
            newStack = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_COMB_BLOCK.get(), stack.func_190916_E());
            newStack.func_77982_d(stack.func_77978_p());
        } else {
            ResourceLocation rl = stack.func_77973_b().getRegistryName();
            Item newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(rl.func_110624_b(), rl.func_110623_a().replace("honey", "")));
            if (newItem != Items.field_190931_a) {
                newStack = new ItemStack((IItemProvider)newItem, stack.func_190916_E());
            }
        }
        if (newStack != null) {
            stack = newStack;
        }
        return stack;
    }

    private static Block getFloweringBlock(World world, BlockPos flowerPos, Tag<Block> tag) {
        TileEntity feederTile;
        BlockState flowerBlockState = world.func_180495_p(flowerPos);
        Block flowerBlock = flowerBlockState.func_177230_c();
        if (flowerBlock instanceof Feeder && (feederTile = world.func_175625_s(flowerPos)) instanceof FeederTileEntity && ProductiveBeeEntity.isValidFeeder(feederTile, tag)) {
            return ((FeederTileEntity)feederTile).getRandomBlockFromInventory(tag);
        }
        return flowerBlock;
    }

    public static void setOffspringAttributes(ProductiveBeeEntity newBee, ProductiveBeeEntity productiveBeeEntity, AgeableEntity targetEntity) {
        Map<BeeAttribute<?>, Object> attributeMapParent1 = productiveBeeEntity.getBeeAttributes();
        Map<Object, Object> attributeMapParent2 = new HashMap<BeeAttribute<Integer>, Integer>();
        if (targetEntity instanceof ProductiveBeeEntity) {
            attributeMapParent2 = ((ProductiveBeeEntity)targetEntity).getBeeAttributes();
        } else {
            attributeMapParent2.put(BeeAttributes.PRODUCTIVITY, 0);
            attributeMapParent2.put(BeeAttributes.ENDURANCE, 0);
            attributeMapParent2.put(BeeAttributes.TEMPER, 1);
            attributeMapParent2.put(BeeAttributes.BEHAVIOR, 0);
            attributeMapParent2.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        }
        Map<BeeAttribute<?>, Object> attributeMapChild = newBee.getBeeAttributes();
        int parentProductivity = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.PRODUCTIVITY)), (int)((Integer)attributeMapParent2.get(BeeAttributes.PRODUCTIVITY)));
        attributeMapChild.put(BeeAttributes.PRODUCTIVITY, Math.max((Integer)attributeMapChild.get(BeeAttributes.PRODUCTIVITY), parentProductivity));
        int parentEndurance = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.ENDURANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.ENDURANCE)));
        attributeMapChild.put(BeeAttributes.ENDURANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.ENDURANCE), parentEndurance));
        int parentTemper = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.TEMPER)), (int)((Integer)attributeMapParent2.get(BeeAttributes.TEMPER)));
        attributeMapChild.put(BeeAttributes.TEMPER, Math.max((Integer)attributeMapChild.get(BeeAttributes.TEMPER), parentTemper));
        int parentBehavior = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.BEHAVIOR)), (int)((Integer)attributeMapParent2.get(BeeAttributes.BEHAVIOR)));
        attributeMapChild.put(BeeAttributes.BEHAVIOR, Math.max((Integer)attributeMapChild.get(BeeAttributes.BEHAVIOR), parentBehavior));
        int parentWeatherTolerance = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.WEATHER_TOLERANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.WEATHER_TOLERANCE)));
        attributeMapChild.put(BeeAttributes.WEATHER_TOLERANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.WEATHER_TOLERANCE), parentWeatherTolerance));
    }

    public static BeeEntity convertToConfigurable(BeeEntity entity) {
        if (entity instanceof ProductiveBeeEntity && !(entity instanceof ConfigurableBeeEntity) && !(entity instanceof SolitaryBeeEntity)) {
            String name = "productivebees:" + ((ProductiveBeeEntity)entity).getBeeName();
            if (name.equals("productivebees:wither")) {
                name = "productivebees:withered";
            } else if (name.equals("productivebees:quartz")) {
                name = "productivebees:crystalline";
            }
            BeeIngredient configuredBee = BeeIngredientFactory.getIngredient(name).get();
            if (configuredBee != null && configuredBee.isConfigurable()) {
                CompoundNBT tag = new CompoundNBT();
                entity.func_189511_e(tag);
                ConfigurableBeeEntity newEntity = (ConfigurableBeeEntity)configuredBee.getBeeEntity().func_200721_a(entity.field_70170_p);
                newEntity.func_70020_e(tag);
                newEntity.setBeeType(name);
                return newEntity;
            }
        }
        return entity;
    }

    public static List<ITextComponent> populateBeeInfoFromTag(CompoundNBT tag, @Nullable List<ITextComponent> list) {
        if (list == null) {
            list = new ArrayList<ITextComponent>();
        }
        list.add(new TranslationTextComponent(tag.func_74762_e("Age") < 0 ? "productivebees.information.age.child" : "productivebees.information.age.adult", new Object[0]).func_211708_a(TextFormatting.AQUA).func_211708_a(TextFormatting.ITALIC));
        if (tag.func_74767_n("isProductiveBee")) {
            float current = tag.func_74760_g("Health");
            float max = tag.func_74764_b("MaxHealth") ? tag.func_74760_g("MaxHealth") : 10.0f;
            list.add(new TranslationTextComponent("productivebees.information.attribute.health", new Object[]{Float.valueOf(current), Float.valueOf(max)}).func_211708_a(TextFormatting.DARK_GRAY));
            String type = tag.func_74779_i("bee_type");
            ITextComponent type_value = new TranslationTextComponent("productivebees.information.attribute.type." + type, new Object[0]).func_211708_a(ColorUtil.getColor(type));
            list.add(new TranslationTextComponent("productivebees.information.attribute.type", new Object[]{type_value}).func_211708_a(TextFormatting.DARK_GRAY));
            int productivity = tag.func_74762_e("bee_productivity");
            ITextComponent productivity_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.PRODUCTIVITY).get(productivity), new Object[0]).func_211708_a(ColorUtil.getColor(productivity));
            list.add(new TranslationTextComponent("productivebees.information.attribute.productivity", new Object[]{productivity_value}).func_211708_a(TextFormatting.DARK_GRAY));
            int tolerance = tag.func_74762_e("bee_weather_tolerance");
            ITextComponent tolerance_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.WEATHER_TOLERANCE).get(tolerance), new Object[0]).func_211708_a(ColorUtil.getColor(tolerance));
            list.add(new TranslationTextComponent("productivebees.information.attribute.weather_tolerance", new Object[]{tolerance_value}).func_211708_a(TextFormatting.DARK_GRAY));
            int behavior = tag.func_74762_e("bee_behavior");
            ITextComponent behavior_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.BEHAVIOR).get(behavior), new Object[0]).func_211708_a(ColorUtil.getColor(behavior));
            list.add(new TranslationTextComponent("productivebees.information.attribute.behavior", new Object[]{behavior_value}).func_211708_a(TextFormatting.DARK_GRAY));
            int endurance = tag.func_74762_e("bee_endurance");
            ITextComponent endurance_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.ENDURANCE).get(endurance), new Object[0]).func_211708_a(ColorUtil.getColor(endurance));
            list.add(new TranslationTextComponent("productivebees.information.attribute.endurance", new Object[]{endurance_value}).func_211708_a(TextFormatting.DARK_GRAY));
            int temper = tag.func_74762_e("bee_temper");
            ITextComponent temper_value = new TranslationTextComponent(BeeAttributes.keyMap.get(BeeAttributes.TEMPER).get(temper), new Object[0]).func_211708_a(ColorUtil.getColor(temper));
            list.add(new TranslationTextComponent("productivebees.information.attribute.temper", new Object[]{temper_value}).func_211708_a(TextFormatting.DARK_GRAY));
            if (tag.func_74764_b("HivePos")) {
                BlockPos hivePos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("HivePos"));
                list.add((ITextComponent)new StringTextComponent("Home position: " + hivePos.func_177958_n() + ", " + hivePos.func_177956_o() + ", " + hivePos.func_177952_p()));
            }
        } else {
            list.add(new StringTextComponent("Mod: " + tag.func_74779_i("mod")).func_211708_a(TextFormatting.DARK_AQUA));
        }
        return list;
    }

    public static class IdentifierInventory
    implements IInventory {
        private List<String> identifiers = new ArrayList<String>();

        public IdentifierInventory(String identifier) {
            this.identifiers.add(identifier);
        }

        public IdentifierInventory(BeeEntity bee1, BeeEntity bee2) {
            String identifier1 = bee1.func_70022_Q();
            if (bee1 instanceof ConfigurableBeeEntity) {
                identifier1 = ((ConfigurableBeeEntity)bee1).getBeeType();
            }
            String identifier2 = bee2.func_70022_Q();
            if (bee2 instanceof ConfigurableBeeEntity) {
                identifier2 = ((ConfigurableBeeEntity)bee2).getBeeType();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(BeeEntity bee1, String identifier2) {
            String identifier1 = bee1.func_70022_Q();
            if (bee1 instanceof ConfigurableBeeEntity) {
                identifier1 = ((ConfigurableBeeEntity)bee1).getBeeType();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(String identifier1, String identifier2) {
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public String getIdentifier() {
            return this.getIdentifier(0);
        }

        public String getIdentifier(int index) {
            return this.identifiers.get(index);
        }

        public int func_70302_i_() {
            return 1;
        }

        public boolean func_191420_l() {
            return this.identifiers.isEmpty();
        }

        @Nonnull
        public ItemStack func_70301_a(int i) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70298_a(int i, int i1) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70304_b(int i) {
            return ItemStack.field_190927_a;
        }

        public void func_70299_a(int i, @Nonnull ItemStack itemStack) {
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(@Nonnull PlayerEntity playerEntity) {
            return false;
        }

        public void func_174888_l() {
            this.identifiers.clear();
        }
    }
}

