/*
 * Decompiled with CFR 0.152.
 */
package tfar.quiver;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import tfar.quiver.QuiverItem;
import tfar.quiver.curios.ArrowCurio;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.inventory.CuriosContainer;

@Mod(value="quiver")
public class Quiver {
    public static final String MODID = "quiver";
    public static final Item quiver = new QuiverItem(new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_200917_a(1));
    public static final Tag<Item> arrow_curios = new ItemTags.Wrapper(new ResourceLocation("curios", "arrows"));
    public static final Predicate<ItemStack> arrow_predicate = stack -> stack.func_77973_b().func_206844_a(arrow_curios);

    public Quiver() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addGenericListener(Item.class, this::item);
        bus.addListener(this::comms);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCaps);
        MinecraftForge.EVENT_BUS.addListener(this::arrowPickup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::drawSlotBack);
            bus.addListener(this::doClientStuff);
            bus.addListener(this::stitchTextures);
        }
    }

    private void arrowPickup(EntityItemPickupEvent e) {
        ItemStack toPickup = e.getItem().func_92059_d();
        PlayerEntity player = e.getPlayer();
        if (player.field_71070_bA instanceof CuriosContainer) {
            return;
        }
        if (!CuriosAPI.getCurioEquipped(arrow_predicate, (LivingEntity)player).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.field_190927_a).func_190926_b()) {
            CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(iCurioItemHandler -> {
                ItemStack rem = toPickup.func_77946_l();
                CurioStackHandler curioStackHandler = iCurioItemHandler.getStackHandler("arrows");
                rem = curioStackHandler.insertItem(0, rem, true);
                if (toPickup.func_190916_E() > rem.func_190916_E()) {
                    if (rem.func_190926_b()) {
                        curioStackHandler.insertItem(0, toPickup, false);
                        toPickup.func_190920_e(0);
                        e.setCanceled(true);
                    } else {
                        toPickup.func_190920_e(rem.func_190916_E());
                    }
                }
            });
        }
    }

    private void comms(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage(MODID).setHidden(true));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("arrows").setHidden(true));
        InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)MODID, (Object)new ResourceLocation(MODID, "item/empty_quiver_slot")));
        InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)"arrows", (Object)new ResourceLocation(MODID, "item/empty_arrows_slot")));
    }

    private void drawSlotBack(GuiContainerEvent.DrawBackground e) {
        if (e.getGuiContainer() instanceof CuriosScreen) {
            CuriosScreen curiosScreen = (CuriosScreen)e.getGuiContainer();
            int i = curiosScreen.getGuiLeft();
            int j = curiosScreen.getGuiTop();
            curiosScreen.blit(i + 77, j + 19, 7, 7, 18, 36);
        }
    }

    public void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            String[] icons;
            for (String icon : icons = new String[]{"arrows", MODID}) {
                evt.addSprite(new ResourceLocation(MODID, "item/empty_" + icon + "_slot"));
            }
        }
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> e) {
        ItemStack stack = (ItemStack)e.getObject();
        if (stack.func_77973_b().func_206844_a(arrow_curios)) {
            final ArrowCurio arrowCurio = new ArrowCurio();
            e.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> arrowCurio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void item(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(quiver.setRegistryName(MODID));
    }

    public static ICapabilityProvider createProvider(ICurio curio) {
        return new Provider(curio);
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(ICurio curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

