/*
 * Decompiled with CFR 0.152.
 */
package tfar.quiver;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import tfar.quiver.QuiverConfig;
import tfar.quiver.QuiverItem;
import tfar.quiver.curios.ArrowCurio;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

@Mod(value="quiver")
public class Quiver {
    public static final String MODID = "quiver";
    public static final Item quiver = new QuiverItem(new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_200917_a(1));
    public static final ITag<Item> arrow_curios = ItemTags.func_199901_a((String)new ResourceLocation("curios", "arrows").toString());
    public static final Predicate<ItemStack> arrow_predicate = stack -> stack.func_77973_b().func_206844_a(arrow_curios);
    public static final QuiverConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public Quiver() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addGenericListener(Item.class, this::item);
        bus.addListener(this::comms);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCaps);
        MinecraftForge.EVENT_BUS.addListener(this::arrowPickup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::drawSlotBackground);
            bus.addListener(this::stitchTextures);
        }
    }

    private void arrowPickup(EntityItemPickupEvent e) {
        ItemStack toPickup = e.getItem().func_92059_d();
        PlayerEntity player = e.getPlayer();
        if (player.field_71070_bA instanceof CuriosContainer) {
            return;
        }
        if (!CuriosApi.getCuriosHelper().findEquippedCurio(arrow_predicate, (LivingEntity)player).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.field_190927_a).func_190926_b()) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(icurioitemhandler -> {
                ItemStack rem = toPickup.func_77946_l();
                ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)icurioitemhandler.getCurios().get("arrows");
                IDynamicStackHandler iDynamicStackHandler = iCurioStacksHandler.getStacks();
                rem = iDynamicStackHandler.insertItem(0, rem, true);
                if (toPickup.func_190916_E() > rem.func_190916_E()) {
                    if (rem.func_190926_b()) {
                        iDynamicStackHandler.insertItem(0, toPickup, false);
                        toPickup.func_190920_e(0);
                        e.setCanceled(true);
                    } else {
                        toPickup.func_190920_e(rem.func_190916_E());
                    }
                }
            });
        }
    }

    private void comms(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(MODID).hide().icon(new ResourceLocation(MODID, "item/empty_quiver_slot")).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("arrows").hide().icon(new ResourceLocation(MODID, "item/empty_arrows_slot")).build());
    }

    private void drawSlotBackground(GuiContainerEvent.DrawBackground e) {
        if (e.getGuiContainer() instanceof CuriosScreen) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            CuriosScreen curiosScreen = (CuriosScreen)e.getGuiContainer();
            int i = curiosScreen.getGuiLeft();
            int j = curiosScreen.getGuiTop();
            curiosScreen.func_238474_b_(e.getMatrixStack(), i + (Integer)QuiverConfig.x.get(), j + (Integer)QuiverConfig.y.get(), 7, 7, 18, 36);
        }
    }

    public void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            String[] icons;
            for (String icon : icons = new String[]{"arrows", MODID}) {
                evt.addSprite(new ResourceLocation(MODID, "item/empty_" + icon + "_slot"));
            }
        }
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> e) {
        ItemStack stack = (ItemStack)e.getObject();
        if (ItemTags.func_199903_a().func_199910_a(new ResourceLocation("curios", "arrows")) != null && arrow_curios.func_230235_a_((Object)stack.func_77973_b())) {
            final ArrowCurio arrowCurio = new ArrowCurio();
            e.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> arrowCurio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    private void item(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(quiver.setRegistryName(MODID));
    }

    public static ICapabilityProvider createProvider(ICurio curio) {
        return new Provider(curio);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(QuiverConfig::buildServer);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (QuiverConfig)specPair.getLeft();
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(ICurio curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

