/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.libmc.blocks.StandardBlocks;
import wile.redstonepen.libmc.detail.Auxiliaries;

public class CircuitComponents {

    public static class PulseRelayBlock
    extends RelayBlock {
        public PulseRelayBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return (Integer)state.func_177229_b((Property)STATE) == 0 || redsrone_side != this.getOutputFacing(state).func_176734_d() ? 0 : 15;
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
            if ((Integer)state.func_177229_b((Property)STATE) == 0) {
                return;
            }
            state = (BlockState)state.func_206870_a((Property)STATE, (Comparable)Integer.valueOf(0));
            world.func_180501_a(pos, state, 15);
            this.notifyOutputNeighbourOfStateChange(state, (World)world, pos);
        }

        @Override
        public BlockState update(BlockState state, World world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.func_177229_b((Property)POWERED)) {
                state = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered));
                if (powered) {
                    boolean trig = (Integer)state.func_177229_b((Property)STATE) == 0;
                    state = (BlockState)state.func_206870_a((Property)STATE, (Comparable)Integer.valueOf(1));
                    world.func_180501_a(pos, state, 15);
                    if (trig) {
                        this.notifyOutputNeighbourOfStateChange(state, world, pos);
                    }
                } else {
                    world.func_180501_a(pos, state, 15);
                }
            }
            if (!world.func_205220_G_().func_205359_a(pos, (Object)this)) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
            }
            return state;
        }
    }

    public static class BistableRelayBlock
    extends RelayBlock {
        public BistableRelayBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return (Integer)state.func_177229_b((Property)STATE) == 0 || redsrone_side != this.getOutputFacing(state).func_176734_d() ? 0 : 15;
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
        }

        @Override
        public BlockState update(BlockState state, World world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean pwstate;
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (pwstate = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue())) {
                return state;
            }
            state = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered && !pwstate) {
                state = (BlockState)state.func_206870_a((Property)STATE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)STATE) == 0 ? 1 : 0));
                world.func_180501_a(pos, state, 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else if (!powered && pwstate) {
                world.func_180501_a(pos, state, 15);
            }
            return state;
        }
    }

    public static class InvertedRelayBlock
    extends RelayBlock {
        private boolean lock_update = false;

        public InvertedRelayBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return (Boolean)state.func_177229_b((Property)POWERED) != false || redsrone_side != this.getOutputFacing(state).func_176734_d() ? 0 : 15;
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
            boolean powered = this.isPowered(state, (World)world, pos);
            if (powered == (Boolean)state.func_177229_b((Property)POWERED)) {
                return;
            }
            if (powered) {
                this.lock_update = true;
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 15);
                this.notifyOutputNeighbourOfStateChange(state, (World)world, pos);
                this.lock_update = false;
            }
        }

        @Override
        public BlockState update(BlockState state, World world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.func_177229_b((Property)POWERED)) {
                return state;
            }
            if (world.func_205220_G_().func_205359_a(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
            } else {
                this.lock_update = true;
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                this.lock_update = false;
            }
            return state;
        }
    }

    public static class RelayBlock
    extends DirectedComponentBlock {
        private boolean lock_update = false;

        protected boolean isPowered(BlockState state, World world, BlockPos pos) {
            Direction output_side = this.getOutputFacing(state);
            Direction mount_side = (Direction)state.func_177229_b((Property)FACING);
            for (Direction side : Direction.values()) {
                if (side == output_side || side == mount_side.func_176734_d() || world.func_175651_c(pos.func_177972_a(side), side) <= 0) continue;
                return true;
            }
            return false;
        }

        public RelayBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return (Boolean)state.func_177229_b((Property)POWERED) == false || redsrone_side != this.getOutputFacing(state).func_176734_d() ? 0 : 15;
        }

        @Override
        public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return this.func_180656_a(state, world, pos, redsrone_side);
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
            boolean powered = this.isPowered(state, (World)world, pos);
            if (powered == (Boolean)state.func_177229_b((Property)POWERED)) {
                return;
            }
            if (!powered) {
                this.lock_update = true;
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 15);
                this.notifyOutputNeighbourOfStateChange(state, (World)world, pos);
                this.lock_update = false;
            }
        }

        @Override
        public BlockState update(BlockState state, World world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.func_177229_b((Property)POWERED)) {
                return state;
            }
            if (world.func_205220_G_().func_205359_a(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                this.lock_update = true;
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                this.lock_update = false;
            } else {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
            }
            return state;
        }
    }

    public static class DirectedComponentBlock
    extends StandardBlocks.WaterLoggable {
        public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
        public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);
        public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
        public static final IntegerProperty STATE = IntegerProperty.func_177719_a((String)"state", (int)0, (int)1);
        protected final Map<BlockState, VoxelShape> shapes_ = new HashMap<BlockState, VoxelShape>();
        protected static final List<Direction> facing_mapping_ = new ArrayList<Direction>();

        protected static final VoxelShape mapped_shape(BlockState state, AxisAlignedBB aabb) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case DOWN: {
                    switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 2));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 3));
                        }
                    }
                }
                case UP: {
                    switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 0), Direction.Axis.Y));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 1), Direction.Axis.Y));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 2), Direction.Axis.Y));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 3), Direction.Axis.Y));
                        }
                    }
                }
                case NORTH: {
                    switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.DOWN));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.DOWN));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.DOWN));
                        }
                    }
                }
                case EAST: {
                    switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.WEST), 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP), 3));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 3));
                        }
                    }
                }
                case SOUTH: {
                    switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.UP));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP));
                        }
                    }
                }
                case WEST: {
                    switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.EAST));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.DOWN), Direction.WEST));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 1));
                        }
                    }
                }
            }
            return VoxelShapes.func_197868_b();
        }

        public DirectedComponentBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB aabb) {
            super(config, builder);
            this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(0))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)STATE, (Comparable)Integer.valueOf(0)));
            this.field_176227_L.func_177619_a().forEach(state -> this.shapes_.put((BlockState)state, DirectedComponentBlock.mapped_shape(state, aabb)));
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{FACING, ROTATION, POWERED, STATE});
        }

        public boolean hasTileEntity(BlockState state) {
            return false;
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, @Nullable TileEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((IItemProvider)this.func_199767_j()));
        }

        @Override
        public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
            return true;
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.shapes_.getOrDefault(state, VoxelShapes.func_197868_b());
        }

        @Override
        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
        }

        @Override
        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.DESTROY;
        }

        @Deprecated
        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return side == null || side != state.func_177229_b((Property)FACING);
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public boolean func_149740_M(BlockState state) {
            return false;
        }

        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            return 0;
        }

        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return 0;
        }

        @Deprecated
        public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return 0;
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if (state == null) {
                return state;
            }
            Direction face = context.func_196000_l().func_176734_d();
            Vector3d hit = context.func_221532_j().func_178788_d(Vector3d.func_237489_a_((Vector3i)context.func_195995_a()));
            switch (face) {
                case EAST: 
                case WEST: {
                    hit = hit.func_216372_d(0.0, 1.0, 1.0);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    hit = hit.func_216372_d(1.0, 1.0, 0.0);
                    break;
                }
                default: {
                    hit = hit.func_216372_d(1.0, 0.0, 1.0);
                }
            }
            Direction dir = Direction.func_210769_a((double)hit.func_82615_a(), (double)hit.func_82617_b(), (double)hit.func_82616_c());
            int rotation = 0;
            block4 : switch (face) {
                case DOWN: 
                case UP: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (dir) {
                        case SOUTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case NORTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (dir) {
                        case WEST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case EAST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (dir) {
                        case NORTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                }
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)FACING, (Comparable)face)).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rotation))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)STATE, (Comparable)Integer.valueOf(0));
            if (!this.func_196260_a(state, (IWorldReader)context.func_195991_k(), context.func_195995_a())) {
                return null;
            }
            return state;
        }

        @Override
        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            if ((state = super.func_196271_a(state, facing, facingState, world, pos, facingPos)) == null) {
                return state;
            }
            if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return world instanceof ServerWorld ? this.update(state, (World)((ServerWorld)world), pos, facingPos) : state;
        }

        public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
            Direction face = (Direction)state.func_177229_b((Property)FACING);
            BlockPos adj_pos = pos.func_177972_a(face);
            return world.func_180495_p(adj_pos).func_224755_d((IBlockReader)world, adj_pos, face.func_176734_d());
        }

        public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
            this.update(state, world, pos, null);
        }

        @Override
        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.func_203425_a(newState.func_177230_c())) {
                return;
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
            if (!world.func_201670_d()) {
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                world.func_195593_d(pos, (Block)this);
            }
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            this.update(state, world, pos, fromPos);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(World world, Random rand, BlockPos pos, Vector3f color, Direction side, float chance) {
            if (rand.nextFloat() < chance) {
                double c2 = chance * rand.nextFloat();
                double p0 = 0.5 + (double)side.func_82601_c() * 0.4 + c2 * 0.1;
                double p1 = 0.5 + (double)side.func_96559_d() * 0.4 + c2 * 0.1;
                double p2 = 0.5 + (double)side.func_82599_e() * 0.4 + c2 * 0.1;
                world.func_195594_a((IParticleData)new RedstoneParticleData(color.func_195899_a(), color.func_195900_b(), color.func_195902_c(), 1.0f), (double)pos.func_177958_n() + p0, (double)pos.func_177956_o() + p1, (double)pos.func_177952_p() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
            if (!((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() || (double)rand.nextFloat() > 0.4) {
                return;
            }
            Vector3f color = new Vector3f(0.6f, 0.0f, 0.0f);
            Direction side = (Direction)state.func_177229_b((Property)FACING);
            this.spawnPoweredParticle(world, rand, pos, color, side, 0.3f);
        }

        protected final Direction getOutputFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.func_177229_b((Property)FACING)).func_176745_a() * 4 + (Integer)state.func_177229_b((Property)ROTATION));
        }

        protected void notifyOutputNeighbourOfStateChange(BlockState state, World world, BlockPos pos) {
            Direction facing = this.getOutputFacing(state);
            BlockPos adjacent_pos = pos.func_177972_a(facing);
            BlockState adjacent_state = world.func_180495_p(adjacent_pos);
            try {
                adjacent_state.func_215697_a(world, adjacent_pos, (Block)this, pos, false);
                if (adjacent_state.shouldCheckWeakPower((IWorldReader)world, adjacent_pos, facing)) {
                    world.func_175695_a(adjacent_pos, state.func_177230_c(), facing.func_176734_d());
                }
            }
            catch (Throwable ex) {
                ModRedstonePen.logger().error("Track neighborChanged recursion detected, dropping!");
                Vector3d p = Vector3d.func_237489_a_((Vector3i)pos);
                world.func_217376_c((Entity)new ItemEntity(world, p.field_72450_a, p.field_72448_b, p.field_72449_c, new ItemStack((IItemProvider)this, 1)));
                world.func_180501_a(pos, world.func_180495_p(pos).func_204520_s().func_206883_i(), 18);
            }
        }

        public BlockState update(BlockState state, World world, BlockPos pos, @Nullable BlockPos fromPos) {
            return state;
        }

        static {
            Arrays.stream(Direction.values()).forEach(face -> {
                switch (face) {
                    case DOWN: {
                        facing_mapping_.add(Direction.NORTH);
                        facing_mapping_.add(Direction.EAST);
                        facing_mapping_.add(Direction.SOUTH);
                        facing_mapping_.add(Direction.WEST);
                        break;
                    }
                    case UP: {
                        facing_mapping_.add(Direction.NORTH);
                        facing_mapping_.add(Direction.EAST);
                        facing_mapping_.add(Direction.SOUTH);
                        facing_mapping_.add(Direction.WEST);
                        break;
                    }
                    case NORTH: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.EAST);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.WEST);
                        break;
                    }
                    case EAST: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.SOUTH);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.NORTH);
                        break;
                    }
                    case SOUTH: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.WEST);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.EAST);
                        break;
                    }
                    case WEST: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.NORTH);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.SOUTH);
                    }
                }
            });
        }
    }
}

