/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.ModContent;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.items.RedstonePenItem;
import wile.redstonepen.libmc.blocks.StandardBlocks;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.Networking;

public class RedstoneTrack {

    public static class TrackTileEntity
    extends TileEntity
    implements Networking.IPacketTileNotifyReceiver {
        private long state_flags_ = 0L;
        private final List<TrackNet> nets_ = new ArrayList<TrackNet>();
        private final Block[] block_change_tracking_ = new Block[]{Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a};
        private boolean trace_ = false;
        private static final List<Vector3i> updatepower_order = new ArrayList<Vector3i>();

        public TrackTileEntity() {
            this(ModContent.TET_TRACK);
        }

        public TrackTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public CompoundNBT readnbt(CompoundNBT nbt) {
            this.state_flags_ = nbt.func_74763_f("sflags");
            this.nets_.clear();
            if (nbt.func_150297_b("nets", 9)) {
                ListNBT lst = nbt.func_150295_c("nets", 10);
                try {
                    for (int i = 0; i < lst.size(); ++i) {
                        CompoundNBT route_nbt = lst.func_150305_b(i);
                        this.nets_.add(new TrackNet(Arrays.stream(route_nbt.func_197645_o("npos")).mapToObj(lpos -> BlockPos.func_218283_e((long)lpos)).collect(Collectors.toList()), Arrays.stream(route_nbt.func_74759_k("nsid")).mapToObj(Direction::func_82600_a).collect(Collectors.toList()), Arrays.stream(route_nbt.func_74759_k("ifac")).mapToObj(Direction::func_82600_a).collect(Collectors.toList()), Arrays.stream(route_nbt.func_74759_k("pfac")).mapToObj(Direction::func_82600_a).collect(Collectors.toList()), route_nbt.func_74762_e("power")));
                    }
                }
                catch (Throwable ex) {
                    this.nets_.clear();
                    Auxiliaries.logError("Dropped invalid NBT for Redstone Track at pos " + this.func_174877_v());
                }
            }
            return nbt;
        }

        private CompoundNBT writenbt(CompoundNBT nbt) {
            return this.writenbt(nbt, false);
        }

        private CompoundNBT writenbt(CompoundNBT nbt, boolean sync_packet) {
            nbt.func_74772_a("sflags", this.state_flags_);
            if (sync_packet) {
                return nbt;
            }
            if (!this.nets_.isEmpty()) {
                ListNBT lst = new ListNBT();
                for (TrackNet net : this.nets_) {
                    CompoundNBT route_nbt = new CompoundNBT();
                    route_nbt.func_74768_a("power", net.power);
                    route_nbt.func_218657_a("npos", (INBT)new LongArrayNBT(net.neighbour_positions.stream().map(BlockPos::func_218275_a).collect(Collectors.toList())));
                    route_nbt.func_218657_a("nsid", (INBT)new IntArrayNBT(net.neighbour_sides.stream().map(Direction::func_176745_a).collect(Collectors.toList())));
                    route_nbt.func_218657_a("ifac", (INBT)new IntArrayNBT(net.internal_sides.stream().map(Direction::func_176745_a).collect(Collectors.toList())));
                    route_nbt.func_218657_a("pfac", (INBT)new IntArrayNBT(net.power_sides.stream().map(Direction::func_176745_a).collect(Collectors.toList())));
                    lst.add((Object)route_nbt);
                }
                nbt.func_218657_a("nets", (INBT)lst);
            }
            return nbt;
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public CompoundNBT func_189517_E_() {
            CompoundNBT nbt = super.func_189517_E_();
            this.writenbt(nbt, true);
            return nbt;
        }

        @Nullable
        public SUpdateTileEntityPacket func_189518_D_() {
            return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
            this.readnbt(pkt.func_148857_g());
            super.onDataPacket(net, pkt);
        }

        public void handleUpdateTag(BlockState state, CompoundNBT tag) {
            this.func_230337_a_(state, tag);
        }

        @Override
        public void onServerPacketReceived(CompoundNBT nbt) {
            this.readnbt(nbt);
        }

        @Override
        public void onClientPacketReceived(PlayerEntity player, CompoundNBT nbt) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public double func_145833_n() {
            return 64.0;
        }

        public boolean sync(boolean schedule) {
            if (this.field_145850_b.func_201670_d()) {
                return true;
            }
            this.func_70296_d();
            if (schedule && !this.func_145831_w().func_205220_G_().func_205359_a(this.func_174877_v(), (Object)ModContent.TRACK_BLOCK)) {
                this.func_145831_w().func_205220_G_().func_205360_a(this.func_174877_v(), (Object)ModContent.TRACK_BLOCK, 1);
            } else {
                Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new CompoundNBT(), true));
            }
            return true;
        }

        public long getStateFlags() {
            return this.state_flags_;
        }

        public int addWireFlags(long flags) {
            int n_added = 0;
            for (int i = 0; i < this.getWireFlagCount(); ++i) {
                long mask = 1L << i;
                if ((flags & mask) == 0L || (this.state_flags_ & mask) != 0L) continue;
                this.state_flags_ |= mask;
                ++n_added;
            }
            return n_added;
        }

        public int getWireFlags() {
            return (int)((this.state_flags_ & 0xFFFFFFL) >> 0);
        }

        public boolean getWireFlag(int index) {
            return (this.state_flags_ & 1L << 0 + index) != 0L;
        }

        public int getWireFlagCount() {
            return 24;
        }

        public int getConnectionFlags() {
            return (int)((this.state_flags_ & 0x3F000000L) >> 24);
        }

        public boolean getConnectionFlag(int index) {
            return (this.state_flags_ & 1L << 24 + index) != 0L;
        }

        public int getConnectionFlagCount() {
            return 6;
        }

        public int getSidePower(Direction side) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            return (int)(this.state_flags_ >> shift & 0xFL);
        }

        public void setSidePower(Direction side, int p) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            this.state_flags_ = this.state_flags_ & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | (long)(p & 0xF) << shift;
        }

        public boolean hasVanillaRedstoneConnection(Direction side) {
            return defs.connections.hasVanillaWireConnection(this.getStateFlags(), side) || (this.state_flags_ & defs.connections.getBulkConnectorBit(side)) != 0L;
        }

        public int getRedstonePower(Direction redstone_side, boolean weak) {
            Direction own_side = redstone_side.func_176734_d();
            int p = 0;
            for (TrackNet net : this.nets_) {
                if (!net.power_sides.contains(own_side) || (p = Math.max(p, net.power)) < 15) continue;
                break;
            }
            int n = p = p <= 0 || !this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(own_side)).func_203425_a(Blocks.field_150488_af) ? p : p - 1;
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("POWR: %12s(%s)==%d", this.posstr(this.func_174877_v()), redstone_side.toString(), p));
            }
            return p;
        }

        public int getRedstoneDustCount() {
            int i;
            int n = 0;
            int rem = this.getWireFlags();
            for (i = 0; rem != 0 && i < 24; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            rem = this.getConnectionFlags();
            for (i = 0; rem != 0 && i < 6; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            return n;
        }

        public void toggle_trace(@Nullable PlayerEntity player) {
            boolean bl = this.trace_ = !this.trace_;
            if (player != null) {
                Auxiliaries.playerChatMessage(player, "Trace: " + this.trace_);
            }
        }

        public int handleActivation(BlockPos pos, PlayerEntity player, Hand hand, Direction clicked_face, Vector3d hitvec, boolean remove_only) {
            ItemStack used_stack = player.func_184586_b(hand);
            if (!used_stack.func_190926_b() && used_stack.func_77973_b() != Items.field_151137_ax && !RedstonePenItem.isPen(used_stack)) {
                return 0;
            }
            Direction face = clicked_face.func_176734_d();
            Vector3d hit = hitvec.func_178788_d(Vector3d.func_237489_a_((Vector3i)pos));
            switch (clicked_face) {
                case EAST: 
                case WEST: {
                    hit = hit.func_216372_d(0.0, 1.0, 1.0);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    hit = hit.func_216372_d(1.0, 1.0, 0.0);
                    break;
                }
                default: {
                    hit = hit.func_216372_d(1.0, 0.0, 1.0);
                }
            }
            Direction dir = Direction.func_210769_a((double)hit.func_82615_a(), (double)hit.func_82617_b(), (double)hit.func_82616_c());
            long flip_mask = hit.func_72433_c() < 0.12 && (!remove_only || this.getConnectionFlags() != 0) ? (((long)this.getWireFlags() & defs.connections.getAllElementsOnFace(face)) != 0L ? defs.connections.getBulkConnectorBit(face) : defs.connections.getWireBit(face, dir)) : defs.connections.getWireBit(face, dir);
            int material_use = 0;
            if ((this.state_flags_ & flip_mask) != 0L) {
                this.state_flags_ &= flip_mask ^ 0xFFFFFFFFFFFFFFFFL;
                --material_use;
                long bc = defs.connections.getBulkConnectorBit(face);
                if ((this.state_flags_ & defs.connections.getAllElementsOnFace(face)) == bc) {
                    this.state_flags_ &= bc ^ 0xFFFFFFFFFFFFFFFFL;
                    --material_use;
                }
                if (this.getWireFlags() == 0) {
                    material_use -= this.getRedstoneDustCount();
                    this.state_flags_ = 0L;
                }
            } else if (!used_stack.func_190926_b() && !remove_only) {
                boolean can_place = false;
                for (Direction side : Direction.values()) {
                    if ((defs.connections.getAllElementsOnFace(side) & flip_mask) == 0L) continue;
                    can_place = true;
                    break;
                }
                if (can_place) {
                    this.state_flags_ |= flip_mask;
                    ++material_use;
                }
            }
            if (material_use != 0) {
                this.setSidePower(face, 0);
                Map<BlockPos, BlockPos> change_notifications_before = this.updateAllPowerValuesFromAdjacent();
                this.updateConnections(0);
                this.setSidePower(face, 0);
                Map<BlockPos, BlockPos> change_notifications_after = this.updateAllPowerValuesFromAdjacent();
                List<Map.Entry> disconnected = change_notifications_before.entrySet().stream().filter(kv -> !change_notifications_after.containsKey(kv.getKey())).collect(Collectors.toList());
                List<Map.Entry> connected = change_notifications_after.entrySet().stream().filter(kv -> !change_notifications_before.containsKey(kv.getKey())).collect(Collectors.toList());
                this.setSidePower(face, 0);
                this.nets_.forEach(net -> {
                    if (net.internal_sides.contains(face)) {
                        net.power = 0;
                    }
                });
                disconnected.forEach(kv -> {
                    TileEntity te = this.func_145831_w().func_175625_s((BlockPos)kv.getKey());
                    this.func_145831_w().func_180495_p((BlockPos)kv.getKey()).func_215697_a(this.func_145831_w(), (BlockPos)kv.getKey(), (Block)this.getBlock(), (BlockPos)kv.getValue(), false);
                    if (te instanceof TrackTileEntity) {
                        ((TrackTileEntity)te).updateConnections(1);
                    }
                });
                connected.forEach(kv -> {
                    TileEntity te = this.func_145831_w().func_175625_s((BlockPos)kv.getKey());
                    if (te instanceof TrackTileEntity) {
                        ((TrackTileEntity)te).updateConnections(1);
                    }
                    this.func_145831_w().func_180495_p((BlockPos)kv.getKey()).func_215697_a(this.func_145831_w(), (BlockPos)kv.getKey(), (Block)this.getBlock(), (BlockPos)kv.getValue(), false);
                    this.getBlock().func_220069_a(this.func_195044_w(), this.func_145831_w(), this.func_174877_v(), this.getBlock(), (BlockPos)kv.getKey(), false);
                });
                this.sync(true);
            }
            return material_use;
        }

        public Map<BlockPos, BlockPos> updateAllPowerValuesFromAdjacent() {
            if (updatepower_order.isEmpty()) {
                for (Direction side : Direction.values()) {
                    updatepower_order.add(new Vector3i(0, 0, 0).func_177967_a(side, 1));
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 2) continue;
                            updatepower_order.add(new Vector3i(x, y, z));
                        }
                    }
                }
            }
            HashMap<BlockPos, BlockPos> all_change_notifications = new HashMap<BlockPos, BlockPos>();
            for (Vector3i ofs : updatepower_order) {
                this.handleNeighborChanged(this.func_174877_v().func_177971_a(ofs)).forEach((key, value) -> all_change_notifications.putIfAbsent((BlockPos)key, (BlockPos)value));
            }
            return all_change_notifications;
        }

        private void spawnRedsoneItems(int count) {
            if (count <= 0) {
                return;
            }
            ItemEntity e = new ItemEntity(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            e.func_174869_p();
            e.func_92058_a(new ItemStack((IItemProvider)Items.field_151137_ax, count));
            e.func_213317_d(new Vector3d(this.func_145831_w().func_201674_k().nextDouble() - 0.5, this.func_145831_w().func_201674_k().nextDouble() - 0.5, this.func_145831_w().func_201674_k().nextDouble()).func_186678_a(0.1));
            this.func_145831_w().func_217376_c((Entity)e);
        }

        private RedstoneTrackBlock getBlock() {
            return ModContent.TRACK_BLOCK;
        }

        public boolean handlePostPlacement(Direction facing, BlockState facingState, BlockPos fromPos) {
            if (!RedstoneTrackBlock.canBePlacedOnFace(facingState, this.func_145831_w(), fromPos, facing.func_176734_d())) {
                long to_remove = defs.connections.getAllElementsOnFace(facing);
                long new_flags = this.state_flags_ & (to_remove ^ 0xFFFFFFFFFFFFFFFFL);
                if (new_flags != this.state_flags_) {
                    int count = this.getRedstoneDustCount();
                    this.state_flags_ = new_flags;
                    this.spawnRedsoneItems(count -= this.getRedstoneDustCount());
                    this.updateConnections();
                    this.handleNeighborChanged(fromPos);
                } else if (this.block_change_tracking_[facing.func_176745_a()] != facingState.func_177230_c()) {
                    this.block_change_tracking_[facing.func_176745_a()] = facingState.func_177230_c();
                    this.updateConnections();
                    this.handleNeighborChanged(fromPos);
                }
            }
            return this.getWireFlags() != 0;
        }

        private int getNonWireSignal(World world, BlockPos pos, Direction redstone_side) {
            int p_in;
            Direction rs_side;
            BlockPos side_pos;
            BlockState side_state;
            int p;
            this.getBlock().disablePower(true);
            BlockState state = world.func_180495_p(pos);
            int n = p = !state.func_203425_a(Blocks.field_150488_af) && !state.func_203425_a((Block)this.getBlock()) ? state.func_185911_a((IBlockReader)world, pos, redstone_side) : 0;
            if (!state.shouldCheckWeakPower((IWorldReader)world, pos, redstone_side)) {
                this.getBlock().disablePower(false);
                return p;
            }
            Direction[] directionArray = Direction.values();
            int n2 = directionArray.length;
            for (int i = 0; i < n2 && ((side_state = world.func_180495_p(side_pos = pos.func_177972_a(rs_side = directionArray[i]))).func_203425_a(Blocks.field_150488_af) || side_state.func_203425_a((Block)this.getBlock()) || (p_in = side_state.func_185893_b((IBlockReader)world, side_pos, rs_side)) <= p || (p = p_in) < 15); ++i) {
            }
            this.getBlock().disablePower(false);
            return p;
        }

        public Map<BlockPos, BlockPos> handleNeighborChanged(BlockPos fromPos) {
            HashMap<BlockPos, BlockPos> change_notifications = new HashMap<BlockPos, BlockPos>();
            boolean power_changed = false;
            for (TrackNet net : this.nets_) {
                if (!net.neighbour_positions.contains(fromPos)) continue;
                int pmax = 0;
                for (int i = 0; i < net.neighbour_positions.size(); ++i) {
                    BlockPos ext_pos = net.neighbour_positions.get(i);
                    change_notifications.put(ext_pos, this.func_174877_v());
                    if (pmax >= 15) continue;
                    Direction ext_side = net.neighbour_sides.get(i);
                    BlockState ext_state = this.field_145850_b.func_180495_p(ext_pos);
                    if (ext_state.func_203425_a(Blocks.field_150488_af)) {
                        int p_vanilla_wire = Math.max(0, (Integer)ext_state.func_177229_b((Property)RedstoneWireBlock.field_176351_O) - 1);
                        pmax = Math.max(pmax, p_vanilla_wire);
                        continue;
                    }
                    if (ext_state.func_203425_a((Block)this.getBlock())) {
                        int p_track = RedstoneTrackBlock.tile((IBlockReader)this.func_145831_w(), ext_pos).map(te -> Math.max(0, te.getSidePower(ext_side) - 1)).orElse(0);
                        pmax = Math.max(pmax, p_track);
                        continue;
                    }
                    Direction eside = ext_side.func_176734_d();
                    int p_nowire = this.getNonWireSignal(this.func_145831_w(), ext_pos, eside);
                    pmax = Math.max(pmax, p_nowire);
                    if (ext_state.func_185897_m() || p_nowire != 0) continue;
                    if (ext_side != Direction.DOWN) {
                        change_notifications.putIfAbsent(ext_pos.func_177972_a(Direction.DOWN), ext_pos);
                    }
                    if (ext_side != Direction.UP) {
                        change_notifications.putIfAbsent(ext_pos.func_177972_a(Direction.UP), ext_pos);
                    }
                    if (ext_side != Direction.NORTH) {
                        change_notifications.putIfAbsent(ext_pos.func_177972_a(Direction.NORTH), ext_pos);
                    }
                    if (ext_side != Direction.SOUTH) {
                        change_notifications.putIfAbsent(ext_pos.func_177972_a(Direction.SOUTH), ext_pos);
                    }
                    if (ext_side != Direction.EAST) {
                        change_notifications.putIfAbsent(ext_pos.func_177972_a(Direction.EAST), ext_pos);
                    }
                    if (ext_side == Direction.WEST) continue;
                    change_notifications.putIfAbsent(ext_pos.func_177972_a(Direction.WEST), ext_pos);
                }
                if (net.power != pmax) {
                    net.power = pmax;
                    power_changed = true;
                }
                for (Direction side : net.internal_sides) {
                    if (this.getSidePower(side) == pmax) continue;
                    this.setSidePower(side, pmax);
                    power_changed = true;
                }
            }
            if (power_changed) {
                if (this.trace_ && change_notifications.size() > 0) {
                    Auxiliaries.logWarn(String.format("CHNOT: (%s) updates: [%s]", this.posstr(this.func_174877_v()), change_notifications.entrySet().stream().map(kv -> this.posstr((BlockPos)kv.getKey()) + ">" + this.posstr((BlockPos)kv.getValue())).collect(Collectors.joining(" ; "))));
                }
                this.sync(true);
                return change_notifications;
            }
            return Collections.emptyMap();
        }

        private final String posstr(BlockPos pos) {
            return "[" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]";
        }

        private boolean isRedstoneInsulator(BlockState state) {
            return state.func_185904_a() == Material.field_151592_s;
        }

        private void updateConnections() {
            this.updateConnections(1);
        }

        private void updateConnections(int recursion_left) {
            this.nets_.clear();
            HashSet<TrackTileEntity> track_connection_updates = new HashSet<TrackTileEntity>();
            long[] internal_connected_sides = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long[] external_connected_routes = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long external_connection_flags = this.getStateFlags() & 0x3FFFFFFFL;
            for (Map.Entry kv : defs.connections.INTERNAL_EDGE_CONNECTION_MAPPING.entrySet()) {
                long wire_bit_pair = (Long)kv.getKey();
                if ((this.getStateFlags() & wire_bit_pair) != wire_bit_pair) continue;
                external_connection_flags &= wire_bit_pair ^ 0xFFFFFFFFFFFFFFFFL;
                for (int i = 0; i < 6; ++i) {
                    if ((15L << 4 * i & wire_bit_pair) == 0L) continue;
                    int n = i;
                    internal_connected_sides[n] = internal_connected_sides[n] | wire_bit_pair;
                }
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON %s AA: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.func_174877_v()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
            }
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < 6; ++i) {
                    if (internal_connected_sides[i] == 0L) continue;
                    for (int j = i + 1; j < 6; ++j) {
                        if ((internal_connected_sides[i] & internal_connected_sides[j]) == 0L) continue;
                        int n = i;
                        internal_connected_sides[n] = internal_connected_sides[n] | internal_connected_sides[j];
                        internal_connected_sides[j] = 0L;
                    }
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (internal_connected_sides[i] != 0L) {
                    for (int j = i; j < 6; ++j) {
                        long mask = 15L << 4 * j;
                        if ((internal_connected_sides[i] & mask) == 0L) continue;
                        long bulk = 1L << 24 + j;
                        int n = i;
                        external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                        external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    continue;
                }
                long mask = 15L << 4 * i;
                long bulk = 1L << 24 + i;
                int n = i;
                external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s B1: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.func_174877_v()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s B2: ext:%08x | ext:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.func_174877_v()), external_connection_flags, external_connected_routes[0], external_connected_routes[1], external_connected_routes[2], external_connected_routes[3], external_connected_routes[4], external_connected_routes[5]));
            }
            HashSet used_sides = new HashSet();
            for (int i = 0; i < 6; ++i) {
                if (external_connected_routes[i] == 0L) continue;
                HashSet<Direction> power_sides = new HashSet<Direction>();
                HashSet<Direction> internal_sides = new HashSet<Direction>();
                ArrayList<BlockPos> block_positions = new ArrayList<BlockPos>(6);
                ArrayList<Direction> block_sides = new ArrayList<Direction>(6);
                for (int j = 0; j < 6; ++j) {
                    long mask = 15L << 4 * j;
                    long bulk = 1L << 24 + j;
                    Direction side2 = defs.connections.CONNECTION_BIT_ORDER[j];
                    if ((internal_connected_sides[i] & mask) != 0L) {
                        internal_sides.add(side2);
                    }
                    if ((external_connected_routes[i] & mask) != 0L) {
                        for (int k = 0; k < 4; ++k) {
                            long wire_bit = 1L << 4 * j + k;
                            if ((external_connected_routes[i] & wire_bit) == 0L) continue;
                            Tuple<Direction, Direction> side_dir = defs.connections.getWireBitSideAndDirection(wire_bit);
                            Direction tsid = (Direction)side_dir.func_76341_a();
                            Direction tdir = (Direction)side_dir.func_76340_b();
                            BlockPos wire_pos = this.func_174877_v().func_177972_a(tdir);
                            BlockState wire_state = this.func_145831_w().func_180495_p(wire_pos);
                            boolean diagonal_check = false;
                            if (wire_state.func_203425_a((Block)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tsid, tdir.func_176734_d());
                                TrackTileEntity adj_te = RedstoneTrackBlock.tile((IBlockReader)this.func_145831_w(), wire_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) {
                                    diagonal_check = true;
                                } else {
                                    block_positions.add(wire_pos);
                                    block_sides.add(tsid);
                                    internal_sides.add(side2);
                                    power_sides.add(tdir);
                                    track_connection_updates.add(adj_te);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.func_203425_a(Blocks.field_150488_af)) {
                                if (side2 != Direction.DOWN) {
                                    diagonal_check = true;
                                } else {
                                    block_positions.add(wire_pos);
                                    block_sides.add(tdir.func_176734_d());
                                    internal_sides.add(side2);
                                    power_sides.add(tdir);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.func_185897_m()) {
                                block_positions.add(wire_pos);
                                block_sides.add(tdir.func_176734_d());
                                internal_sides.add(side2);
                                power_sides.add(tdir);
                                continue;
                            }
                            BlockPos track_pos = wire_pos.func_177972_a(tsid);
                            BlockState track_state = this.func_145831_w().func_180495_p(track_pos);
                            if (track_state.func_203425_a((Block)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tdir.func_176734_d(), tsid.func_176734_d());
                                TrackTileEntity adj_te = RedstoneTrackBlock.tile((IBlockReader)this.func_145831_w(), track_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) continue;
                                block_positions.add(track_pos);
                                block_sides.add(tdir.func_176734_d());
                                power_sides.add(tdir);
                                internal_sides.add(side2);
                                track_connection_updates.add(adj_te);
                                continue;
                            }
                            if (this.isRedstoneInsulator(wire_state)) continue;
                            block_positions.add(wire_pos);
                            block_sides.add(tdir.func_176734_d());
                            internal_sides.add(side2);
                            power_sides.add(tdir);
                        }
                    }
                    if ((external_connected_routes[i] & bulk) == 0L) continue;
                    BlockPos bulk_pos = this.func_174877_v().func_177972_a(side2);
                    BlockState bulk_state = this.func_145831_w().func_180495_p(bulk_pos);
                    if (this.isRedstoneInsulator(bulk_state)) continue;
                    block_positions.add(bulk_pos);
                    block_sides.add(side2.func_176734_d());
                    internal_sides.add(side2);
                    power_sides.add(side2);
                }
                if (block_positions.isEmpty()) continue;
                this.nets_.add(new TrackNet(block_positions, block_sides, new ArrayList<Direction>(internal_sides), new ArrayList<Direction>(power_sides)));
                used_sides.addAll(internal_sides);
            }
            Arrays.stream(Direction.values()).filter(side -> !used_sides.contains(side)).forEach(side -> this.setSidePower((Direction)side, 0));
            this.func_70296_d();
            String poss = this.posstr(this.func_174877_v());
            for (TrackNet net : this.nets_) {
                ArrayList<String> ss = new ArrayList<String>();
                for (int i = 0; i < net.neighbour_positions.size(); ++i) {
                    ss.add(this.posstr(net.neighbour_positions.get(i)) + ":" + net.neighbour_sides.get(i).toString());
                }
                String int_sides = net.internal_sides.stream().map(Direction::toString).collect(Collectors.joining(","));
                String pwr_sides = net.power_sides.stream().map(Direction::toString).collect(Collectors.joining(","));
                if (!this.trace_) continue;
                Auxiliaries.logWarn(String.format("UCON %s: adj:%s | ints:%s | pwrs:%s", poss, String.join((CharSequence)", ", ss), int_sides, pwr_sides));
            }
            if (recursion_left > 0) {
                for (TrackTileEntity te : track_connection_updates) {
                    if (this.trace_) {
                        Auxiliaries.logWarn(String.format("UCON %s: UPDATE NET OF %s", this.posstr(this.func_174877_v()), this.posstr(te.func_174877_v())));
                    }
                    te.updateConnections(recursion_left - 1);
                }
            }
        }

        public static class TrackNet {
            public final List<BlockPos> neighbour_positions;
            public final List<Direction> neighbour_sides;
            public final List<Direction> internal_sides;
            public final List<Direction> power_sides;
            public int power;

            public TrackNet(List<BlockPos> positions, List<Direction> ext_sides, List<Direction> int_sides, List<Direction> pwr_sides) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = 0;
            }

            public TrackNet(List<BlockPos> positions, List<Direction> ext_sides, List<Direction> int_sides, List<Direction> pwr_sides, int power_setval) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = power_setval;
            }
        }
    }

    public static class RedstoneTrackBlock
    extends StandardBlocks.WaterLoggable {
        private boolean can_provide_power_ = true;

        public RedstoneTrackBlock(long config, AbstractBlock.Properties builder) {
            super(config, builder);
        }

        public static Optional<TrackTileEntity> tile(IBlockReader world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof TrackTileEntity && !te.func_145837_r() ? Optional.of((TrackTileEntity)te) : Optional.empty();
        }

        public static boolean canBePlacedOnFace(BlockState state, World world, BlockPos pos, Direction face) {
            if (state.func_177230_c() instanceof PistonBlock) {
                Direction pface = (Direction)state.func_177229_b((Property)PistonBlock.field_176387_N);
                return face != pface;
            }
            if (state.func_177230_c() instanceof MovingPistonBlock) {
                return true;
            }
            if (state.func_203425_a(Blocks.field_150438_bZ)) {
                return face == Direction.UP;
            }
            return state.func_224755_d((IBlockReader)world, pos, face);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TrackTileEntity();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, @Nullable TileEntity te, boolean explosion) {
            if (!(te instanceof TrackTileEntity)) {
                return Collections.emptyList();
            }
            int num_connections = ((TrackTileEntity)te).getRedstoneDustCount();
            if (num_connections <= 0) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new ItemStack((IItemProvider)Items.field_151137_ax, num_connections));
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return context.func_195991_k().func_180495_p(context.func_195995_a()).func_196953_a(context) ? super.func_196258_a(context) : null;
        }

        public Item func_199767_j() {
            return Items.field_151137_ax;
        }

        @Override
        public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
            return true;
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            int wires = RedstoneTrackBlock.tile(world, pos).map(TrackTileEntity::getWireFlags).orElse(0);
            int faces = ((wires & 0xF) != 0 ? 1 : 0) | ((wires & 0xF0) != 0 ? 2 : 0) | ((wires & 0xF00) != 0 ? 4 : 0) | ((wires & 0xF000) != 0 ? 8 : 0) | ((wires & 0xF0000) != 0 ? 16 : 0) | ((wires & 0xF00000) != 0 ? 32 : 0);
            return defs.shape.get(faces);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return VoxelShapes.func_197880_a();
        }

        @Override
        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
        }

        @Override
        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.DESTROY;
        }

        public boolean func_220074_n(BlockState state) {
            return true;
        }

        @Deprecated
        public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
            return 0;
        }

        @Deprecated
        public BlockRenderType func_149645_b(BlockState state) {
            return BlockRenderType.ENTITYBLOCK_ANIMATED;
        }

        public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
            return true;
        }

        @Deprecated
        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return side != null && RedstoneTrackBlock.tile(world, pos).map(te -> te.hasVanillaRedstoneConnection(side.func_176734_d())).orElse(false) != false;
        }

        public boolean func_149744_f(BlockState state) {
            return this.can_provide_power_;
        }

        public boolean func_149740_M(BlockState state) {
            return false;
        }

        @Deprecated
        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            return 0;
        }

        @Deprecated
        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redsrone_side, true)).orElse(0) : 0;
        }

        @Deprecated
        public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction redsrone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redsrone_side, false)).orElse(0) : 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
            if (!RedstoneTrackBlock.tile((IBlockReader)world, pos).map(te -> te.sync(false)).orElse(false).booleanValue()) {
                world.func_217377_a(pos, false);
            }
        }

        @Override
        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            if (!world.func_201670_d()) {
                if (RedstoneTrackBlock.tile((IBlockReader)world, pos).map(te -> te.handlePostPlacement(facing, facingState, facingPos)).orElse(true).booleanValue()) {
                    world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
                } else {
                    world.func_217377_a(pos, false);
                }
            }
            return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
        }

        public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
            if (oldState.func_203425_a(state.func_177230_c()) || world.func_201670_d()) {
                return;
            }
            RedstoneTrackBlock.tile((IBlockReader)world, pos).ifPresent(te -> ((TrackTileEntity)te).updateConnections());
            this.notifyAdjacent(world, pos);
        }

        @Override
        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.func_203425_a(newState.func_177230_c())) {
                return;
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
            if (world.func_201670_d()) {
                return;
            }
            this.notifyAdjacent(world, pos);
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rtr) {
            return this.onBlockActivated(state, world, pos, player, hand, rtr, false);
        }

        public ActionResultType onBlockActivated(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rtr, boolean remove_only) {
            TrackTileEntity te;
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b() && stack.func_77973_b() != Items.field_151137_ax && !RedstonePenItem.isPen(stack)) {
                BlockPos behind_pos = pos.func_177972_a(rtr.func_216354_b());
                BlockState behind_state = world.func_180495_p(behind_pos);
                if (behind_state.func_215686_e((IBlockReader)world, behind_pos)) {
                    return behind_state.func_177230_c().func_225533_a_(behind_state, world, behind_pos, player, hand, rtr);
                }
                return ActionResultType.PASS;
            }
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            if (!RedstonePenItem.hasEnoughRedstone(player.func_184586_b(hand), 1, player)) {
                remove_only = true;
            }
            if ((te = (TrackTileEntity)RedstoneTrackBlock.tile((IBlockReader)world, pos).orElse(null)) == null) {
                return ActionResultType.FAIL;
            }
            int redstone_use = te.handleActivation(pos, player, hand, rtr.func_216354_b(), rtr.func_216347_e(), remove_only);
            if (redstone_use == 0) {
                return ActionResultType.PASS;
            }
            if (redstone_use < 0) {
                RedstonePenItem.pushRedstone(player.func_184586_b(hand), -redstone_use, player);
                if (te.getWireFlags() == 0) {
                    world.func_180501_a(pos, state.func_204520_s().func_206883_i(), 3);
                } else {
                    Map<BlockPos, BlockPos> blocks_to_update = te.updateAllPowerValuesFromAdjacent();
                    for (Map.Entry<BlockPos, BlockPos> update_pos : blocks_to_update.entrySet()) {
                        world.func_190524_a(update_pos.getKey(), (Block)this, update_pos.getValue());
                    }
                }
                world.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 0.4f, 2.0f);
            } else {
                RedstonePenItem.popRedstone(player.func_184586_b(hand), redstone_use, player, hand);
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 0.4f, 2.4f);
            }
            state.func_235734_a_((IWorld)world, pos, 3);
            this.notifyAdjacent(world, pos);
            return ActionResultType.CONSUME;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            block5: {
                if (world.func_201670_d()) {
                    return;
                }
                Map blocks_to_update = RedstoneTrackBlock.tile((IBlockReader)world, pos).map(te -> te.handleNeighborChanged(fromPos)).orElse(Collections.emptyMap());
                if (blocks_to_update.isEmpty()) {
                    return;
                }
                try {
                    for (Map.Entry update_pos : blocks_to_update.entrySet()) {
                        world.func_190524_a((BlockPos)update_pos.getKey(), (Block)this, (BlockPos)update_pos.getValue());
                    }
                }
                catch (Throwable ex) {
                    ModRedstonePen.logger().error("Track neighborChanged recursion detected, dropping!");
                    int num_redstone = RedstoneTrackBlock.tile((IBlockReader)world, pos).map(te -> te.getRedstoneDustCount()).orElse(0);
                    if (num_redstone <= 0) break block5;
                    Vector3d p = Vector3d.func_237489_a_((Vector3i)pos);
                    world.func_217376_c((Entity)new ItemEntity(world, p.field_72450_a, p.field_72448_b, p.field_72449_c, new ItemStack((IItemProvider)Items.field_151137_ax, num_redstone)));
                    world.func_180501_a(pos, world.func_180495_p(pos).func_204520_s().func_206883_i(), 18);
                }
            }
        }

        public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags, int recursionLeft) {
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(World world, Random rand, BlockPos pos, Vector3f color, Direction from, Direction to, float minChance, float maxChance) {
            float f = maxChance - minChance;
            if (rand.nextFloat() < 0.3f * f) {
                double c1 = 0.4375;
                double c2 = minChance + f * rand.nextFloat();
                double p0 = 0.5 + c1 * (double)from.func_82601_c() + c2 * 0.4 * (double)to.func_82601_c();
                double p1 = 0.5 + c1 * (double)from.func_96559_d() + c2 * 0.4 * (double)to.func_96559_d();
                double p2 = 0.5 + c1 * (double)from.func_82599_e() + c2 * 0.4 * (double)to.func_82599_e();
                world.func_195594_a((IParticleData)new RedstoneParticleData(color.func_195899_a(), color.func_195900_b(), color.func_195902_c(), 1.0f), (double)pos.func_177958_n() + p0, (double)pos.func_177956_o() + p1, (double)pos.func_177952_p() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
            if ((double)rand.nextFloat() > 0.4) {
                return;
            }
            TrackTileEntity te = RedstoneTrackBlock.tile((IBlockReader)world, pos).orElse(null);
            if (te == null || (te.getStateFlags() & 0xFFFFFF00000000L) == 0L) {
                return;
            }
            Vector3f color = new Vector3f(0.6f, 0.0f, 0.0f);
            for (Direction side : Direction.values()) {
                int p = te.getSidePower(side);
                if (p == 0) continue;
                this.spawnPoweredParticle(world, rand, pos, color, side, side.func_176734_d(), -0.5f, 0.5f);
            }
        }

        public void checkSmartPlacement(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rtr) {
            Direction odir;
            BlockPos opos;
            BlockState ostate;
            if (world.func_201670_d()) {
                return;
            }
            ItemStack pen = player.func_184586_b(hand);
            if (!RedstonePenItem.hasEnoughRedstone(pen, 2, player)) {
                return;
            }
            TrackTileEntity te = RedstoneTrackBlock.tile((IBlockReader)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            Tuple<Direction, Direction> side_dir = defs.connections.getWireBitSideAndDirection(te.getWireFlags());
            Direction face = (Direction)side_dir.func_76341_a();
            Direction dir = (Direction)side_dir.func_76340_b();
            if (face == Direction.DOWN && dir == Direction.DOWN) {
                return;
            }
            int num_placed = 0;
            long flags_to_add = 0L;
            for (Direction d : Direction.values()) {
                TrackTileEntity ote;
                BlockState ostate2;
                if (!RedstonePenItem.hasEnoughRedstone(pen, num_placed, player)) {
                    return;
                }
                if (d == face || d == face.func_176734_d() || d == dir || !(ostate2 = world.func_180495_p(pos.func_177972_a(d))).func_203425_a((Block)this) || (ote = (TrackTileEntity)RedstoneTrackBlock.tile((IBlockReader)world, pos.func_177972_a(d)).orElse(null)) == null) continue;
                int oflags = ote.getWireFlags();
                if ((defs.connections.getWireBit(face, d.func_176734_d()) & (long)oflags) == 0L) continue;
                flags_to_add |= defs.connections.getWireBit(face, d);
                ++num_placed;
            }
            if (num_placed == 0 && !(ostate = world.func_180495_p(opos = pos.func_177972_a(odir = dir.func_176734_d()))).func_185897_m() && !ostate.canConnectRedstone((IBlockReader)world, pos, odir)) {
                flags_to_add |= defs.connections.getWireBit(face, odir);
                ++num_placed;
            }
            if (num_placed > 0) {
                int n_added = te.addWireFlags(flags_to_add);
                te.sync(true);
                RedstonePenItem.popRedstone(pen, n_added, player, hand);
                te.updateConnections(2);
                te.updateAllPowerValuesFromAdjacent();
                state.func_235734_a_((IWorld)world, pos, 3);
                this.notifyAdjacent(world, pos);
            }
        }

        private void disablePower(boolean disable) {
            this.can_provide_power_ = !disable;
        }

        public void notifyAdjacent(World world, BlockPos pos) {
            world.func_195593_d(pos, (Block)this);
            for (Direction side : Direction.values()) {
                BlockPos ppos = pos.func_177972_a(side);
                world.func_175695_a(ppos, world.func_180495_p(ppos).func_177230_c(), side.func_176734_d());
            }
        }
    }

    public static final class defs {
        public static final long STATE_FLAG_WIR_MASK = 0xFFFFFFL;
        public static final long STATE_FLAG_CON_MASK = 0x3F000000L;
        public static final long STATE_FLAG_PWR_MASK = 0xFFFFFF00000000L;
        public static final int STATE_FLAG_WIR_COUNT = 24;
        public static final int STATE_FLAG_CON_COUNT = 6;
        public static final int STATE_FLAG_WIR_POS = 0;
        public static final int STATE_FLAG_CON_POS = 24;
        public static final int STATE_FLAG_PWR_POS = 32;

        public static final class models {
            public static final ImmutableMap<Long, String> STATE_WIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)1L, (Object)"dn").put((Object)2L, (Object)"ds").put((Object)4L, (Object)"de").put((Object)8L, (Object)"dw").put((Object)16L, (Object)"un").put((Object)32L, (Object)"us").put((Object)64L, (Object)"ue").put((Object)128L, (Object)"uw").put((Object)256L, (Object)"nu").put((Object)512L, (Object)"nd").put((Object)1024L, (Object)"ne").put((Object)2048L, (Object)"nw").put((Object)4096L, (Object)"su").put((Object)8192L, (Object)"sd").put((Object)16384L, (Object)"se").put((Object)32768L, (Object)"sw").put((Object)65536L, (Object)"eu").put((Object)131072L, (Object)"ed").put((Object)262144L, (Object)"en").put((Object)524288L, (Object)"es").put((Object)0x100000L, (Object)"wu").put((Object)0x200000L, (Object)"wd").put((Object)0x400000L, (Object)"wn").put((Object)0x800000L, (Object)"ws").build();
            public static final ImmutableMap<Long, String> STATE_CONNECT_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dc").put((Object)0x2000000L, (Object)"uc").put((Object)0x4000000L, (Object)"nc").put((Object)0x8000000L, (Object)"sc").put((Object)0x10000000L, (Object)"ec").put((Object)0x20000000L, (Object)"wc").build();
            public static final ImmutableMap<Long, String> STATE_CNTWIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dm").put((Object)0x2000000L, (Object)"um").put((Object)0x4000000L, (Object)"nm").put((Object)0x8000000L, (Object)"sm").put((Object)0x10000000L, (Object)"em").put((Object)0x20000000L, (Object)"wm").build();
        }

        public static class shape {
            private static final double SHAPE_LAYER_THICKNESS = 0.01;
            private static final double SHAPE_TRACK_HALFWIDTH = 1.0;
            private static final VoxelShape DOWN_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(7.0, 0.0, 0.0, 9.0, 0.01, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.0, 16.0, 0.01, 9.0));
            private static final VoxelShape UP_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(7.0, 15.99, 0.0, 9.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 15.99, 7.0, 16.0, 16.0, 9.0));
            private static final VoxelShape WEST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 0.0, 7.0, 0.01, 16.0, 9.0), Auxiliaries.getPixeledAABB(0.0, 7.0, 0.0, 0.01, 9.0, 16.0));
            private static final VoxelShape EAST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(15.99, 0.0, 7.0, 16.0, 16.0, 9.0), Auxiliaries.getPixeledAABB(15.99, 7.0, 0.0, 16.0, 9.0, 16.0));
            private static final VoxelShape NORTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 7.0, 0.0, 16.0, 9.0, 0.01), Auxiliaries.getPixeledAABB(7.0, 0.0, 0.0, 9.0, 16.0, 0.01));
            private static final VoxelShape SOUTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 7.0, 15.99, 16.0, 9.0, 16.0), Auxiliaries.getPixeledAABB(7.0, 0.0, 15.99, 9.0, 16.0, 16.0));
            private static final VoxelShape[] shape_cache = new VoxelShape[64];

            public static VoxelShape get(int faces) {
                if (shape_cache[faces] == null) {
                    VoxelShape shape2 = VoxelShapes.func_197880_a();
                    if ((faces & 1) != 0) {
                        shape2 = VoxelShapes.func_197878_a((VoxelShape)shape2, (VoxelShape)DOWN_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    if ((faces & 2) != 0) {
                        shape2 = VoxelShapes.func_197878_a((VoxelShape)shape2, (VoxelShape)UP_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    if ((faces & 4) != 0) {
                        shape2 = VoxelShapes.func_197878_a((VoxelShape)shape2, (VoxelShape)NORTH_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    if ((faces & 8) != 0) {
                        shape2 = VoxelShapes.func_197878_a((VoxelShape)shape2, (VoxelShape)SOUTH_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    if ((faces & 0x10) != 0) {
                        shape2 = VoxelShapes.func_197878_a((VoxelShape)shape2, (VoxelShape)EAST_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    if ((faces & 0x20) != 0) {
                        shape2 = VoxelShapes.func_197878_a((VoxelShape)shape2, (VoxelShape)WEST_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    shape.shape_cache[faces] = shape2;
                }
                return shape_cache[faces];
            }
        }

        public static final class connections {
            public static final Direction[] CONNECTION_BIT_ORDER = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            public static final ImmutableMap<Direction, Integer> CONNECTION_BIT_ORDER_REV = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)0).put((Object)Direction.UP, (Object)1).put((Object)Direction.NORTH, (Object)2).put((Object)Direction.SOUTH, (Object)3).put((Object)Direction.EAST, (Object)4).put((Object)Direction.WEST, (Object)5).build();
            public static final ImmutableMap<Long, Direction> BULK_FACE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)Direction.DOWN).put((Object)0x1000000L, (Object)Direction.DOWN).put((Object)0x2000000L, (Object)Direction.UP).put((Object)0x4000000L, (Object)Direction.NORTH).put((Object)0x8000000L, (Object)Direction.SOUTH).put((Object)0x10000000L, (Object)Direction.EAST).put((Object)0x20000000L, (Object)Direction.WEST).build();
            public static final ImmutableMap<Direction, Long> BULK_FACE_MAPPING_REV = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)0x1000000L).put((Object)Direction.UP, (Object)0x2000000L).put((Object)Direction.NORTH, (Object)0x4000000L).put((Object)Direction.SOUTH, (Object)0x8000000L).put((Object)Direction.EAST, (Object)0x10000000L).put((Object)Direction.WEST, (Object)0x20000000L).build();
            public static final ImmutableMap<Long, Tuple<Direction, Direction>> WIRE_FACE_DIRECTION_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.DOWN)).put((Object)1L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.NORTH)).put((Object)2L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.SOUTH)).put((Object)4L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.EAST)).put((Object)8L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.WEST)).put((Object)16L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.NORTH)).put((Object)32L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.SOUTH)).put((Object)64L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.EAST)).put((Object)128L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.WEST)).put((Object)256L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.UP)).put((Object)512L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.DOWN)).put((Object)1024L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.EAST)).put((Object)2048L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.WEST)).put((Object)4096L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.UP)).put((Object)8192L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.DOWN)).put((Object)16384L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.EAST)).put((Object)32768L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.WEST)).put((Object)65536L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.UP)).put((Object)131072L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.DOWN)).put((Object)262144L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.NORTH)).put((Object)524288L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.SOUTH)).put((Object)0x100000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.UP)).put((Object)0x200000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.DOWN)).put((Object)0x400000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.NORTH)).put((Object)0x800000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.SOUTH)).build();
            public static final ImmutableMap<Long, Tuple<Direction, Direction>> INTERNAL_EDGE_CONNECTION_MAPPING = new ImmutableMap.Builder().put((Object)513L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.NORTH)).put((Object)8194L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.SOUTH)).put((Object)131076L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.EAST)).put((Object)0x200008L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.WEST)).put((Object)272L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.NORTH)).put((Object)4128L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.SOUTH)).put((Object)65600L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.EAST)).put((Object)0x100080L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.WEST)).put((Object)263168L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.EAST)).put((Object)0x400800L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.WEST)).put((Object)540672L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.EAST)).put((Object)0x808000L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.WEST)).build();

            public static final long getBulkConnectorBit(Direction face) {
                return (Long)BULK_FACE_MAPPING_REV.get((Object)face);
            }

            public static final long getWireBit(Direction face, Direction wire_direction) {
                return WIRE_FACE_DIRECTION_MAPPING.entrySet().stream().filter(kv -> ((Tuple)kv.getValue()).func_76341_a() == face && ((Tuple)kv.getValue()).func_76340_b() == wire_direction).findFirst().map(kv -> (Long)kv.getKey()).orElse(0L);
            }

            public static final Tuple<Direction, Direction> getWireBitSideAndDirection(long wirebit) {
                return (Tuple)WIRE_FACE_DIRECTION_MAPPING.getOrDefault((Object)wirebit, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.DOWN));
            }

            public static final List<Direction> getVanillaWireConnectionDirections(long mask) {
                if ((mask & 0xFL) == 0L) {
                    return Collections.emptyList();
                }
                ArrayList<Direction> r = new ArrayList<Direction>(4);
                if ((mask & 1L) != 0L) {
                    r.add(Direction.NORTH);
                }
                if ((mask & 2L) != 0L) {
                    r.add(Direction.SOUTH);
                }
                if ((mask & 4L) != 0L) {
                    r.add(Direction.EAST);
                }
                if ((mask & 8L) != 0L) {
                    r.add(Direction.WEST);
                }
                return r;
            }

            public static final boolean hasVanillaWireConnection(long mask, Direction side) {
                switch (side) {
                    case NORTH: {
                        return (mask & 1L) != 0L;
                    }
                    case SOUTH: {
                        return (mask & 2L) != 0L;
                    }
                    case EAST: {
                        return (mask & 4L) != 0L;
                    }
                    case WEST: {
                        return (mask & 8L) != 0L;
                    }
                }
                return false;
            }

            public static final boolean hasBulkConnection(long mask, Direction side) {
                return ((Long)BULK_FACE_MAPPING_REV.get((Object)side) & mask) != 0L;
            }

            public static final boolean hasRedstoneConnection(long mask, Direction side) {
                switch (side) {
                    case DOWN: {
                        return (mask & 0x1222200L) != 0L;
                    }
                    case UP: {
                        return (mask & 0x2111100L) != 0L;
                    }
                    case NORTH: {
                        return (mask & 0x4440011L) != 0L;
                    }
                    case SOUTH: {
                        return (mask & 0x8880022L) != 0L;
                    }
                    case EAST: {
                        return (mask & 0x10004444L) != 0L;
                    }
                    case WEST: {
                        return (mask & 0x20008888L) != 0L;
                    }
                }
                return false;
            }

            public static final long getWireElementsOnFace(Direction face) {
                return 15L << (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face) * 4 + 0;
            }

            public static final long getAllElementsOnFace(Direction face) {
                int index = (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face);
                return 15L << index * 4 + 0 | 1L << index + 24;
            }
        }
    }
}

