/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.detail;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.blocks.RedstoneTrack;

public class ModRenderers {

    @OnlyIn(value=Dist.CLIENT)
    public static class TrackTer
    extends TileEntityRenderer<RedstoneTrack.TrackTileEntity> {
        private static final ModelResourceLocation[] model_rls = new ModelResourceLocation[24];
        private static final ModelResourceLocation[] modelm_rls = new ModelResourceLocation[6];
        private static final ModelResourceLocation[] modelc_rls = new ModelResourceLocation[6];
        private static final ArrayList<Vector3f> power_rgb = new ArrayList();
        private static int tesr_error_counter = 4;

        public static void registerModels() {
            RedstoneTrack.defs.models.STATE_WIRE_MAPPING.entrySet().forEach(kv -> {
                ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("redstonepen", (String)kv.getValue()), "inventory");
                for (int i = 0; i < 24; ++i) {
                    if (((Long)kv.getKey() & 1L << 0 + i) == 0L) continue;
                    TrackTer.model_rls[i] = mrl;
                    break;
                }
                ModelLoader.addSpecialModel((ResourceLocation)mrl);
            });
            RedstoneTrack.defs.models.STATE_CONNECT_MAPPING.entrySet().forEach(kv -> {
                ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("redstonepen", (String)kv.getValue()), "inventory");
                for (int i = 0; i < 6; ++i) {
                    if (((Long)kv.getKey() & 1L << 24 + i) == 0L) continue;
                    TrackTer.modelc_rls[i] = mrl;
                    break;
                }
                ModelLoader.addSpecialModel((ResourceLocation)mrl);
            });
            RedstoneTrack.defs.models.STATE_CNTWIRE_MAPPING.entrySet().forEach(kv -> {
                ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("redstonepen", (String)kv.getValue()), "inventory");
                for (int i = 0; i < 6; ++i) {
                    if (((Long)kv.getKey() & 1L << 24 + i) == 0L) continue;
                    TrackTer.modelm_rls[i] = mrl;
                    break;
                }
                ModelLoader.addSpecialModel((ResourceLocation)mrl);
            });
            power_rgb.clear();
            for (int i = 0; i <= 15; ++i) {
                float f;
                power_rgb.add(new Vector3f(MathHelper.func_76131_a((float)(f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f)), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f)));
            }
        }

        private static Vector3f getPowerRGB(int p) {
            return power_rgb.get(p & 0xF);
        }

        public TrackTer(TileEntityRendererDispatcher dispatcher) {
            super(dispatcher);
        }

        public void render(RedstoneTrack.TrackTileEntity te, float unused1, MatrixStack mxs, IRenderTypeBuffer buf, int combinedLightIn, int combinedOverlayIn) {
            block7: {
                if (tesr_error_counter <= 0) {
                    return;
                }
                try {
                    BlockState block_state = te.func_195044_w();
                    IVertexBuilder vxb = buf.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)block_state, (boolean)false));
                    combinedOverlayIn = OverlayTexture.func_229201_a_((int)0, (int)0);
                    mxs.func_227860_a_();
                    int wirfl = te.getWireFlags();
                    int wirfc = te.getWireFlagCount();
                    long flag = 1L;
                    int i = 0;
                    while (i < wirfc) {
                        if (((long)wirfl & flag) != 0L) {
                            Vector3f rgb = TrackTer.getPowerRGB(te.getSidePower(RedstoneTrack.defs.connections.CONNECTION_BIT_ORDER[i / 4]));
                            IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(model_rls[i]);
                            Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(mxs.func_227866_c_(), vxb, null, model, rgb.func_195899_a(), rgb.func_195900_b(), rgb.func_195902_c(), combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
                        }
                        ++i;
                        flag <<= 1;
                    }
                    wirfl = te.getWireFlags();
                    int confl = te.getConnectionFlags();
                    int confc = te.getConnectionFlagCount();
                    long wir = 15L;
                    long con = 1L;
                    int i2 = 0;
                    while (i2 < confc) {
                        if (((long)wirfl & wir) != 0L || ((long)confl & con) != 0L) {
                            Vector3f rgb = TrackTer.getPowerRGB(te.getSidePower(RedstoneTrack.defs.connections.CONNECTION_BIT_ORDER[i2]));
                            IBakedModel model = ((long)confl & con) == 0L ? Minecraft.func_71410_x().func_209506_al().func_174953_a(modelm_rls[i2]) : Minecraft.func_71410_x().func_209506_al().func_174953_a(modelc_rls[i2]);
                            Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(mxs.func_227866_c_(), vxb, null, model, rgb.func_195899_a(), rgb.func_195900_b(), rgb.func_195902_c(), combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
                        }
                        ++i2;
                        con <<= 1;
                        wir <<= 4;
                    }
                    mxs.func_227865_b_();
                }
                catch (Throwable e) {
                    if (--tesr_error_counter > 0) break block7;
                    ModRedstonePen.logger().error("TER was disabled because broken, exception was: " + e.getMessage());
                    ModRedstonePen.logger().error((Object)e.getStackTrace());
                }
            }
        }
    }
}

