/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.items;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.ModContent;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.Inventories;
import wile.redstonepen.libmc.detail.Overlay;

public class RedstonePenItem
extends Item {
    public RedstonePenItem(Item.Properties properties) {
        super(properties.func_200916_a(ModRedstonePen.ITEMGROUP).setNoRepair());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (this.getMaxDamage(stack) > 0) {
            tooltip.add((ITextComponent)Auxiliaries.localizable("item.redstonepen.pen.tooltip.numstored", this.getMaxDamage(stack) - this.getDamage(stack)));
        } else {
            tooltip.add((ITextComponent)Auxiliaries.localizable("item.redstonepen.pen.tooltip.rsfrominventory"));
        }
        Auxiliaries.Tooltip.addInformation(stack, (IBlockReader)world, tooltip, flag, true);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return Collections.singletonList(ModRedstonePen.ITEMGROUP);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean func_77645_m() {
        return this.func_77612_l() > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.func_77645_m() && stack.func_77952_i() > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.func_77958_k() <= 0 ? 1.0 : MathHelper.func_151237_a((double)((double)stack.func_77952_i() / (double)stack.func_77958_k()), (double)0.0, (double)1.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0x663333;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.func_130014_f_();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof RedstoneDiodeBlock) {
            return false;
        }
        if (state.func_203425_a(Blocks.field_150488_af)) {
            RedstonePenItem.pushRedstone(stack, 1, player);
            world.func_217377_a(pos, false);
            return true;
        }
        if (state.func_203425_a((Block)ModContent.TRACK_BLOCK)) {
            Hand hand;
            RayTraceResult rt = player.func_213324_a(10.0, 0.0f, false);
            BlockRayTraceResult brtr = (BlockRayTraceResult)rt;
            if (rt.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return false;
            }
            Hand hand2 = hand = player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == this ? Hand.MAIN_HAND : Hand.OFF_HAND;
            if (state.func_177230_c() instanceof RedstoneTrack.RedstoneTrackBlock) {
                ((RedstoneTrack.RedstoneTrackBlock)state.func_177230_c()).onBlockActivated(state, player.func_130014_f_(), pos, player, hand, (BlockRayTraceResult)rt, true);
                return true;
            }
        }
        return state.func_185887_b((IBlockReader)world, pos) != 0.0f;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        if (state.func_203425_a(Blocks.field_150488_af)) {
            if (context.func_195991_k().func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            RedstonePenItem.pushRedstone(stack, 1, player);
            world.func_217377_a(pos, false);
            world.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 0.4f, 2.0f);
            return ActionResultType.CONSUME;
        }
        if (state.func_177230_c() instanceof RedstoneTrack.RedstoneTrackBlock) {
            if (context.func_195991_k().func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            if (player.func_184592_cb().func_77973_b() == Items.field_196180_eI) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof RedstoneTrack.TrackTileEntity) {
                    ((RedstoneTrack.TrackTileEntity)te).toggle_trace(player);
                }
                return ActionResultType.CONSUME;
            }
            BlockRayTraceResult rtr = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
            return ((RedstoneTrack.RedstoneTrackBlock)state.func_177230_c()).func_225533_a_(state, world, pos, player, hand, rtr);
        }
        if (!RedstoneTrack.RedstoneTrackBlock.canBePlacedOnFace(state, world, pos, facing)) {
            return ActionResultType.PASS;
        }
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        BlockPos target_pos = pos.func_177972_a(facing);
        BlockState target_state = world.func_180495_p(target_pos);
        if (target_state.func_177230_c() instanceof RedstoneTrack.RedstoneTrackBlock) {
            BlockRayTraceResult rtr = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), target_pos, context.func_221533_k());
            return ((RedstoneTrack.RedstoneTrackBlock)target_state.func_177230_c()).func_225533_a_(target_state, world, target_pos, player, hand, rtr);
        }
        BlockRayTraceResult rtr = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), target_pos, context.func_221533_k());
        BlockItemUseContext ctx = new BlockItemUseContext(context.func_195999_j(), context.func_221531_n(), new ItemStack((IItemProvider)Items.field_151137_ax), rtr);
        BlockState rs_state = ModContent.TRACK_BLOCK.func_196258_a(ctx);
        if (rs_state == null) {
            return ActionResultType.FAIL;
        }
        if (!state.func_177230_c().func_196253_a(target_state, ctx)) {
            return ActionResultType.FAIL;
        }
        if (!world.func_180501_a(target_pos, rs_state, 3)) {
            return ActionResultType.FAIL;
        }
        BlockState placed_state = world.func_180495_p(target_pos);
        if (!(placed_state.func_177230_c() instanceof RedstoneTrack.RedstoneTrackBlock)) {
            world.func_217377_a(target_pos, false);
            return ActionResultType.FAIL;
        }
        if (((RedstoneTrack.RedstoneTrackBlock)placed_state.func_177230_c()).func_225533_a_(placed_state, world, target_pos, player, hand, rtr) == ActionResultType.FAIL) {
            return ActionResultType.FAIL;
        }
        ((RedstoneTrack.RedstoneTrackBlock)placed_state.func_177230_c()).checkSmartPlacement(placed_state, world, target_pos, player, hand, rtr);
        return ActionResultType.CONSUME;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected || !entity.func_225608_bj_() || world.func_201670_d() || (world.func_82737_E() & 1L) != 0L || !(entity instanceof ServerPlayerEntity)) {
            return;
        }
        RayTraceResult rt = entity.func_213324_a(10.0, 0.0f, false);
        if (rt.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)rt;
        BlockPos pos = brtr.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Direction rs_side = brtr.func_216354_b().func_176734_d();
        TranslationTextComponent tc = null;
        if (block == Blocks.field_150488_af) {
            tc = Auxiliaries.localizable("overlay.wire_power", this.powerFormatted((Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O)));
        } else if (block == ModContent.TRACK_BLOCK) {
            RedstoneTrack.TrackTileEntity te = RedstoneTrack.RedstoneTrackBlock.tile((IBlockReader)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            tc = Auxiliaries.localizable("overlay.track_power", this.powerFormatted(te.getSidePower(rs_side)));
            if (Auxiliaries.isDevelopmentMode()) {
                tc.func_230529_a_((ITextComponent)new StringTextComponent(String.format(" | %016x | ", te.getStateFlags())));
                tc.func_230529_a_((ITextComponent)new StringTextComponent(Arrays.stream(Direction.values()).map(side -> side.toString().substring(0, 1) + te.getRedstonePower(side.func_176734_d(), false)).collect(Collectors.joining(","))));
            }
        } else if (state.func_203425_a(Blocks.field_196633_cV)) {
            tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted((Boolean)state.func_177229_b((Property)RepeaterBlock.field_196348_c) != false ? 15 : 0));
            tc.func_230529_a_((ITextComponent)Auxiliaries.localizable("overlay.repeater_delay", state.func_177229_b((Property)RepeaterBlock.field_176410_b)));
        } else if (state.func_203425_a(Blocks.field_196762_fd)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof ComparatorTileEntity) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(((ComparatorTileEntity)te).func_145996_a()));
                switch ((ComparatorMode)state.func_177229_b((Property)ComparatorBlock.field_176463_b)) {
                    case COMPARE: {
                        tc.func_230529_a_((ITextComponent)Auxiliaries.localizable("overlay.comparator_compare"));
                        break;
                    }
                    case SUBTRACT: {
                        tc.func_230529_a_((ITextComponent)Auxiliaries.localizable("overlay.comparator_subtract"));
                        break;
                    }
                }
            }
        } else if (state.func_185897_m()) {
            int p = Math.max(state.func_185893_b((IBlockReader)world, pos, rs_side), state.func_185911_a((IBlockReader)world, pos, rs_side));
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p));
            } else {
                Direction max_side = null;
                for (Direction side2 : Direction.values()) {
                    int ps;
                    if (side2 == rs_side || (ps = Math.max(state.func_185893_b((IBlockReader)world, pos, side2), state.func_185911_a((IBlockReader)world, pos, side2))) <= p) continue;
                    p = ps;
                    max_side = side2;
                    if (p >= 15) break;
                }
                tc = p == 0 || max_side == null ? Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p)) : Auxiliaries.localizable("overlay.direct_power_at", this.powerFormatted(p), max_side.func_176734_d());
            }
        } else if (state.shouldCheckWeakPower((IWorldReader)world, pos, rs_side)) {
            Direction max_side = Direction.values()[0];
            int p = 0;
            for (Direction d : Direction.values()) {
                int ps = world.func_175651_c(pos.func_177972_a(d), d);
                if (ps <= p) continue;
                p = ps;
                max_side = d;
                if (p >= 15) break;
            }
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.indirect_power", this.powerFormatted(p), max_side);
            }
        }
        if (tc != null) {
            Overlay.show((PlayerEntity)((ServerPlayerEntity)entity), (ITextComponent)tc, 400);
        }
    }

    private String powerFormatted(int p) {
        return String.format("%02d", p);
    }

    public static final void pushRedstone(ItemStack stack, int amount, PlayerEntity player) {
        if (amount <= 0) {
            return;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (!stack.func_77984_f()) {
                ItemStack remaining = Inventories.insert(player, new ItemStack((IItemProvider)Items.field_151137_ax, amount), false);
                if (!remaining.func_190926_b()) {
                    Inventories.give(player, remaining);
                }
            } else if (stack.func_77952_i() >= amount) {
                stack.func_196085_b(stack.func_77952_i() - amount);
            } else {
                stack.func_196085_b(0);
                Inventories.give(player, new ItemStack((IItemProvider)Items.field_151137_ax, amount -= stack.func_77952_i()));
            }
        } else if (stack.func_77973_b() == Items.field_151137_ax) {
            if (stack.func_190916_E() <= stack.func_77976_d() - amount) {
                stack.func_190917_f(amount);
            } else {
                Inventories.give(player, new ItemStack((IItemProvider)Items.field_151137_ax, amount));
            }
        } else {
            Inventories.give(player, new ItemStack((IItemProvider)Items.field_151137_ax, amount));
        }
    }

    public static final int popRedstone(ItemStack stack, int amount, PlayerEntity player, Hand hand) {
        if (amount <= 0) {
            return 0;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.func_77984_f()) {
                int dmg = stack.func_77952_i() + amount;
                if (dmg >= stack.func_77958_k()) {
                    amount = stack.func_77958_k() - stack.func_77952_i();
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    stack.func_196085_b(dmg);
                }
            } else {
                amount = Inventories.extract(player, Items.field_151137_ax, amount, false).func_190916_E();
            }
        } else if (stack.func_77973_b() == Items.field_151137_ax) {
            if (stack.func_190916_E() <= amount) {
                amount = stack.func_190916_E();
                player.func_184611_a(hand, ItemStack.field_190927_a);
            } else {
                stack.func_190918_g(amount);
            }
        }
        return amount;
    }

    public static final boolean hasEnoughRedstone(ItemStack stack, int amount, PlayerEntity player) {
        if (RedstonePenItem.isPen(stack)) {
            if (stack.func_77984_f()) {
                return stack.func_77952_i() < stack.func_77958_k() - amount;
            }
            return Inventories.extract(player, Items.field_151137_ax, amount, true).func_190916_E() >= amount;
        }
        if (stack.func_77973_b() == Items.field_151137_ax) {
            return stack.func_190916_E() >= amount;
        }
        return false;
    }

    public static final boolean isFullRedstone(ItemStack stack) {
        if (RedstonePenItem.isPen(stack)) {
            return stack.func_77952_i() <= 0;
        }
        if (stack.func_77973_b() == Items.field_151137_ax) {
            return stack.func_190916_E() >= stack.func_77976_d();
        }
        return false;
    }

    public static final boolean isPen(ItemStack stack) {
        return stack.func_77973_b() instanceof RedstonePenItem;
    }
}

