/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc.blocks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.libmc.detail.Auxiliaries;

public class StandardBlocks {
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_MIPPED = 2L;
    public static final long CFG_TRANSLUCENT = 4L;
    public static final long CFG_WATERLOGGABLE = 8L;
    public static final long CFG_HORIZIONTAL = 16L;
    public static final long CFG_LOOK_PLACEMENT = 32L;
    public static final long CFG_FACING_PLACEMENT = 64L;
    public static final long CFG_OPPOSITE_PLACEMENT = 128L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 256L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 512L;
    public static final long CFG_STRICT_CONNECTIONS = 1024L;
    public static final long CFG_AI_PASSABLE = 2048L;

    public static class WaterLoggable
    extends BaseBlock
    implements IWaterLoggable,
    IStandardBlock {
        public WaterLoggable(long config, AbstractBlock.Properties properties) {
            super(config | 8L, properties);
        }

        public WaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L, properties, aabb);
        }

        public WaterLoggable(long config, AbstractBlock.Properties properties, VoxelShape voxel_shape) {
            super(config | 8L, properties, voxel_shape);
        }

        public WaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{WATERLOGGED});
        }
    }

    public static class BaseBlock
    extends Block
    implements IStandardBlock {
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
        public final long config;
        private final VoxelShape vshape;

        public BaseBlock(long conf, AbstractBlock.Properties properties) {
            this(conf, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        }

        public BaseBlock(long conf, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
            this(conf, properties, VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
        }

        public BaseBlock(long conf, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
            this(conf, properties, Arrays.stream(aabbs).map(aabb -> VoxelShapes.func_197881_a((AxisAlignedBB)aabb)).reduce(VoxelShapes.func_197880_a(), (shape2, aabb) -> VoxelShapes.func_197882_b((VoxelShape)shape2, (VoxelShape)aabb, (IBooleanFunction)IBooleanFunction.field_223244_o_)));
        }

        public BaseBlock(long conf, AbstractBlock.Properties properties, VoxelShape voxel_shape) {
            super(properties);
            this.config = conf;
            this.vshape = voxel_shape;
            BlockState state = (BlockState)this.func_176194_O().func_177621_b();
            if ((conf & 8L) != 0L) {
                state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            this.func_180632_j(state);
        }

        @Override
        public long config() {
            return this.config;
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            return ActionResultType.PASS;
        }

        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
        }

        @Override
        public IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config);
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshape;
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.func_220053_a(state, world, pos, selectionContext);
        }

        public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
            return (this.config & 0x800L) == 0L ? false : super.func_196266_a(state, world, pos, type);
        }

        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if ((this.config & 8L) != 0L) {
                FluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
                state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
            }
            return state;
        }

        public boolean func_181623_g() {
            return false;
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.NORMAL;
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
                world.func_175713_t(pos);
                world.func_175666_e(pos, (Block)this);
            }
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            ServerWorld world = builder.func_216018_a();
            Float explosion_radius = (Float)builder.func_216019_b(LootParameters.field_216290_j);
            TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
            if (!this.hasDynamicDropList() || world == null) {
                return super.func_220076_a(state, builder);
            }
            boolean is_explosion = explosion_radius != null && explosion_radius.floatValue() > 0.0f;
            return this.dropList(state, (World)world, te, is_explosion);
        }

        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                return false;
            }
            return super.func_200123_i(state, reader, pos);
        }

        public FluidState func_204507_t(BlockState state) {
            if ((this.config & 8L) != 0L) {
                return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
            }
            return super.func_204507_t(state);
        }

        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return state;
        }
    }

    public static interface IBlockItemFactory {
        public BlockItem getBlockItem(Block var1, Item.Properties var2);
    }

    public static interface IStandardBlock {
        default public long config() {
            return 0L;
        }

        default public boolean hasDynamicDropList() {
            return false;
        }

        default public List<ItemStack> dropList(BlockState state, World world, @Nullable TileEntity te, boolean explosion) {
            return Collections.singletonList(!world.func_201670_d() ? new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()) : ItemStack.field_190927_a);
        }

        default public RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config());
        }

        default public RenderTypeHint getRenderTypeHint(long config) {
            if ((config & 1L) != 0L) {
                return RenderTypeHint.CUTOUT;
            }
            if ((config & 2L) != 0L) {
                return RenderTypeHint.CUTOUT_MIPPED;
            }
            if ((config & 4L) != 0L) {
                return RenderTypeHint.TRANSLUCENT;
            }
            return RenderTypeHint.SOLID;
        }

        public static enum RenderTypeHint {
            SOLID,
            CUTOUT,
            CUTOUT_MIPPED,
            TRANSLUCENT,
            TRANSLUCENT_NO_CRUMBLING;

        }
    }
}

