/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc.detail;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wile.redstonepen.libmc.detail.Auxiliaries;

public class ExtendedShapelessRecipe
extends ShapelessRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = (Serializer)new Serializer().setRegistryName(Auxiliaries.modid(), "crafting_extended_shapeless");
    private final CompoundNBT aspects;
    private final ResourceLocation resultTag;

    public ExtendedShapelessRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> ingredients, CompoundNBT aspects, ResourceLocation resultTag) {
        super(id, group, output, ingredients);
        this.aspects = aspects;
        this.resultTag = resultTag;
    }

    public CompoundNBT getAspects() {
        return this.aspects.func_74737_b();
    }

    private int getToolDamage() {
        if (this.aspects.func_74764_b("tool_repair")) {
            return -MathHelper.func_76125_a((int)this.aspects.func_74762_e("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.func_74764_b("tool_damage")) {
            return MathHelper.func_76125_a((int)this.aspects.func_74762_e("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    private Tuple<ItemStack, NonNullList<ItemStack>> getRepaired(CraftingInventory inv) {
        ItemStack stack;
        int i;
        String tool_name = this.aspects.func_74779_i("tool");
        HashMap<Item, Integer> repair_items = new HashMap<Item, Integer>();
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack tool_item = ItemStack.field_190927_a;
        for (int i2 = 0; i2 < inv.func_70302_i_(); ++i2) {
            ItemStack stack2 = inv.func_70301_a(i2);
            if (stack2.func_190926_b()) continue;
            if (stack2.func_77973_b().getRegistryName().toString().equals(tool_name)) {
                tool_item = stack2.func_77946_l();
                continue;
            }
            remaining.set(i2, (Object)stack2.func_77946_l());
            repair_items.put(stack2.func_77973_b(), stack2.func_190916_E() + repair_items.getOrDefault(stack2.func_77973_b(), 0));
        }
        if (tool_item.func_190926_b()) {
            return new Tuple((Object)ItemStack.field_190927_a, (Object)remaining);
        }
        if (!tool_item.func_77984_f()) {
            Auxiliaries.logWarn("Repairing '" + tool_item.func_77973_b().getRegistryName().toString() + "' can't work, the item is not damageable.");
            return new Tuple((Object)ItemStack.field_190927_a, (Object)remaining);
        }
        int dmg = tool_item.func_77952_i();
        if (dmg <= 0 && !this.aspects.func_74767_n("over_repair")) {
            return new Tuple((Object)ItemStack.field_190927_a, (Object)remaining);
        }
        int min_repair_item_count = repair_items.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (min_repair_item_count <= 0) {
            return new Tuple((Object)ItemStack.field_190927_a, (Object)remaining);
        }
        int single_repair_dur = this.aspects.func_74767_n("relative_repair_damage") ? Math.max(1, -this.getToolDamage() * tool_item.func_77958_k() / 100) : Math.max(1, -this.getToolDamage());
        int num_repairs = dmg / single_repair_dur;
        if (num_repairs * single_repair_dur < dmg) {
            ++num_repairs;
        }
        num_repairs = Math.min(num_repairs, min_repair_item_count);
        for (Item ki : repair_items.keySet()) {
            repair_items.put(ki, num_repairs);
        }
        tool_item.func_196085_b(Math.max(dmg - single_repair_dur * num_repairs, 0));
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b().getRegistryName().toString().equals(tool_name)) continue;
            remaining.set(i, (Object)(stack.hasContainerItem() ? stack.getContainerItem() : stack.func_77946_l()));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = (ItemStack)remaining.get(i);
            Item item = stack.func_77973_b();
            if (!repair_items.containsKey(item)) continue;
            int n = (Integer)repair_items.get(item);
            if (stack.func_190916_E() >= n) {
                stack.func_190918_g(n);
                repair_items.remove(item);
                continue;
            }
            repair_items.put(item, n - stack.func_190916_E());
            remaining.set(i, (Object)ItemStack.field_190927_a);
        }
        if (tool_item.func_77973_b() instanceof IRepairableToolItem) {
            tool_item = ((IRepairableToolItem)tool_item.func_77973_b()).onShapelessRecipeRepaired(tool_item, dmg, tool_item.func_77952_i());
        }
        return new Tuple((Object)tool_item, (Object)remaining);
    }

    public boolean func_192399_d() {
        return this.isRepair() || this.aspects.func_74767_n("dynamic");
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        if (this.isRepair()) {
            NonNullList remaining = (NonNullList)this.getRepaired(inv).func_76340_b();
            for (int i = 0; i < remaining.size(); ++i) {
                ItemStack rem_stack = (ItemStack)remaining.get(i);
                ItemStack inv_stack = inv.func_70301_a(i);
                if (inv_stack.func_190926_b() || !rem_stack.func_190926_b() && !inv.func_70301_a(i).func_77969_a(rem_stack)) continue;
                remaining.set(i, (Object)ItemStack.field_190927_a);
                rem_stack.func_190917_f(1);
                inv.func_70299_a(i, rem_stack);
            }
            return remaining;
        }
        String tool_name = this.aspects.func_74779_i("tool");
        int tool_damage = this.getToolDamage();
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b().getRegistryName().toString().equals(tool_name)) {
                if (!stack.func_77984_f()) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                ItemStack rstack = stack.func_77946_l();
                rstack.func_196085_b(rstack.func_77952_i() + tool_damage);
                if (rstack.func_77952_i() >= rstack.func_77958_k()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.hasContainerItem()) continue;
            remaining.set(i, (Object)stack.getContainerItem());
        }
        return remaining;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        int dmg;
        if (this.isRepair()) {
            return (ItemStack)this.getRepaired(inv).func_76341_a();
        }
        ItemStack rstack = super.func_77572_b(inv);
        if (rstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.aspects.func_74762_e("initial_durability") > 0) {
            int dmg2 = Math.max(0, rstack.func_77958_k() - this.aspects.func_74762_e("initial_durability"));
            if (dmg2 > 0) {
                rstack.func_196085_b(dmg2);
            }
        } else if (this.aspects.func_74762_e("initial_damage") > 0 && (dmg = Math.min(this.aspects.func_74762_e("initial_damage"), rstack.func_77958_k())) > 0) {
            rstack.func_196085_b(dmg);
        }
        return rstack;
    }

    public ItemStack func_77571_b() {
        return this.func_192399_d() ? ItemStack.field_190927_a : super.func_77571_b();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ExtendedShapelessRecipe> {
        private static int MAX_WIDTH = 3;
        private static int MAX_HEIGHT = 3;

        public ExtendedShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject res;
            JsonObject aspects;
            ResourceLocation resultTag = new ResourceLocation("libmc", "none");
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList list = NonNullList.func_191196_a();
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredients.get(i));
                if (ingredient.func_203189_d()) continue;
                list.add((Object)ingredient);
            }
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for " + this.getRegistryName().func_110623_a() + " recipe");
            }
            if (list.size() > MAX_WIDTH * MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for crafting_tool_shapeless recipe the max is " + MAX_WIDTH * MAX_HEIGHT);
            }
            CompoundNBT aspects_nbt = new CompoundNBT();
            if (json.get("aspects") != null && (aspects = JSONUtils.func_152754_s((JsonObject)json, (String)"aspects")).size() > 0) {
                try {
                    aspects_nbt = JsonToNBT.func_180713_a((String)new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)aspects));
                }
                catch (Exception ex) {
                    throw new JsonParseException(this.getRegistryName().func_110623_a() + ": Failed to parse the 'aspects' object:" + ex.getMessage());
                }
            }
            if ((res = JSONUtils.func_152754_s((JsonObject)json, (String)"result")).has("tag")) {
                ResourceLocation rl = new ResourceLocation(res.get("tag").getAsString());
                ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_241833_a().getOrDefault(rl, null);
                if (tag == null) {
                    throw new JsonParseException(this.getRegistryName().func_110623_a() + ": Result tag does not exist: #" + rl);
                }
                if (tag.func_230236_b_().isEmpty()) {
                    throw new JsonParseException(this.getRegistryName().func_110623_a() + ": Result tag has no items: #" + rl);
                }
                if (res.has("item")) {
                    res.remove("item");
                }
                resultTag = rl;
                ArrayList lst = Lists.newArrayList((Iterable)tag.func_230236_b_());
                res.addProperty("item", ((Item)lst.get(0)).getRegistryName().toString());
            }
            ItemStack result_stack = ShapedRecipe.func_199798_a((JsonObject)res);
            return new ExtendedShapelessRecipe(recipeId, group, result_stack, (NonNullList<Ingredient>)list, aspects_nbt, resultTag);
        }

        public ExtendedShapelessRecipe read(ResourceLocation recipeId, PacketBuffer pkt) {
            String group = pkt.func_150789_c(Short.MAX_VALUE);
            int size = pkt.func_150792_a();
            NonNullList list = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)pkt));
            }
            ItemStack stack = pkt.func_150791_c();
            CompoundNBT aspects = pkt.func_150793_b();
            ResourceLocation resultTag = pkt.func_192575_l();
            return new ExtendedShapelessRecipe(recipeId, group, stack, (NonNullList<Ingredient>)list, aspects, resultTag);
        }

        public void write(PacketBuffer pkt, ExtendedShapelessRecipe recipe) {
            pkt.func_180714_a(recipe.func_193358_e());
            pkt.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(pkt);
            }
            pkt.func_150788_a(recipe.func_77571_b());
            pkt.func_150786_a(recipe.getAspects());
            pkt.func_192572_a(recipe.resultTag);
        }
    }

    public static interface IRepairableToolItem {
        public ItemStack onShapelessRecipeRepaired(ItemStack var1, int var2, int var3);
    }
}

