/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc.detail;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.SidedProxy;

public class Networking {
    private static final String PROTOCOL = "1";
    private static SimpleChannel DEFAULT_CHANNEL;

    public static void init(String modid) {
        DEFAULT_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, "default_ch")).clientAcceptedVersions(PROTOCOL::equals).serverAcceptedVersions(PROTOCOL::equals).networkProtocolVersion(() -> PROTOCOL).simpleChannel();
        int discr = -1;
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyClientToServer.class, PacketTileNotifyClientToServer::compose, PacketTileNotifyClientToServer::parse, PacketTileNotifyClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyServerToClient.class, PacketTileNotifyServerToClient::compose, PacketTileNotifyServerToClient::parse, PacketTileNotifyServerToClient.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, OverlayTextMessage.class, OverlayTextMessage::compose, OverlayTextMessage::parse, OverlayTextMessage.Handler::handle);
    }

    public static class OverlayTextMessage {
        public static final int DISPLAY_TIME_MS = 3000;
        private static BiConsumer<ITextComponent, Integer> handler_ = null;
        private ITextComponent data_;
        private int delay_ = 3000;

        private ITextComponent data() {
            return this.data_;
        }

        private int delay() {
            return this.delay_;
        }

        public static void setHandler(BiConsumer<ITextComponent, Integer> handler) {
            if (handler_ == null) {
                handler_ = handler;
            }
        }

        public static void sendToPlayer(PlayerEntity player, ITextComponent message, int delay) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new OverlayTextMessage(message, delay), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public OverlayTextMessage() {
            this.data_ = new TranslationTextComponent("[unset]");
        }

        public OverlayTextMessage(ITextComponent tct, int delay) {
            this.data_ = tct.func_230532_e_();
            this.delay_ = delay;
        }

        public static OverlayTextMessage parse(PacketBuffer buf) {
            try {
                return new OverlayTextMessage(buf.func_179258_d(), buf.readInt());
            }
            catch (Throwable e) {
                return new OverlayTextMessage((ITextComponent)new StringTextComponent("[incorrect translation]"), 3000);
            }
        }

        public static void compose(OverlayTextMessage pkt, PacketBuffer buf) {
            try {
                buf.func_179256_a(pkt.data());
                buf.writeInt(pkt.delay());
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("OverlayTextMessage.toBytes() failed: " + e.toString());
            }
        }

        public static class Handler {
            public static void handle(OverlayTextMessage pkt, Supplier<NetworkEvent.Context> ctx) {
                if (handler_ != null) {
                    ctx.get().enqueueWork(() -> handler_.accept(pkt.data(), pkt.delay()));
                }
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyServerToClient {
        CompoundNBT nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToPlayer(PlayerEntity player, TileEntity te, CompoundNBT nbt) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer || te == null || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketTileNotifyServerToClient(te, nbt), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static void sendToPlayers(TileEntity te, CompoundNBT nbt) {
            if (te == null) {
                return;
            }
            for (PlayerEntity player : te.func_145831_w().func_217369_A()) {
                PacketTileNotifyServerToClient.sendToPlayer(player, te, nbt);
            }
        }

        public PacketTileNotifyServerToClient() {
        }

        public PacketTileNotifyServerToClient(BlockPos pos, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyServerToClient(TileEntity te, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyServerToClient parse(PacketBuffer buf) {
            return new PacketTileNotifyServerToClient(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyServerToClient pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    World world = SidedProxy.getWorldClientSide();
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onServerPacketReceived(pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyClientToServer {
        CompoundNBT nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToServer(BlockPos pos, CompoundNBT nbt) {
            if (pos != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(pos, nbt));
            }
        }

        public static void sendToServer(TileEntity te, CompoundNBT nbt) {
            if (te != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(te, nbt));
            }
        }

        public PacketTileNotifyClientToServer() {
        }

        public PacketTileNotifyClientToServer(BlockPos pos, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyClientToServer(TileEntity te, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyClientToServer parse(PacketBuffer buf) {
            return new PacketTileNotifyClientToServer(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyClientToServer pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    World world = player.field_70170_p;
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onClientPacketReceived((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(CompoundNBT nbt) {
        }

        default public void onClientPacketReceived(PlayerEntity player, CompoundNBT nbt) {
        }
    }
}

