/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc.detail;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.Networking;
import wile.redstonepen.libmc.detail.SidedProxy;

public class Overlay {
    public static void register() {
        if (SidedProxy.mc() != null) {
            MinecraftForge.EVENT_BUS.register((Object)new TextOverlayGui());
            Networking.OverlayTextMessage.setHandler(TextOverlayGui::show);
        }
    }

    public static void show(PlayerEntity player, ITextComponent message) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, 3000);
    }

    public static void show(PlayerEntity player, ITextComponent message, int delay) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, delay);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    @OnlyIn(value=Dist.CLIENT)
    public static class TextOverlayGui
    extends AbstractGui {
        private static final ITextComponent EMPTY_TEXT = new StringTextComponent("");
        private static double overlay_y_ = 0.75;
        private static int text_color_ = 0xFFAA00;
        private static int border_color_ = -1439485133;
        private static int background_color1_ = -1439485133;
        private static int background_color2_ = -1438366652;
        private final Minecraft mc = SidedProxy.mc();
        private static long deadline_;
        private static ITextComponent text_;
        private static boolean disable_dueto_exception;

        public static void on_config(double overlay_y) {
            TextOverlayGui.on_config(overlay_y, text_color_, border_color_, background_color1_, background_color2_);
        }

        public static void on_config(double overlay_y, int text_color, int border_color, int background_color1, int background_color2) {
            overlay_y_ = overlay_y;
            text_color_ = text_color;
            border_color_ = border_color;
            background_color1_ = background_color1;
            background_color2_ = background_color2;
        }

        public static synchronized ITextComponent text() {
            return text_;
        }

        public static synchronized long deadline() {
            return deadline_;
        }

        public static synchronized void hide() {
            deadline_ = 0L;
            text_ = EMPTY_TEXT;
        }

        public static synchronized void show(ITextComponent s, int displayTimeoutMs) {
            text_ = s == null ? EMPTY_TEXT : s.func_230532_e_();
            deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        public static synchronized void show(String s, int displayTimeoutMs) {
            text_ = s == null || s.isEmpty() ? EMPTY_TEXT : new StringTextComponent(s);
            deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        TextOverlayGui() {
        }

        @SubscribeEvent
        public void onRenderGui(RenderGameOverlayEvent.Post event) {
            if (disable_dueto_exception) {
                return;
            }
            if (event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
                return;
            }
            if (TextOverlayGui.deadline() < System.currentTimeMillis()) {
                return;
            }
            if (TextOverlayGui.text() == EMPTY_TEXT) {
                return;
            }
            String txt = TextOverlayGui.text().getString();
            if (txt.isEmpty()) {
                return;
            }
            MatrixStack mxs = event.getMatrixStack();
            MainWindow win = this.mc.func_228018_at_();
            FontRenderer fr = this.mc.field_71466_p;
            boolean was_unicode = fr.func_78260_a();
            try {
                int cx = win.func_198107_o() / 2;
                int cy = (int)((double)win.func_198087_p() * overlay_y_);
                int w = fr.func_78256_a(txt);
                fr.getClass();
                int h = 9;
                this.func_238468_a_(mxs, cx - w / 2 - 3, cy - 2, cx + w / 2 + 2, cy + h + 2, background_color1_, background_color2_);
                this.func_238465_a_(mxs, cx - w / 2 - 3, cx + w / 2 + 2, cy - 2, border_color_);
                this.func_238465_a_(mxs, cx - w / 2 - 3, cx + w / 2 + 2, cy + h + 2, border_color_);
                this.func_238473_b_(mxs, cx - w / 2 - 3, cy - 2, cy + h + 2, border_color_);
                this.func_238473_b_(mxs, cx + w / 2 + 2, cy - 2, cy + h + 2, border_color_);
                TextOverlayGui.func_238472_a_((MatrixStack)mxs, (FontRenderer)fr, (ITextComponent)TextOverlayGui.text(), (int)cx, (int)(cy + 1), (int)text_color_);
            }
            catch (Throwable ex) {
                disable_dueto_exception = true;
                Auxiliaries.logError("Disabled Overlay GUI due to exception:" + ex.toString());
            }
        }

        static {
            disable_dueto_exception = false;
        }
    }
}

