/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.redstonepen.ModConfig;
import wile.redstonepen.ModContent;
import wile.redstonepen.libmc.detail.Auxiliaries;
import wile.redstonepen.libmc.detail.ExtendedShapelessRecipe;
import wile.redstonepen.libmc.detail.Networking;
import wile.redstonepen.libmc.detail.Overlay;

@Mod(value="redstonepen")
public class ModRedstonePen {
    public static final String MODID = "redstonepen";
    public static final String MODNAME = "Redstone Pen";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean USE_CONFIG = false;
    public static final CreativeModeTab ITEMGROUP = new CreativeModeTab("tabredstonepen"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModContent.QUILL_ITEM);
        }
    };

    public ModRedstonePen() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Networking.init(MODID);
        ModConfig.apply();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Overlay.register();
        ModContent.registerTileEntityRenderers(event);
        ModContent.processContentClientSide();
        Overlay.TextOverlayGui.on_config(0.75, 0xFFAA00, 0x55333333, 0x55333333, 0x55444444);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.allBlocks().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.allItems().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
            ModContent.allTileEntityTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onRegisterModels(ModelRegistryEvent event) {
            ModContent.registerModels();
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<RecipeSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)ExtendedShapelessRecipe.SERIALIZER);
        }
    }
}

