/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.ModContent;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.blocks.StandardBlocks;
import wile.redstonepen.libmc.detail.Auxiliaries;

public class CircuitComponents {

    public static class BridgeRelayBlock
    extends RelayBlock {
        private int power_update_recursion_level_ = 0;

        public BridgeRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        protected int getInputPower(Level world, BlockPos relay_pos, Direction side) {
            BlockPos pos = relay_pos.m_142300_(side);
            BlockState state = world.m_8055_(pos);
            int p = 0;
            if (this.power_update_recursion_level_ < 32) {
                ++this.power_update_recursion_level_;
                if (state.m_60713_(Blocks.f_50088_)) {
                    p = Math.max(0, (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_) - 2);
                } else if (state.m_60713_((Block)ModContent.TRACK_BLOCK)) {
                    p = Math.max(0, RedstoneTrack.RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.getRedstonePower(side, true)).orElse(0) - 2);
                } else if (state.m_60713_((Block)ModContent.BRIDGE_RELAY_BLOCK)) {
                    p = state.m_61143_((Property)FACING) != world.m_8055_(relay_pos).m_61143_((Property)FACING) ? 0 : (((Integer)state.m_61143_((Property)ROTATION) & 1) != ((Integer)world.m_8055_(relay_pos).m_61143_((Property)ROTATION) & 1) ? 0 : this.getInputPower(world, pos, side));
                } else {
                    p = state.m_60746_((BlockGetter)world, pos, side);
                    if (p < 15 && !state.m_60803_() && state.shouldCheckWeakPower((LevelReader)world, pos, side)) {
                        for (Direction d : Direction.values()) {
                            if (d != side.m_122424_() && (p = Math.max(p, world.m_8055_(pos.m_142300_(d)).m_60746_((BlockGetter)world, pos.m_142300_(d), d))) >= 15) break;
                        }
                    }
                }
                if (--this.power_update_recursion_level_ < 0) {
                    this.power_update_recursion_level_ = 0;
                }
            } else {
                System.out.println("recursion");
            }
            return p;
        }

        protected boolean isWireConnected(Level world, BlockPos relay_pos, Direction side) {
            BlockPos pos = relay_pos.m_142300_(side);
            BlockState state = world.m_8055_(pos);
            return state.m_60713_(Blocks.f_50088_) || state.m_60713_((Block)ModContent.TRACK_BLOCK);
        }

        protected boolean isSidePowered(Level world, BlockPos pos, Direction side) {
            return world.m_46681_(pos.m_142300_(side), side) > 0;
        }

        @Override
        protected boolean isPowered(BlockState state, Level world, BlockPos pos) {
            return this.isSidePowered(world, pos, (Direction)state.m_61143_((Property)FACING)) || this.isSidePowered(world, pos, this.getOutputFacing(state).m_122424_());
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            if (redstone_side == this.getOutputFacing(state).m_122424_()) {
                return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
            }
            int p = 0;
            Direction left = this.getLeftFacing(state);
            Direction right = this.getRightFacing(state);
            if ((redstone_side == left || redstone_side == right) && world instanceof ServerLevel) {
                boolean right_source;
                boolean left_source = !this.isWireConnected((Level)((ServerLevel)world), pos, left) && world.m_8055_(pos.m_142300_(left)).m_60803_();
                boolean bl = right_source = !this.isWireConnected((Level)((ServerLevel)world), pos, right) && world.m_8055_(pos.m_142300_(right)).m_60803_();
                p = left_source && !right_source ? this.getInputPower((Level)((ServerLevel)world), pos, left) : (!left_source && right_source ? this.getInputPower((Level)((ServerLevel)world), pos, right) : Math.max(0, Math.max(this.getInputPower((Level)((ServerLevel)world), pos, left), this.getInputPower((Level)((ServerLevel)world), pos, right))));
            }
            return p;
        }

        @Override
        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return this.m_6378_(state, world, pos, redsrone_side);
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.m_61143_((Property)POWERED) && !world.m_6219_().m_5916_(pos, (Object)this)) {
                if (powered) {
                    this.lock_update = true;
                    state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
                    world.m_7731_(pos, state, 15);
                    world.m_46586_(pos.m_142300_(this.getOutputFacing(state)), (Block)this, pos);
                    this.lock_update = false;
                } else {
                    world.m_6219_().m_5945_(pos, (Object)this, 2);
                }
            }
            if (fromPos != null) {
                BlockPos v = pos.m_141950_((Vec3i)fromPos);
                Direction dir = Direction.m_122372_((float)v.m_123341_(), (float)v.m_123342_(), (float)v.m_123343_());
                Direction left = this.getLeftFacing(state);
                Direction right = this.getRightFacing(state);
                if (dir == left || dir == right) {
                    this.lock_update = true;
                    this.power_update_recursion_level_ = 0;
                    int pr = this.m_6378_(state, (BlockGetter)world, pos, right);
                    int pl = this.m_6378_(state, (BlockGetter)world, pos, left);
                    boolean track_powered = pr > 0 || pl > 0;
                    if (track_powered != ((Integer)state.m_61143_((Property)STATE) == 1)) {
                        state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(track_powered ? 1 : 0));
                        world.m_7731_(pos, state, 15);
                    }
                    world.m_46586_(pos.m_142300_(dir), (Block)this, pos);
                    this.lock_update = false;
                }
            }
            return state;
        }
    }

    public static class PulseRelayBlock
    extends RelayBlock {
        public PulseRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return (Integer)state.m_61143_((Property)STATE) == 0 || redsrone_side != this.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rnd) {
            if ((Integer)state.m_61143_((Property)STATE) == 0) {
                return;
            }
            state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(0));
            world.m_7731_(pos, state, 15);
            this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
                state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
                if (powered) {
                    boolean trig = (Integer)state.m_61143_((Property)STATE) == 0;
                    state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(1));
                    world.m_7731_(pos, state, 15);
                    if (trig) {
                        this.notifyOutputNeighbourOfStateChange(state, world, pos);
                    }
                } else {
                    world.m_7731_(pos, state, 15);
                }
            }
            if (!world.m_6219_().m_5916_(pos, (Object)this)) {
                world.m_6219_().m_5945_(pos, (Object)this, 2);
            }
            return state;
        }
    }

    public static class BistableRelayBlock
    extends RelayBlock {
        public BistableRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return (Integer)state.m_61143_((Property)STATE) == 0 || redsrone_side != this.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rnd) {
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean pwstate;
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (pwstate = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue())) {
                return state;
            }
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered && !pwstate) {
                state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STATE) == 0 ? 1 : 0));
                world.m_7731_(pos, state, 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else if (!powered && pwstate) {
                world.m_7731_(pos, state, 15);
            }
            return state;
        }
    }

    public static class InvertedRelayBlock
    extends RelayBlock {
        private boolean lock_update = false;

        public InvertedRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return (Boolean)state.m_61143_((Property)POWERED) != false || redsrone_side != this.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rnd) {
            boolean powered = this.isPowered(state, (Level)world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return;
            }
            if (powered) {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 15);
                this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
                this.lock_update = false;
            }
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return state;
            }
            if (world.m_6219_().m_5916_(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.m_6219_().m_5945_(pos, (Object)this, 2);
            } else {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                this.lock_update = false;
            }
            return state;
        }
    }

    public static class RelayBlock
    extends DirectedComponentBlock {
        protected boolean lock_update = false;

        protected boolean isPowered(BlockState state, Level world, BlockPos pos) {
            Direction output_side = this.getOutputFacing(state);
            Direction mount_side = (Direction)state.m_61143_((Property)FACING);
            for (Direction side : Direction.values()) {
                if (side == output_side || side == mount_side.m_122424_() || world.m_46681_(pos.m_142300_(side), side) <= 0) continue;
                return true;
            }
            return false;
        }

        public RelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return (Boolean)state.m_61143_((Property)POWERED) == false || redsrone_side != this.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return this.m_6378_(state, world, pos, redsrone_side);
        }

        @Override
        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rnd) {
            boolean powered = this.isPowered(state, (Level)world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return;
            }
            if (!powered) {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 15);
                this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
                this.lock_update = false;
            }
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return state;
            }
            if (world.m_6219_().m_5916_(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                this.lock_update = false;
            } else {
                world.m_6219_().m_5945_(pos, (Object)this, 2);
            }
            return state;
        }
    }

    public static class DirectedComponentBlock
    extends StandardBlocks.WaterLoggable {
        public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
        public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
        public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
        public static final IntegerProperty STATE = IntegerProperty.m_61631_((String)"state", (int)0, (int)1);
        protected final Map<BlockState, VoxelShape> shapes_ = new HashMap<BlockState, VoxelShape>();
        protected static final List<Direction> facing_mapping_ = new ArrayList<Direction>();

        protected static VoxelShape mapped_shape(BlockState state, AABB[] aabb) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case DOWN: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 2));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 3));
                        }
                    }
                }
                case UP: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 0), Direction.Axis.Y));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 1), Direction.Axis.Y));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 2), Direction.Axis.Y));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 3), Direction.Axis.Y));
                        }
                    }
                }
                case NORTH: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.DOWN));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.DOWN));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.DOWN));
                        }
                    }
                }
                case EAST: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.WEST), 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP), 3));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 3));
                        }
                    }
                }
                case SOUTH: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.UP));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP));
                        }
                    }
                }
                case WEST: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.EAST));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.DOWN), Direction.WEST));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 1));
                        }
                    }
                }
            }
            return Shapes.m_83144_();
        }

        public DirectedComponentBlock(long config, BlockBehaviour.Properties builder, AABB[] aabbs) {
            super(config, builder);
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0)));
            this.f_49792_.m_61056_().forEach(state -> this.shapes_.put((BlockState)state, DirectedComponentBlock.mapped_shape(state, aabbs)));
        }

        public DirectedComponentBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            this(config, builder, new AABB[]{aabb});
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FACING, ROTATION, POWERED, STATE});
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }

        @Override
        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return true;
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return this.shapes_.getOrDefault(state, Shapes.m_83144_());
        }

        @Override
        public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
            return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
        }

        @Override
        public PushReaction m_5537_(BlockState state) {
            return PushReaction.DESTROY;
        }

        @Override
        @Deprecated
        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return side == null || side != state.m_61143_((Property)FACING);
        }

        public boolean m_7899_(BlockState state) {
            return true;
        }

        public boolean m_7278_(BlockState state) {
            return false;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return 0;
        }

        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return 0;
        }

        @Deprecated
        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redsrone_side) {
            return 0;
        }

        @Override
        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rnd) {
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return state;
            }
            Direction face = context.m_43719_().m_122424_();
            Vec3 hit_r = context.m_43720_().m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()));
            Vec3 hit = switch (face) {
                case Direction.EAST, Direction.WEST -> hit_r.m_82542_(0.0, 1.0, 1.0);
                case Direction.NORTH, Direction.SOUTH -> hit_r.m_82542_(1.0, 1.0, 0.0);
                default -> hit_r.m_82542_(1.0, 0.0, 1.0);
            };
            Direction dir = Direction.m_122366_((double)hit.m_7096_(), (double)hit.m_7098_(), (double)hit.m_7094_());
            int rotation = 0;
            block4 : switch (face) {
                case DOWN: 
                case UP: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (dir) {
                        case SOUTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case NORTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (dir) {
                        case WEST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case EAST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (dir) {
                        case NORTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                }
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0));
            if (!this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_())) {
                return null;
            }
            return state;
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if ((state = super.m_7417_(state, facing, facingState, world, pos, facingPos)) == null) {
                return state;
            }
            if (!this.m_7898_(state, (LevelReader)world, pos)) {
                return Blocks.f_50016_.m_49966_();
            }
            return world instanceof ServerLevel ? this.update(state, (Level)((ServerLevel)world), pos, facingPos) : state;
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            Direction face = (Direction)state.m_61143_((Property)FACING);
            BlockPos adj_pos = pos.m_142300_(face);
            return world.m_8055_(adj_pos).m_60783_((BlockGetter)world, adj_pos, face.m_122424_());
        }

        public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
            this.update(state, world, pos, null);
        }

        @Override
        public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.m_60713_(newState.m_60734_())) {
                return;
            }
            super.m_6810_(state, world, pos, newState, isMoving);
            if (!world.m_5776_()) {
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                world.m_46672_(pos, (Block)this);
            }
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            this.update(state, world, pos, fromPos);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(Level world, Random rand, BlockPos pos, Vec3 color, Direction side, float chance) {
            if (rand.nextFloat() < chance) {
                double c2 = chance * rand.nextFloat();
                double p0 = 0.5 + (double)side.m_122429_() * 0.4 + c2 * 0.1;
                double p1 = 0.5 + (double)side.m_122430_() * 0.4 + c2 * 0.1;
                double p2 = 0.5 + (double)side.m_122431_() * 0.4 + c2 * 0.1;
                world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(color), 1.0f), (double)pos.m_123341_() + p0, (double)pos.m_123342_() + p1, (double)pos.m_123343_() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
            if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue() || (double)rand.nextFloat() > 0.4) {
                return;
            }
            Vec3 color = new Vec3((double)0.6f, 0.0, 0.0);
            Direction side = (Direction)state.m_61143_((Property)FACING);
            this.spawnPoweredParticle(world, rand, pos, color, side, 0.3f);
        }

        protected final Direction getOutputFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + (Integer)state.m_61143_((Property)ROTATION));
        }

        protected final Direction getFrontFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) & 3));
        }

        protected final Direction getRightFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) + 1 & 3));
        }

        protected final Direction getBackFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) + 2 & 3));
        }

        protected final Direction getLeftFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) + 3 & 3));
        }

        protected void notifyOutputNeighbourOfStateChange(BlockState state, Level world, BlockPos pos) {
            Direction facing = this.getOutputFacing(state);
            BlockPos adjacent_pos = pos.m_142300_(facing);
            BlockState adjacent_state = world.m_8055_(adjacent_pos);
            try {
                adjacent_state.m_60690_(world, adjacent_pos, (Block)this, pos, false);
                if (adjacent_state.shouldCheckWeakPower((LevelReader)world, adjacent_pos, facing)) {
                    world.m_46590_(adjacent_pos, state.m_60734_(), facing.m_122424_());
                }
            }
            catch (Throwable ex) {
                ModRedstonePen.logger().error("Track neighborChanged recursion detected, dropping!");
                Vec3 p = Vec3.m_82512_((Vec3i)pos);
                world.m_7967_((Entity)new ItemEntity(world, p.f_82479_, p.f_82480_, p.f_82481_, new ItemStack((ItemLike)this, 1)));
                world.m_7731_(pos, world.m_8055_(pos).m_60819_().m_76188_(), 18);
            }
        }

        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            return state;
        }

        static {
            Arrays.stream(Direction.values()).forEach(face -> {
                switch (face) {
                    case DOWN: 
                    case UP: {
                        facing_mapping_.add(Direction.NORTH);
                        facing_mapping_.add(Direction.EAST);
                        facing_mapping_.add(Direction.SOUTH);
                        facing_mapping_.add(Direction.WEST);
                        break;
                    }
                    case NORTH: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.EAST);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.WEST);
                        break;
                    }
                    case EAST: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.SOUTH);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.NORTH);
                        break;
                    }
                    case SOUTH: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.WEST);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.EAST);
                        break;
                    }
                    case WEST: {
                        facing_mapping_.add(Direction.UP);
                        facing_mapping_.add(Direction.NORTH);
                        facing_mapping_.add(Direction.DOWN);
                        facing_mapping_.add(Direction.SOUTH);
                    }
                }
            });
        }
    }
}

