/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class WallFoundationDataManager {
    public static Hashtable<String, wallFoundationItem> wallFoundationsHashtable = new Hashtable();
    private static String defaultWallFoundationString;
    private static String defaultWallFoundationKey;

    public static wallFoundationItem getWallFoundationInfo(String key) {
        String iKey = key;
        if (wallFoundationsHashtable.isEmpty()) {
            WallFoundationDataManager.wallFoundationsInit();
        }
        wallFoundationItem r = wallFoundationsHashtable.get(iKey);
        return r;
    }

    public static String getWallFoundationHashAsString() {
        String returnString = "";
        for (String key : wallFoundationsHashtable.keySet()) {
            String wallFoundationType = WallFoundationDataManager.wallFoundationsHashtable.get((Object)key).wallFoundationType;
            String tempString = key + "," + wallFoundationType + ";";
            returnString = returnString + tempString;
        }
        return returnString;
    }

    public static void wallFoundationsInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        int i = 0;
        String wallFoundationsLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultWallFoundations6464, ";");
        while (st6464.hasMoreElements()) {
            wallFoundationsLine6464 = st6464.nextToken().trim();
            if (wallFoundationsLine6464.isEmpty()) continue;
            dTL6464.add(wallFoundationsLine6464);
            ++i;
        }
        MyConfig.defaultWallFoundations = dTL6464.toArray(new String[i]);
        wallFoundationsHashtable.clear();
        for (i = 0; i < MyConfig.defaultWallFoundations.length; ++i) {
            try {
                String wallFoundationBlockKey;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultWallFoundations[i], ",");
                String key = wallFoundationBlockKey = st.nextToken();
                wallFoundationsHashtable.put(key, new wallFoundationItem(wallFoundationBlockKey));
                if (wallFoundationBlockKey.contentEquals("hbm:default") || ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(wallFoundationBlockKey))) continue;
                System.out.println("Regrowth Debug: Wall Foundation Block: " + wallFoundationBlockKey + " not in Forge Entity Type Registry.  Mispelled?  Missing semicolon? ");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Foundation Config : " + MyConfig.defaultWallFoundations[i]);
            }
        }
    }

    static {
        defaultWallFoundationKey = defaultWallFoundationString = "hbm:default";
    }

    public static class wallFoundationItem {
        String wallFoundationType;

        public wallFoundationItem(String wallFoundationType) {
            this.wallFoundationType = wallFoundationType;
        }

        public String getwallFoundationType() {
            return this.wallFoundationType.toLowerCase();
        }
    }
}

