/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoveEntityEvent {
    private static int[] dx = new int[]{1, 0, -1, 0};
    private static int[] dz = new int[]{0, 1, 0, -1};
    private static int TICKS_PER_SECOND = 20;
    private static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    private static int lastTorchX = 0;
    private static int lastTorchY = 0;
    private static int lastTorchZ = 0;
    static final int WALL_CENTER = 0;
    static final int FENCE_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final int WALL_TYPE_FENCE = -2;

    @SubscribeEvent
    public void handleEntityMoveEvents(LivingEvent.LivingUpdateEvent event) {
        boolean debugvalue;
        double randomD100Roll;
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            return;
        }
        if (!(entity.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld sWorld = (ServerWorld)entity.field_70170_p;
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        Block footBlock = sWorld.func_180495_p(ePos).func_177230_c();
        if (footBlock instanceof CarpetBlock) {
            return;
        }
        if (footBlock == Blocks.field_150433_aE) {
            footBlock = Blocks.field_150350_a;
        }
        Block groundBlock = sWorld.func_180495_p(ePos.func_177977_b()).func_177230_c();
        if (entity.func_233570_aj_() && footBlock == Blocks.field_150350_a && groundBlock == Blocks.field_150350_a) {
            return;
        }
        Biome localBiome = sWorld.func_226691_t_(ePos);
        EntityType tempType = entity.func_200600_R();
        ResourceLocation registryName = tempType.getRegistryName();
        String registryNameAsString = registryName.toString();
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        String regrowthActions = currentRegrowthMobItem.getRegrowthActions();
        if (this.isImpossibleRegrowthEvent(footBlock, regrowthActions)) {
            return;
        }
        double regrowthEventOdds = 1.0 / currentRegrowthMobItem.getRegrowthEventSeconds() * (double)TICKS_PER_SECOND;
        if (this.isHorseTypeEatingNow(entity)) {
            regrowthEventOdds *= 20.0;
        }
        if ((randomD100Roll = entity.field_70170_p.field_73012_v.nextDouble() * 100.0) <= regrowthEventOdds + (double)(debugvalue = false)) {
            if (entity instanceof VillagerEntity) {
                VillagerEntity ve = (VillagerEntity)entity;
                if (ve.func_233570_aj_() && !(footBlock instanceof BedBlock)) {
                    this.doVillagerRegrowthEvents(ve, footBlock, groundBlock, registryNameAsString, regrowthActions, localBiome);
                }
            } else {
                this.doMobRegrowthEvents(entity, footBlock, groundBlock, registryNameAsString, regrowthActions, localBiome);
            }
        }
    }

    private BlockPos getAdjustedBlockPos(Entity entity) {
        BlockPos ePos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.99, entity.func_226281_cx_());
        return ePos;
    }

    private void doMobRegrowthEvents(Entity entity, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        if (regrowthType.equals("stumble")) {
            if (footBlock instanceof TorchBlock || footBlock instanceof WallTorchBlock) {
                this.mobStumbleAction(entity, key);
            }
            return;
        }
        if (regrowthType.equals("reforest")) {
            this.mobReforestAction(entity, footBlock, groundBlock, key, localBiome);
            return;
        }
        if (regrowthType.equals("mushroom")) {
            this.mobGrowMushroomAction(entity, groundBlock, key);
            return;
        }
        if (!this.isKindOfGrassBlock(groundBlock)) {
            return;
        }
        if (regrowthType.equals("tall")) {
            this.mobGrowTallAction(entity, footBlock, key);
            return;
        }
        if (regrowthType.equals("both")) {
            regrowthType = entity.field_70170_p.field_73012_v.nextDouble() * 100.0 > 85.0 ? "grow" : "eat";
        }
        if (regrowthType.contentEquals("eat")) {
            this.mobEatPlantsAction(entity, footBlock, groundBlock, key, regrowthType);
            return;
        }
        if (regrowthType.equals("grow")) {
            this.mobGrowPlantsAction(entity, footBlock, groundBlock, key);
            return;
        }
    }

    private boolean mobGrowPlantsAction(Entity entity, Block footBlock, Block groundBlock, String key) {
        if (footBlock instanceof AirBlock) {
            if (!(groundBlock instanceof IGrowable)) {
                return false;
            }
            BlockPos bpos = entity.func_233580_cy_();
            if (bpos == null) {
                MyConfig.debugMsg(1, "ERROR:" + key + "grow plant null position.");
                return false;
            }
            IGrowable ib = (IGrowable)groundBlock;
            MyConfig.debugMsg(1, entity.func_233580_cy_(), key + " growable plant found.");
            try {
                ServerWorld serverworld = (ServerWorld)entity.field_70170_p;
                Random rand = entity.field_70170_p.field_73012_v;
                BlockState bs = entity.field_70170_p.func_180495_p(bpos);
                ib.func_225535_a_(serverworld, rand, bpos, bs);
                MyConfig.debugMsg(1, bpos, key + " grew plant.");
            }
            catch (Exception e) {
                MyConfig.debugMsg(1, bpos, key + " caught grow attempt exception.");
            }
        }
        return true;
    }

    private boolean isKindOfGrassBlock(Block groundBlock) {
        if (groundBlock instanceof GrassBlock) {
            return true;
        }
        return groundBlock.func_149739_a().equals("block.byg.meadow_grass_block");
    }

    private boolean isBlockGrassOrDirt(Block tempBlock) {
        return this.isKindOfGrassBlock(tempBlock) || tempBlock == Blocks.field_150346_d;
    }

    private BlockState helperSaplingState(World world, BlockPos pos, Biome localBiome, BlockState sapling) {
        sapling = Blocks.field_196674_t.func_176223_P();
        RegistryKey k = Registry.field_239720_u_;
        String biomeName = world.func_241828_r().func_243612_b(k).func_177774_c((Object)localBiome).toString();
        if (biomeName.contains("birch")) {
            sapling = Blocks.field_196676_v.func_176223_P();
        }
        if (biomeName.contains("taiga")) {
            sapling = Blocks.field_196675_u.func_176223_P();
        }
        if (biomeName.contains("jungle")) {
            sapling = Blocks.field_196678_w.func_176223_P();
        }
        if (biomeName.contains("savanna")) {
            sapling = Blocks.field_196679_x.func_176223_P();
        }
        if (biomeName.contains("desert")) {
            sapling = Blocks.field_196679_x.func_176223_P();
        }
        return sapling;
    }

    private void mobReforestAction(Entity entity, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        if (footBlock != Blocks.field_150350_a) {
            return;
        }
        if (!this.isBlockGrassOrDirt(groundBlock)) {
            return;
        }
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        int eX = ePos.func_177958_n();
        int eY = ePos.func_177956_o();
        int eZ = ePos.func_177952_p();
        double sinY = Math.sin((double)((eY + 64) % 256) / 256.0);
        if (entity.field_70170_p.field_73012_v.nextDouble() > Math.abs(sinY)) {
            return;
        }
        BlockState sapling = null;
        sapling = this.helperSaplingState(entity.field_70170_p, ePos, localBiome, sapling);
        int hval = 5;
        int yval = 0;
        int yrange = 0;
        if (this.helperCountBlocksBB(SaplingBlock.class, 1, entity.field_70170_p, ePos, hval, yrange) > 0) {
            return;
        }
        int leafCount = 0;
        yval = 4;
        yrange = 0;
        hval = 4;
        if (sapling == Blocks.field_196679_x.func_176223_P()) {
            yval = 5;
            hval = 7;
        }
        if ((leafCount = this.helperCountBlocksBB(LeavesBlock.class, 1, entity.field_70170_p, ePos.func_177981_b(yval), hval, yrange)) > 0) {
            return;
        }
        entity.field_70170_p.func_175656_a(ePos, sapling);
        MyConfig.debugMsg(1, ePos, key + " planted sapling.");
    }

    private void mobGrowMushroomAction(Entity entity, Block groundBlock, String key) {
        int huge;
        ServerWorld sWorld = (ServerWorld)entity.field_70170_p;
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        if (sWorld.func_180495_p(ePos).func_177230_c() instanceof MushroomBlock) {
            return;
        }
        if (sWorld.func_226660_f_(ePos)) {
            return;
        }
        if (!this.isGoodMushroomTemperature(entity)) {
            return;
        }
        Random mushRand = new Random(this.helperLongRandomSeed(ePos));
        double fertilityDouble = mushRand.nextDouble();
        fertilityDouble = mushRand.nextDouble();
        if (fertilityDouble < 0.75) {
            MyConfig.debugMsg(1, ePos, key + " Mushroom fertility (" + fertilityDouble + ") non-growing spot.");
            return;
        }
        int smallMushroomCount = this.helperCountBlocksBB(MushroomBlock.class, 4, (World)sWorld, ePos, 4, 1);
        if (smallMushroomCount > 3) {
            MyConfig.debugMsg(1, ePos, key + " smallMushroomCount (" + smallMushroomCount + ") mushroom too crowded.");
            return;
        }
        if (groundBlock == Blocks.field_150419_aX) {
            sWorld.func_175656_a(ePos, Blocks.field_150337_Q.func_176223_P());
            return;
        }
        if (groundBlock == Blocks.field_150420_aW) {
            sWorld.func_175656_a(ePos, Blocks.field_150338_P.func_176223_P());
            return;
        }
        int hugeMushroomCount = this.helperCountBlocksBB(HugeMushroomBlock.class, 1, (World)sWorld, ePos, 1, 1);
        if (hugeMushroomCount <= 0 && (huge = this.helperCountBlocksBB(HugeMushroomBlock.class, 1, (World)sWorld, ePos, MyConfig.getMushroomDensity(), 1)) > 0) {
            MyConfig.debugMsg(1, ePos, key + " huge (" + huge + ") mushroom too crowded.");
            return;
        }
        boolean growMushroom = false;
        if (BlockTags.field_242172_aH == null) {
            MyConfig.debugMsg(0, "BlockTags.BASE_STONE_OVERWORLD missing.");
            if (groundBlock.getBlock() == Blocks.field_150348_b || groundBlock.getBlock() == Blocks.field_196654_e || groundBlock.getBlock() == Blocks.field_196656_g || groundBlock.getBlock() == Blocks.field_196650_c) {
                growMushroom = true;
            }
        } else {
            if (!BlockTags.field_242172_aH.func_230235_a_((Object)groundBlock)) {
                return;
            }
            growMushroom = true;
        }
        if (growMushroom) {
            double vx = entity.func_213303_ch().func_82615_a() - ((double)ePos.func_177958_n() + 0.5);
            double vz = entity.func_213303_ch().func_82616_c() - ((double)ePos.func_177952_p() + 0.5);
            Vector3d vM = new Vector3d(vx, 0.0, vz).func_72432_b().func_186678_a(1.0).func_72441_c(0.0, 0.5, 0.0);
            entity.func_213317_d(entity.func_213322_ci().func_178787_e(vM));
            if (fertilityDouble > 0.9) {
                sWorld.func_175656_a(ePos.func_177977_b(), Blocks.field_150391_bh.func_176223_P());
            }
            Block theBlock = null;
            theBlock = sWorld.field_73012_v.nextDouble() * 100.0 > 75.0 ? Blocks.field_150337_Q : Blocks.field_150338_P;
            sWorld.func_175656_a(ePos, theBlock.func_176223_P());
            MushroomBlock mb = (MushroomBlock)theBlock;
            try {
                mb.func_226940_a_(sWorld, ePos, theBlock.func_176223_P(), sWorld.field_73012_v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (theBlock == Blocks.field_150337_Q) {
                for (int y = 9; y > 3; --y) {
                    Block b = sWorld.func_180495_p(ePos.func_177981_b(y)).func_177230_c();
                    if (b != Blocks.field_196706_do) continue;
                    sWorld.func_175656_a(ePos.func_177981_b(y), Blocks.field_235383_mw_.func_176223_P());
                    break;
                }
            }
            MyConfig.debugMsg(1, ePos, key + " grow mushroom.");
        }
    }

    private long helperLongRandomSeed(BlockPos ePos) {
        return (long)Math.abs(ePos.func_177958_n() * 31) + (long)Math.abs(ePos.func_177952_p() * 11) + (long)Math.abs(ePos.func_177956_o() * 7);
    }

    public int helperCountBlocksOrthogonalBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int boundY) {
        return this.helperCountBlocksOrthogonalBB(searchBlock, maxCount, w, bPos, 0 - boundY, 0 + boundY);
    }

    public int helperCountBlocksOrthogonalBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int lowerBoundY, int upperBoundY) {
        int count = 0;
        for (int j = lowerBoundY; j <= upperBoundY; ++j) {
            if (w.func_180495_p(bPos.func_177981_b(j).func_177965_g(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (w.func_180495_p(bPos.func_177981_b(j).func_177985_f(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (w.func_180495_p(bPos.func_177981_b(j).func_177964_d(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (w.func_180495_p(bPos.func_177981_b(j).func_177970_e(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (count < maxCount) continue;
            return count;
        }
        return count;
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, boxSize);
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.func_177958_n() - boxSize;
        int maxX = bPos.func_177958_n() + boxSize;
        int minZ = bPos.func_177952_p() - boxSize;
        int maxZ = bPos.func_177952_p() + boxSize;
        int minY = bPos.func_177956_o() - ySize;
        int maxY = bPos.func_177956_o() + ySize;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    Block b = w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                    MyConfig.debugMsg(2, "dx:" + dx + ", dz:" + dz + ", dy:" + dy + "  Block:" + b.getRegistryName().toString() + ", count:" + count);
                    if (w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c() == searchBlock) {
                        ++count;
                    }
                    if (count < maxCount) continue;
                    return count;
                }
            }
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getRegistryName().toString() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public int helperCountBlocksBB(Class<? extends Block> searchBlock, int maxCount, World w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, 0);
    }

    public int helperCountBlocksBB(Class<? extends Block> searchBlock, int maxCount, World w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.func_177958_n() - boxSize;
        int maxX = bPos.func_177958_n() + boxSize;
        int minZ = bPos.func_177952_p() - boxSize;
        int maxZ = bPos.func_177952_p() + boxSize;
        int minY = bPos.func_177956_o() - ySize;
        int maxY = bPos.func_177956_o() + ySize;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    Block b = w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                    MyConfig.debugMsg(2, "dx:" + dx + ", dz:" + dz + ", dy:" + dy + "  Block:" + b.getRegistryName().toString() + ", count:" + count);
                    if (searchBlock.isInstance(w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c())) {
                        ++count;
                    }
                    if (count < maxCount) continue;
                    return count;
                }
            }
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getSimpleName() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    private boolean isGoodMushroomTemperature(Entity entity) {
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        float biomeTemp = entity.field_70170_p.func_226691_t_(ePos).func_225486_c(ePos);
        MyConfig.debugMsg(1, ePos, "Mushroom Biome temp: " + biomeTemp + ".");
        if ((double)biomeTemp < MyConfig.getMushroomMinTemp()) {
            return false;
        }
        return !((double)biomeTemp > MyConfig.getMushroomMaxTemp());
    }

    private boolean mobEatPlantsAction(Entity entity, Block footBlock, Block groundBlock, String key, String regrowthType) {
        if (this.mobEatGrassOrFlower(entity, regrowthType, footBlock, groundBlock)) {
            MyConfig.debugMsg(1, this.getAdjustedBlockPos(entity), key + " ate plants.");
            return true;
        }
        return false;
    }

    private boolean isHorseTypeEatingNow(Entity entity) {
        AbstractHorseEntity h;
        return entity instanceof AbstractHorseEntity && (h = (AbstractHorseEntity)entity).func_110204_cc();
    }

    private void mobStumbleAction(Entity entity, String key) {
        entity.field_70170_p.func_175655_b(this.getAdjustedBlockPos(entity), true);
        MyConfig.debugMsg(1, this.getAdjustedBlockPos(entity), key + " stumbled over torch.");
    }

    private void doVillagerRegrowthEvents(VillagerEntity ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        BlockPos ePos = this.getAdjustedBlockPos((Entity)ve);
        int veX = ePos.func_177958_n();
        int veY = ePos.func_177956_o();
        int veZ = ePos.func_177952_p();
        if (!this.isOnGround((Entity)ve)) {
            return;
        }
        if (MyConfig.aDebugLevel > 0) {
            StringTextComponent tName = new StringTextComponent("");
            float veYaw = ve.func_195046_g(1.0f);
            tName = new StringTextComponent("Reg-" + veX + "," + veZ + ": " + veYaw);
            ve.func_200203_b((ITextComponent)tName);
        } else if (ve.func_200201_e() != null && ve.func_200201_e().toString().contains("Reg-")) {
            ve.func_200203_b(null);
        }
        if (this.vImproveFarm(ve, groundBlock, footBlock, regrowthType)) {
            MyConfig.debugMsg(1, ePos, key + " farm improved.");
        }
        if (regrowthType.contains("v")) {
            this.vImproveLeaves(ve, groundBlock, key, veX, veY, veZ);
        }
        if (regrowthType.contains("c") && (footBlock instanceof TallGrassBlock || footBlock instanceof DoublePlantBlock || footBlock.func_149739_a().equals("block.byg.short_grass"))) {
            ve.field_70170_p.func_175655_b(ePos, false);
            MyConfig.debugMsg(1, ePos, key + " grass cut.");
        }
        if (regrowthType.contains("r")) {
            MyConfig.debugMsg(1, ePos, key + " try road improve.");
            this.vImproveRoads(ve, footBlock, groundBlock, key, localBiome);
        }
        if (regrowthType.contains("w")) {
            MyConfig.debugMsg(1, ePos, " try town wall build.");
            this.vImproveWalls(ve, footBlock, groundBlock, key, regrowthType, localBiome);
            this.helperJumpAway(ve, footBlock);
        }
        if (regrowthType.contains("p")) {
            MyConfig.debugMsg(1, ePos, " try personal fence build.");
            this.vImproveFences(ve, footBlock, groundBlock, key, regrowthType, localBiome);
            this.helperJumpAway(ve, footBlock);
        }
        if (regrowthType.contains("t") && footBlock != Blocks.field_150478_aa && this.vImproveLighting(ve, footBlock, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, ePos, key + "-" + footBlock + ", " + groundBlock + " pitch: " + ve.field_70125_A + " lighting improved.");
        }
    }

    private void helperJumpAway(VillagerEntity ve, Block footBlock) {
        if (footBlock instanceof WallBlock || footBlock instanceof FenceBlock) {
            float veYaw = ve.func_195046_g(1.0f) / 45.0f;
            int facingNdx = Math.round(veYaw);
            if (facingNdx < 0) {
                facingNdx = Math.abs(facingNdx);
            }
            double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
            double dz = (double)facingArray[facingNdx][1] / 2.0;
            ve.func_213293_j(dx, 0.55, dz);
        }
    }

    private boolean mobEatGrassOrFlower(Entity entity, String regrowthType, Block footBlock, Block groundBlock) {
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        if (!this.isGrassOrFlower(footBlock)) {
            return false;
        }
        if (this.isKindOfGrassBlock(groundBlock)) {
            this.mobTrodGrassBlock(entity);
        }
        entity.field_70170_p.func_175655_b(ePos, false);
        LivingEntity le = (LivingEntity)entity;
        this.helperChildAgeEntity(entity);
        if (le.func_110138_aP() > le.func_110143_aJ() && MyConfig.aEatingHeals == 1.0) {
            EffectInstance ei = new EffectInstance(Effects.field_76432_h, 1, 0, false, true);
            le.func_195064_c(ei);
        }
        return true;
    }

    private void mobTrodGrassBlock(Entity entity) {
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        World world = entity.field_70170_p;
        List wEntityList = world.func_217357_a(entity.getClass(), new AxisAlignedBB(ePos.func_177985_f(2).func_177964_d(2).func_177979_c(1), ePos.func_177965_g(2).func_177970_e(2).func_177981_b(1)));
        world.func_175656_a(ePos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        if (wEntityList.size() > 9) {
            MyConfig.debugMsg(1, ePos, "wEntityList overpopulated: " + wEntityList.size());
            world.func_175656_a(ePos.func_177977_b(), Blocks.field_185774_da.func_176223_P());
        }
    }

    private boolean isBlockGrassPathOrDirt(Block tempBlock) {
        return tempBlock == Blocks.field_185774_da || tempBlock == Blocks.field_150346_d;
    }

    private void helperChildAgeEntity(Entity ent) {
        AgeableEntity aEnt;
        if (ent instanceof AgeableEntity && (aEnt = (AgeableEntity)ent).func_70631_g_()) {
            aEnt.func_70873_a(aEnt.func_70874_b() + 30);
        }
    }

    private boolean mobGrowTallAction(Entity ent, Block footBlock, String key) {
        if (footBlock instanceof TallGrassBlock) {
            BlockPos ePos = this.getAdjustedBlockPos(ent);
            IGrowable ib = (IGrowable)footBlock;
            ib.func_225535_a_((ServerWorld)ent.field_70170_p, ent.field_70170_p.field_73012_v, ePos, ent.field_70170_p.func_180495_p(ePos));
            MyConfig.debugMsg(1, ePos, key + " grew and hid in tall plant.");
            return true;
        }
        return false;
    }

    private BlockState helperBiomeRoadBlockType(Biome localBiome) {
        BlockState gateBlockType = Blocks.field_185774_da.func_176223_P();
        if (localBiome.func_201856_r() == Biome.Category.DESERT) {
            gateBlockType = Blocks.field_196580_bH.func_176223_P();
        }
        return gateBlockType;
    }

    private boolean vImproveFarm(VillagerEntity ve, Block groundBlock, Block footBlock, String regrowthType) {
        if (ve.func_213700_eh().func_221130_b() != VillagerProfession.field_221156_f) {
            return false;
        }
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        if (this.helperCountBlocksOrthogonalBB(Blocks.field_150458_ak, 1, ve.field_70170_p, vePos, 0) > 0) {
            if (groundBlock instanceof GrassBlock) {
                ve.field_70170_p.func_175656_a(vePos.func_177977_b(), Blocks.field_150458_ak.func_176223_P());
                return true;
            }
            if (!regrowthType.contains("t") || footBlock != Blocks.field_150350_a) {
                return false;
            }
            if (ve.field_70170_p.func_226658_a_(LightType.BLOCK, vePos) > 12) {
                return false;
            }
            int veX = vePos.func_177958_n();
            int veY = vePos.func_177956_o();
            int veZ = vePos.func_177952_p();
            if (lastTorchX == veX && lastTorchY == veY && lastTorchZ == veZ) {
                return false;
            }
            boolean placeTorch = false;
            int waterValue = this.helperCountBlocksOrthogonalBB(Blocks.field_150355_j, 1, ve.field_70170_p, vePos.func_177977_b(), 0);
            if (waterValue > 0 && BlockTags.field_200031_h.func_230235_a_((Object)groundBlock) || groundBlock == Blocks.field_196580_bH) {
                ve.field_70170_p.func_180501_a(vePos, Blocks.field_150478_aa.func_176223_P(), 3);
                lastTorchX = veX;
                lastTorchY = veY;
                lastTorchZ = veZ;
                return true;
            }
        }
        return false;
    }

    private void vImproveLeaves(VillagerEntity ve, Block groundBlock, String key, int veX, int veY, int veZ) {
        float veYaw = ve.func_195046_g(1.0f) / 45.0f;
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        facingNdx %= 8;
        if (groundBlock == Blocks.field_185774_da) {
            ++veY;
        }
        int dx = facingArray[facingNdx][0];
        int dz = facingArray[facingNdx][1];
        BlockPos tmpBP = null;
        BlockState tempBS = null;
        Block tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new BlockPos(veX + dx, veY + iY, veZ + dz);
            tempBS = ve.field_70170_p.func_180495_p(tmpBP);
            tempBlock = tempBS.func_177230_c();
            if (tempBlock instanceof LeavesBlock && !(persistantLeaves = ((Boolean)tempBS.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof CactusBlock) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.field_70170_p.func_175655_b(tmpBP, false);
            destroyBlock = false;
            MyConfig.debugMsg(1, vePos, key + " cleared " + tempBlock.func_149739_a().toString());
        }
    }

    private boolean vImproveLighting(VillagerEntity ve, Block footBlock, Block groundBlock, Biome localBiome) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int blockLightValue = ve.field_70170_p.func_226658_a_(LightType.BLOCK, vePos);
        int skyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, vePos);
        if (blockLightValue > 8) {
            return false;
        }
        if (skyLightValue > 13) {
            return false;
        }
        if (ve.func_70608_bn()) {
            return false;
        }
        if (footBlock instanceof BedBlock) {
            return false;
        }
        if (this.isValidGroundBlockToPlaceTorchOn(ve, groundBlock) && footBlock instanceof AirBlock) {
            ve.field_70170_p.func_180501_a(vePos, Blocks.field_150478_aa.func_176223_P(), 3);
        }
        return true;
    }

    private void vImproveRoads(VillagerEntity ve, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        if (this.vImproveRoadsFixUnfinished(ve, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, ve.func_233580_cy_(), key + " fix road.");
        }
        if (this.vImproveRoadsSmoothHeight(ve, footBlock, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, ve.func_233580_cy_(), key + " Smooth road slope.");
        }
    }

    private boolean vImproveRoadsFixUnfinished(VillagerEntity ve, Block groundBlock, Biome localBiome) {
        Block biomeRoadBlock;
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int fixHeight = 3;
        if (Biome.Category.TAIGA == localBiome.func_201856_r()) {
            fixHeight = 5;
        }
        if ((biomeRoadBlock = this.helperBiomeRoadBlockType(localBiome).func_177230_c()).getBlock() == Blocks.field_196580_bH) {
            int skyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, vePos);
            if (skyLightValue < 13) {
                return false;
            }
            if (!ve.func_190670_t_().func_226660_f_(ve.func_233580_cy_())) {
                return false;
            }
        }
        int veX = vePos.func_177958_n();
        int veY = vePos.func_177956_o();
        int veZ = vePos.func_177952_p();
        if (groundBlock != biomeRoadBlock) {
            int roadBlockCount = 0;
            for (int dy = -1; dy <= fixHeight; ++dy) {
                for (int i = 0; i < 4; ++i) {
                    Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).func_177230_c();
                    if (tempBlock != biomeRoadBlock || ++roadBlockCount <= 2) continue;
                    ve.field_70170_p.func_175656_a(vePos.func_177977_b(), biomeRoadBlock.func_176223_P());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean vImproveRoadsSmoothHeight(VillagerEntity ve, Block footBlock, Block groundBlock, Biome localBiome) {
        Collection result;
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int skyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, vePos);
        if (skyLightValue < 14) {
            return false;
        }
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(localBiome).func_177230_c();
        if (groundBlock != biomeRoadBlock && footBlock != biomeRoadBlock) {
            return false;
        }
        BlockState smoothingBlockState = biomeRoadBlock.func_176223_P();
        Block smoothingBlock = biomeRoadBlock;
        int poiDistance = 3;
        String key = "minecraft:" + localBiome.func_201856_r().toString();
        if ((key = key.toLowerCase()).equals("minecraft:desert")) {
            poiDistance = 7;
            if (!ve.func_190670_t_().func_226660_f_(ve.func_233580_cy_())) {
                return false;
            }
        }
        if (!(result = (Collection)((ServerWorld)ve.field_70170_p).func_217443_B().func_226353_b_(t -> true, ve.func_233580_cy_(), poiDistance, PointOfInterestManager.Status.ANY).collect(Collectors.toCollection(ArrayList::new))).isEmpty()) {
            for (PointOfInterest P : result) {
                int disX = Math.abs(ve.func_233580_cy_().func_177958_n() - P.func_218261_f().func_177958_n());
                int disZ = Math.abs(ve.func_233580_cy_().func_177952_p() - P.func_218261_f().func_177952_p());
                if (disX >= poiDistance || disZ >= poiDistance) continue;
                MyConfig.debugMsg(1, vePos, "Point of Interest too Close: " + P.func_218260_g().toString() + ".");
                return false;
            }
        }
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key);
        int yAdjust = 0;
        if (smoothingBlock == Blocks.field_185774_da) {
            yAdjust = 1;
        }
        int veX = vePos.func_177958_n();
        int veY = vePos.func_177956_o();
        int veZ = vePos.func_177952_p();
        for (int dy = 1; dy < 5 + yAdjust; ++dy) {
            for (int i = 0; i < 4; ++i) {
                Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).func_177230_c();
                if (tempBlock != smoothingBlock) continue;
                ve.field_70170_p.func_175656_a(new BlockPos(veX, veY, veZ), smoothingBlockState);
                ve.func_213293_j(0.0, 0.4, 0.0);
                return true;
            }
        }
        return false;
    }

    private boolean vImproveWallForMeetingPlace(VillagerEntity ve, String regrowthActions, BlockPos villageMeetingPlaceBlockPos, Block groundBlock, Block footBlock, Biome localBiome) {
        int absvz;
        int absvx;
        int wallPerimeter;
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        String key = "minecraft:" + localBiome.func_201856_r().toString();
        key = key.toLowerCase();
        MyConfig.debugMsg(2, vePos, key + " wall improvement.");
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key);
        MyConfig.debugMsg(1, vePos, key + " biome for wall improvement.");
        if (currentWallBiomeDataItem == null) {
            MyConfig.debugMsg(2, vePos, "wallbiome data null.");
            key = "minecraft:" + localBiome.func_201856_r().toString().toLowerCase();
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key);
            if (currentWallBiomeDataItem == null) {
                currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
            }
        }
        if ((wallPerimeter = currentWallBiomeDataItem.getWallDiameter()) < 32) {
            wallPerimeter = 32;
        }
        if (wallPerimeter > 80) {
            wallPerimeter = 80;
        }
        if (this.isOnWallPerimeter(wallPerimeter = wallPerimeter / 2 - 1, absvx = (int)Math.abs(ve.func_226277_ct_() - (double)villageMeetingPlaceBlockPos.func_177958_n()), absvz = (int)Math.abs(ve.func_226281_cx_() - (double)villageMeetingPlaceBlockPos.func_177952_p()))) {
            MyConfig.debugMsg(2, ve.func_233580_cy_(), "villager on wall perimeter: " + wallPerimeter);
            Collection result = ((ServerWorld)ve.field_70170_p).func_217443_B().func_226353_b_(t -> t == PointOfInterestType.field_221070_r, ve.func_233580_cy_(), 41, PointOfInterestManager.Status.ANY).collect(Collectors.toCollection(ArrayList::new));
            boolean buildWall = true;
            if (!result.isEmpty()) {
                for (PointOfInterest P : result) {
                    if (villageMeetingPlaceBlockPos.func_177958_n() == P.func_218261_f().func_177958_n() && villageMeetingPlaceBlockPos.func_177956_o() == P.func_218261_f().func_177956_o() && villageMeetingPlaceBlockPos.func_177952_p() == P.func_218261_f().func_177952_p()) continue;
                    int disX = Math.abs(ve.func_233580_cy_().func_177958_n() - P.func_218261_f().func_177958_n());
                    int disZ = Math.abs(ve.func_233580_cy_().func_177952_p() - P.func_218261_f().func_177952_p());
                    if (disX >= wallPerimeter || disZ >= wallPerimeter) continue;
                    buildWall = false;
                    break;
                }
            }
            if (buildWall) {
                boolean buildCenterGate;
                BlockState wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState();
                if (wallTypeBlockState == null) {
                    wallTypeBlockState = Blocks.field_150463_bK.func_176223_P();
                }
                BlockState wallBlock = wallTypeBlockState;
                int wallTorchSpacing = (wallPerimeter + 1) / 4;
                BlockState gateBlockType = this.helperBiomeRoadBlockType(localBiome);
                if (this.helperPlaceOneWallPiece(ve, regrowthActions, wallPerimeter, wallTorchSpacing, gateBlockType, buildCenterGate = true, wallBlock, absvx, absvz, groundBlock, footBlock)) {
                    if (regrowthActions.contains("t") && this.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, ve.field_70170_p.func_180495_p(vePos).func_177230_c())) {
                        ve.field_70170_p.func_175656_a(vePos.func_177984_a(), Blocks.field_150478_aa.func_176223_P());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean vImproveHomeFence(VillagerEntity ve, BlockPos vHomePos, String regrowthActions, Block groundBlock, Block footBlock, Biome localBiome) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        String key = "minecraft:" + localBiome.func_201856_r().toString();
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key = key.toLowerCase());
        if (currentWallBiomeDataItem == null && (currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key = "minecraft:" + localBiome.func_201856_r().toString().toLowerCase())) == null) {
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
        }
        int homeFenceDiameter = currentWallBiomeDataItem.getWallDiameter();
        if ((homeFenceDiameter /= 4) < 7) {
            homeFenceDiameter = 7;
        }
        if (homeFenceDiameter > 16) {
            homeFenceDiameter = 16;
        }
        int wallTorchSpacing = homeFenceDiameter / 4;
        homeFenceDiameter = homeFenceDiameter / 2 - 1;
        int absvx = (int)Math.abs(ve.func_226277_ct_() - (double)vHomePos.func_177958_n());
        int absvz = (int)Math.abs(ve.func_226281_cx_() - (double)vHomePos.func_177952_p());
        Collection result = ((ServerWorld)ve.field_70170_p).func_217443_B().func_226353_b_(t -> t == PointOfInterestType.field_221069_q, vePos, 17, PointOfInterestManager.Status.ANY).collect(Collectors.toCollection(ArrayList::new));
        boolean buildWall = true;
        if (!result.isEmpty()) {
            for (PointOfInterest P : result) {
                if (vHomePos.func_177958_n() == P.func_218261_f().func_177958_n() && vHomePos.func_177956_o() == P.func_218261_f().func_177956_o() && vHomePos.func_177952_p() == P.func_218261_f().func_177952_p()) continue;
                int disX = Math.abs(vePos.func_177958_n() - P.func_218261_f().func_177958_n());
                int disZ = Math.abs(vePos.func_177952_p() - P.func_218261_f().func_177952_p());
                MyConfig.debugMsg(1, P.func_218261_f(), "extra Point of Interest Found.");
                if (disX >= homeFenceDiameter || disZ >= homeFenceDiameter) continue;
                buildWall = false;
                break;
            }
        } else if (result.isEmpty()) {
            buildWall = true;
        }
        if (buildWall) {
            boolean buildCenterGate;
            BlockState fenceBlockState = currentWallBiomeDataItem.getFenceBlockState();
            if (fenceBlockState == null) {
                fenceBlockState = Blocks.field_180407_aO.func_176223_P();
            }
            BlockState wallBlock = fenceBlockState;
            BlockState gateBlockType = this.helperBiomeRoadBlockType(localBiome);
            if (this.helperPlaceOneWallPiece(ve, regrowthActions, homeFenceDiameter, wallTorchSpacing, gateBlockType, buildCenterGate = true, wallBlock, absvx, absvz, groundBlock, footBlock)) {
                if (regrowthActions.contains("t") && this.isValidTorchLocation(homeFenceDiameter, wallTorchSpacing, absvx, absvz, ve.field_70170_p.func_180495_p(vePos).func_177230_c())) {
                    ve.field_70170_p.func_175656_a(vePos.func_177984_a(), Blocks.field_150478_aa.func_176223_P());
                }
                return true;
            }
        }
        return false;
    }

    private void vImproveWalls(VillagerEntity ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        Brain vb = ve.func_213375_cj();
        Optional vMeetingPlace = vb.func_218207_c(MemoryModuleType.field_220943_d);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (this.isOkayToBuildWallHere(ve, footBlock, groundBlock)) {
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos gVMPPos = gVMP.func_218180_b();
            long chunkAge = ve.field_70170_p.func_175726_f(gVMPPos).func_177416_w();
            if (chunkAge < 1200L) {
                ve.field_70170_p.func_180501_a(gVMPPos.func_177981_b(1), Blocks.field_150463_bK.func_176223_P(), 3);
            }
            if (!(ve.field_70170_p.func_180495_p(gVMPPos.func_177981_b(1)).func_177230_c() instanceof WallBlock)) {
                return;
            }
            if (regrowthType.contains("w")) {
                MyConfig.debugMsg(1, vePos, "Checking Improve Wall.");
                if (this.vImproveWallForMeetingPlace(ve, regrowthType, gVMPPos, groundBlock, footBlock, localBiome)) {
                    MyConfig.debugMsg(1, vePos, "Meeting Wall Improved.");
                }
            }
        }
    }

    private void vImproveFences(VillagerEntity ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        BlockPos ePos = ve.func_233580_cy_();
        Brain vb = ve.func_213375_cj();
        Optional vMeetingPlace = vb.func_218207_c(MemoryModuleType.field_220943_d);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (this.isOkayToBuildWallHere(ve, footBlock, groundBlock)) {
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos villageMeetingPlaceBlockPos = gVMP.func_218180_b();
            if (!(ve.field_70170_p.func_180495_p(villageMeetingPlaceBlockPos.func_177981_b(1)).func_177230_c() instanceof WallBlock)) {
                return;
            }
            if (regrowthType.contains("p")) {
                MyConfig.debugMsg(1, ePos, "Checking Improve Fence.");
                Optional villagerHome = vb.func_218207_c(MemoryModuleType.field_220941_b);
                if (!villagerHome.isPresent()) {
                    return;
                }
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.func_218180_b();
                if (this.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((GlobalPos)vMeetingPlace.get()).func_218180_b(), localBiome)) {
                    MyConfig.debugMsg(1, ePos, "Outside meeting place wall.");
                    if (this.vImproveHomeFence(ve, villagerHomePos, regrowthType, groundBlock, footBlock, localBiome)) {
                        MyConfig.debugMsg(1, ePos, "Home Fence Improved.");
                    }
                }
            }
        }
    }

    private boolean isFootBlockOkayToBuildIn(Block footBlock) {
        return footBlock instanceof AirBlock || this.isGrassOrFlower(footBlock);
    }

    private boolean isGrassOrFlower(Block footBlock) {
        block11: {
            if (footBlock instanceof TallGrassBlock) {
                return true;
            }
            if (footBlock instanceof FlowerBlock) {
                return true;
            }
            if (footBlock instanceof DoublePlantBlock) {
                return true;
            }
            if (footBlock == Blocks.field_196554_aH) {
                return true;
            }
            if (footBlock == Blocks.field_196805_gi) {
                return true;
            }
            try {
                if (BlockTags.field_226149_I_.func_230235_a_((Object)footBlock)) {
                    return true;
                }
                if (BlockTags.field_226148_H_.func_230235_a_((Object)footBlock)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (MyConfig.aDebugLevel <= 0) break block11;
                System.out.println("Tag Exception 1009-1014:" + footBlock.func_149739_a() + ".");
            }
        }
        if (footBlock.func_149739_a() == "block.byg.short_grass") {
            return true;
        }
        if (MyConfig.aDebugLevel > 0) {
            System.out.println("Not grass or Flower:" + footBlock.func_149739_a() + ".");
        }
        return false;
    }

    private boolean isImpossibleRegrowthEvent(Block footBlock, String regrowthType) {
        if (regrowthType.equals("eat") && footBlock instanceof AirBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof TallGrassBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof FlowerBlock) {
            return true;
        }
        return regrowthType.equals("tall") && !(footBlock instanceof TallGrassBlock);
    }

    private boolean isOkayToBuildWallHere(VillagerEntity ve, Block footBlock, Block groundBlock) {
        BlockPos ePos = ve.func_233580_cy_();
        boolean okayToBuildWalls = true;
        if (!this.isOnGround((Entity)ve)) {
            okayToBuildWalls = false;
        }
        if (!this.isFootBlockOkayToBuildIn(footBlock)) {
            okayToBuildWalls = false;
        }
        if (!this.isValidGroundBlockToBuildWallOn(ve, groundBlock)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private boolean isOnGround(Entity e) {
        return e.func_233570_aj_();
    }

    private boolean isOnWallPerimeter(int wallPerimeter, int absvx, int absvz) {
        boolean scratch = false;
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            scratch = true;
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            scratch = true;
        }
        return scratch;
    }

    private boolean isOutsideMeetingPlaceWall(VillagerEntity ve, Optional<GlobalPos> vMeetingPlace, BlockPos meetingPlacePos, Biome localBiome) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        String key = "minecraft:" + localBiome.func_201856_r().toString();
        int wallDiameter = 64;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key = key.toLowerCase());
        if (currentWallBiomeDataItem != null) {
            wallDiameter = currentWallBiomeDataItem.getWallDiameter();
        }
        wallDiameter = wallDiameter / 2 - 1;
        int absVMpX = Math.abs(vePos.func_177958_n() - meetingPlacePos.func_177958_n());
        int absVMpZ = Math.abs(vePos.func_177952_p() - meetingPlacePos.func_177952_p());
        if (absVMpX > wallDiameter + 1) {
            return true;
        }
        return absVMpZ > wallDiameter + 1;
    }

    private boolean isValidGroundBlockToPlaceTorchOn(VillagerEntity ve, Block groundBlock) {
        String key = groundBlock.getRegistryName().toString();
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidGroundBlockToBuildWallOn(VillagerEntity ve, Block groundBlock) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int blockSkyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, vePos);
        if (blockSkyLightValue < 13) {
            return false;
        }
        String key = groundBlock.getRegistryName().toString();
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidTorchLocation(int wallPerimeter, int wallTorchSpacing, int absvx, int absvz, Block wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof WallBlock) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof FenceBlock) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallPerimeter && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallPerimeter) {
            return true;
        }
        return absvx == wallPerimeter && absvz == wallPerimeter;
    }

    private boolean helperPlaceOneWallPiece(VillagerEntity ve, String regrowthType, int wallPerimeter, int wallTorchSpacing, BlockState gateBlockType, boolean buildCenterGate, BlockState wallType, int absvx, int absvz, Block groundBlock, Block footBlock) {
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            return this.helperPlaceWallPiece(ve, gateBlockType, buildCenterGate, wallType, absvz);
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            return this.helperPlaceWallPiece(ve, gateBlockType, buildCenterGate, wallType, absvx);
        }
        return false;
    }

    private boolean helperPlaceWallPiece(VillagerEntity ve, BlockState gateBlockType, boolean buildCenterGate, BlockState wallType, int absva) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        if (absva == 0) {
            if (buildCenterGate) {
                ve.field_70170_p.func_175656_a(vePos.func_177977_b(), gateBlockType);
                return true;
            }
            return false;
        }
        BlockState b = ve.field_70170_p.func_180495_p(vePos.func_177977_b());
        Block block = b.func_177230_c();
        if (block instanceof AirBlock || block instanceof TallGrassBlock || block instanceof FlowerBlock || block instanceof DoublePlantBlock) {
            ve.field_70170_p.func_175656_a(vePos.func_177977_b(), wallType);
        } else {
            ve.field_70170_p.func_175656_a(vePos, wallType);
        }
        return true;
    }
}

