/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.ropebridge.handler;

import com.mcmoddev.ropebridge.block.RopeBridgeBlock;
import com.mcmoddev.ropebridge.handler.ConfigHandler;
import com.mcmoddev.ropebridge.handler.ContentHandler;
import com.mcmoddev.ropebridge.handler.LadderBuildingHandler;
import com.mcmoddev.ropebridge.handler.SlabPosHandler;
import com.mcmoddev.ropebridge.lib.ModUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BridgeBuildingHandler {
    private BridgeBuildingHandler() {
    }

    public static void newBridge(PlayerEntity player, ItemStack stack, BlockPos pos1, BlockPos pos2) {
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        LinkedList<SlabPosHandler> bridge = new LinkedList<SlabPosHandler>();
        boolean allClear = true;
        boolean rotate = BridgeBuildingHandler.getRotate(pos1, pos2);
        if (!rotate) {
            x1 = pos1.func_177958_n();
            y1 = pos1.func_177956_o();
            z1 = pos1.func_177952_p();
            x2 = pos2.func_177958_n();
            y2 = pos2.func_177956_o();
            z2 = pos2.func_177952_p();
        } else {
            x1 = pos1.func_177952_p();
            y1 = pos1.func_177956_o();
            z1 = pos1.func_177958_n();
            x2 = pos2.func_177952_p();
            y2 = pos2.func_177956_o();
            z2 = pos2.func_177958_n();
        }
        if (Math.abs(z2 - z1) > 3) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.notcardinal", new Object[0]);
            return;
        }
        double m = (double)(y2 - y1) / (double)(x2 - x1);
        if (!ConfigHandler.isIgnoreSlopeWarnings() && Math.abs(m) > 0.2) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.greatslope", new Object[0]);
            return;
        }
        double b = (double)y1 - m * (double)x1;
        double distance = Math.abs(x2 - x1);
        int distInt = Math.abs(x2 - x1);
        if (distInt < 2) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d && !BridgeBuildingHandler.hasMaterials(player, distInt - 1)) {
            return;
        }
        for (int x = Math.min(x1, x2) + 1; x <= Math.max(x1, x2) - 1; ++x) {
            for (int y = Math.max(y1, y2); y >= Math.min(y1, y2) - distInt / 8 - 1; --y) {
                double funcVal = m * (double)x + b - distance / 1000.0 * Math.sin((double)(x - Math.min(x1, x2)) * (Math.PI / distance)) * (double)ConfigHandler.getBridgeDroopFactor() + ConfigHandler.getBridgeYOffset();
                if (!((double)y + 0.5 > funcVal) || !((double)y - 0.5 <= funcVal)) continue;
                int level = funcVal >= (double)y ? (funcVal >= (double)y + 0.25 ? 3 : 2) : (funcVal >= (double)y - 0.25 ? 1 : 0);
                allClear = BridgeBuildingHandler.addSlab(player.field_70170_p, bridge, x, y + 1, z1, level, rotate) && allClear;
            }
        }
        if (allClear) {
            Block slab = BridgeBuildingHandler.getSlabs(player);
            if (slab != null && !player.field_71075_bZ.field_75098_d) {
                BridgeBuildingHandler.takeMaterials(player, distInt - 1);
                stack.func_222118_a(ConfigHandler.getBridgeDamage(), (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
            }
            BridgeBuildingHandler.buildBridge(player.field_70170_p, bridge, slab, 0, rotate);
        } else {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.obstruction", new Object[0]);
        }
    }

    private static boolean getRotate(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.func_177958_n() - p2.func_177958_n()) <= Math.abs(p1.func_177952_p() - p2.func_177952_p());
    }

    private static boolean hasMaterials(PlayerEntity player, int dist) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getSlabsPerBridge() == 0 && ConfigHandler.getRopePerBridge() == 0;
        if (player.field_71075_bZ.field_75098_d || noCost) {
            return true;
        }
        int ropeNeeded = dist * ConfigHandler.getRopePerBridge();
        int slabsNeeded = dist * ConfigHandler.getSlabsPerBridge();
        int slabsHad = 0;
        int ropeHad = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (item == ContentHandler.rope) {
                ropeHad += stack.func_190916_E();
            }
            if (!item.func_206844_a(ItemTags.field_202899_i)) continue;
            slabsHad += stack.func_190916_E();
        }
        if (slabsHad >= slabsNeeded && ropeHad >= ropeNeeded) {
            return true;
        }
        ModUtils.tellPlayer(player, "chat.ropebridge.info.underfunded_bridge", dist, ropeNeeded);
        return false;
    }

    private static void takeMaterials(PlayerEntity player, int dist) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getSlabsPerBridge() == 0 && ConfigHandler.getRopePerBridge() == 0;
        if (player.field_71075_bZ.field_75098_d || noCost) {
            return;
        }
        int slabsNeeded = dist * ConfigHandler.getSlabsPerBridge();
        int ropeNeeded = dist * ConfigHandler.getRopePerBridge();
        for (int i = 0; i < 36; ++i) {
            int toConsume;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (ropeNeeded > 0 && item == ContentHandler.rope) {
                toConsume = Math.min(stack.func_190916_E(), ropeNeeded);
                ropeNeeded -= toConsume;
                stack.func_190918_g(toConsume);
                continue;
            }
            if (slabsNeeded <= 0 || !item.func_206844_a(ItemTags.field_202899_i)) continue;
            toConsume = Math.min(stack.func_190916_E(), slabsNeeded);
            slabsNeeded -= toConsume;
            stack.func_190918_g(toConsume);
        }
    }

    private static boolean addSlab(World world, LinkedList<SlabPosHandler> list, int x, int y, int z, int level, boolean rotate) {
        BlockPos pos = rotate ? new BlockPos(z, y, x) : new BlockPos(x, y, z);
        boolean isClear = ConfigHandler.isBreakThroughBlocks() || world.func_175623_d(pos) || LadderBuildingHandler.isReplaceable(world, pos, world.func_180495_p(pos));
        list.add(new SlabPosHandler(pos, level, rotate));
        if (!isClear) {
            BridgeBuildingHandler.spawnSmoke(world, pos, 15);
        }
        return isClear;
    }

    private static void spawnSmoke(World world, BlockPos pos, int times) {
        if (times > 0) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197627_t, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            final World finworld = world;
            final BlockPos finPos = pos;
            final int finTimes = times - 1;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.spawnSmoke(finworld, finPos, finTimes);
                }
            }, 1000L);
        }
    }

    private static void buildBridge(final World world, final List<SlabPosHandler> bridge, final Block slabBlock, final int index, final boolean rotated) {
        if (index < bridge.size()) {
            SlabPosHandler slab = bridge.get(index);
            int backLevel = index > 0 ? bridge.get(index - 1).getLevel() : 0;
            BlockState state = (BlockState)((BlockState)((BlockState)((Block)ModUtils.map.get(slabBlock).getLeft()).func_176223_P().func_206870_a((IProperty)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(slab.getLevel()))).func_206870_a((IProperty)RopeBridgeBlock.PROPERTY_BACK, (Comparable)Integer.valueOf(backLevel))).func_206870_a((IProperty)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(rotated));
            world.func_175656_a(slab.getBlockPos(), state);
            BridgeBuildingHandler.spawnSmoke(world, new BlockPos(slab.getBlockPos().func_177958_n(), slab.getBlockPos().func_177956_o(), slab.getBlockPos().func_177952_p()), 1);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.buildBridge(world, bridge, slabBlock, index + 1, rotated);
                }
            }, 100L);
        }
    }

    private static Block getSlabs(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(ItemTags.field_202899_i)) continue;
            return Block.func_149634_a((Item)stack.func_77973_b());
        }
        return Blocks.field_196622_bq;
    }
}

