/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.ropebridge.handler;

import com.mcmoddev.ropebridge.handler.ConfigHandler;
import com.mcmoddev.ropebridge.handler.ContentHandler;
import com.mcmoddev.ropebridge.lib.BlockItemUseContextExt;
import com.mcmoddev.ropebridge.lib.ModUtils;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LadderBuildingHandler {
    public static void newLadder(BlockPos selected, PlayerEntity player, World world, Direction hitSide, ItemStack builder) {
        if (!hitSide.func_176740_k().func_176722_c()) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.bad_side", hitSide == Direction.UP ? I18n.func_135052_a((String)"chat.ropebridge.params.top", (Object[])new Object[0]) : I18n.func_135052_a((String)"chat.ropebridge.params.bottom", (Object[])new Object[0]));
            return;
        }
        BlockState ladderState = (BlockState)ContentHandler.oak_rope_ladder.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)hitSide);
        if (!ladderState.func_196955_c((IWorldReader)world, selected)) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.not_solid", new Object[0]);
            return;
        }
        int count = LadderBuildingHandler.countBlocks(selected.func_177972_a(hitSide), world);
        if (count <= 0) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.obstruction", new Object[0]);
            return;
        }
        int woodNeeded = count * ConfigHandler.getWoodPerLadder();
        int ropeNeeded = count * ConfigHandler.getRopePerLadder();
        Block slabToUse = LadderBuildingHandler.getSlabToUse(player);
        if (!player.field_71075_bZ.field_75098_d && !LadderBuildingHandler.hasMaterials(player, woodNeeded, ropeNeeded, slabToUse)) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.underfunded_ladder", woodNeeded, ropeNeeded);
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            builder.func_222118_a(ConfigHandler.getLadderDamage(), (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
        }
        LadderBuildingHandler.consume(player, woodNeeded, ropeNeeded, slabToUse);
        LadderBuildingHandler.build(world, selected.func_177972_a(hitSide), count, hitSide, slabToUse);
    }

    public static int countBlocks(BlockPos start, World world) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_189533_g((Vector3i)start);
        int count = 0;
        BlockState state = world.func_180495_p(start);
        while (LadderBuildingHandler.isReplaceable(world, start, state)) {
            ++count;
            start = start.func_177977_b();
            state = world.func_180495_p(start);
        }
        return count;
    }

    public static boolean isReplaceable(World world, BlockPos pos, BlockState state) {
        BlockItemUseContextExt blockItemUseContext = new BlockItemUseContextExt(world, null, Hand.MAIN_HAND, ItemStack.field_190927_a, new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n() + 0.5 + (double)Direction.DOWN.func_82601_c() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)Direction.DOWN.func_96559_d() * 0.5, (double)pos.func_177952_p() + 0.5 + (double)Direction.DOWN.func_82599_e() * 0.5), Direction.DOWN, pos, false));
        return pos.func_177956_o() > 0 && state.func_196953_a((BlockItemUseContext)blockItemUseContext);
    }

    private static void build(World world, BlockPos start, int count, Direction facing, Block type) {
        LadderBuildingHandler.build(world, start, count, 0, facing, type);
    }

    private static void build(final World world, final BlockPos start, final int count, final int iterations, final Direction facing, final Block slabToUse) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            BlockState state = (BlockState)((Block)ModUtils.map.get(slabToUse).getRight()).func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)facing);
            world.func_175656_a(start.func_177979_c(iterations), state);
        });
        if (iterations + 1 < count) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    LadderBuildingHandler.build(world, start, count, iterations + 1, facing, slabToUse);
                }
            }, 100L);
        }
    }

    private static void consume(PlayerEntity player, int woodNeeded, int ropeNeeded, Block woodType) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getRopePerLadder() == 0 && ConfigHandler.getWoodPerLadder() == 0;
        if (player.field_71075_bZ.field_75098_d || noCost) {
            return;
        }
        player.field_71071_by.func_234564_a_(stack -> stack.func_77973_b() == ContentHandler.rope, ropeNeeded, (IInventory)player.field_71069_bz.func_234641_j_());
        player.field_71071_by.func_234564_a_(stack -> stack.func_77973_b() == woodType.func_199767_j(), woodNeeded, (IInventory)player.field_71069_bz.func_234641_j_());
    }

    private static Block getSlabToUse(PlayerEntity player) {
        return player.field_71071_by.field_70462_a.stream().filter(stack -> stack.func_77973_b().func_206844_a((ITag)ItemTags.field_202899_i)).findFirst().map(stack -> Block.func_149634_a((Item)stack.func_77973_b())).orElse(Blocks.field_196622_bq);
    }

    private static boolean hasMaterials(PlayerEntity player, int woodNeeded, int ropeNeeded, Block toFind) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getRopePerLadder() == 0 && ConfigHandler.getWoodPerLadder() == 0;
        if (noCost || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack i : player.field_71071_by.field_70462_a) {
            if (i.func_190926_b()) continue;
            Item item = i.func_77973_b();
            if (item == ContentHandler.rope) {
                ropeNeeded -= i.func_190916_E();
                continue;
            }
            if (item != toFind.func_199767_j()) continue;
            woodNeeded -= i.func_190916_E();
        }
        return woodNeeded <= 0 && ropeNeeded <= 0;
    }
}

