/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.block;

import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeBridgeBlock
extends Block {
    private final Supplier<Block> slabSupplier;
    public static final IntegerProperty PROPERTY_HEIGHT = IntegerProperty.create((String)"level", (int)0, (int)3);
    public static final IntegerProperty PROPERTY_BACK = IntegerProperty.create((String)"back", (int)0, (int)3);
    public static final BooleanProperty ROTATED = BooleanProperty.create((String)"rotated");
    public static final VoxelShape ZERO_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape ONE_AABB = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape TWO_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape THREE_AABB = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public RopeBridgeBlock(BlockBehaviour.Properties properties, Supplier<Block> slabSupplier) {
        super(properties);
        this.slabSupplier = slabSupplier;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PROPERTY_HEIGHT, PROPERTY_BACK, ROTATED});
    }

    public Block getSlab() {
        return this.slabSupplier.get();
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        int level = (Integer)state.getValue((Property)PROPERTY_HEIGHT);
        return switch (level) {
            case 1 -> ONE_AABB;
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            default -> ZERO_AABB;
        };
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState destroyState = super.playerWillDestroy(level, pos, state, player);
        if (!level.isClientSide && player.getMainHandItem().is((Item)ContentHandler.bridge_builder.get()) && player.isCrouching()) {
            ModUtils.tellPlayer(player, "chat.ropebridge.warning.breaking", new Object[0]);
            boolean rotate = (Boolean)level.getBlockState(pos).getValue((Property)ROTATED);
            if (rotate) {
                this.breakNorth(pos, (ServerLevel)level);
                this.breakSouth(pos, (ServerLevel)level);
            } else {
                this.breakEast(pos, (ServerLevel)level);
                this.breakWest(pos, (ServerLevel)level);
            }
        }
        return destroyState;
    }

    public void breakSouth(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos south = posToBreak.south();
        final BlockPos up = south.above();
        final BlockPos down = south.below();
        BlockState stateDown = world.getBlockState(down);
        BlockState stateUp = world.getBlockState(up);
        BlockState state = world.getBlockState(south);
        if (state.getBlock() == this) {
            world.destroyBlock(south, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(south, world);
                }
            }, 100L);
        }
        if (stateUp.getBlock() == this) {
            world.destroyBlock(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(up, world);
                }
            }, 100L);
        }
        if (stateDown.getBlock() == this) {
            world.destroyBlock(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(down, world);
                }
            }, 100L);
        }
    }

    public void breakNorth(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos north = posToBreak.north();
        final BlockPos up = north.above();
        final BlockPos down = north.below();
        BlockState stateDown = world.getBlockState(down);
        BlockState stateUp = world.getBlockState(up);
        BlockState state = world.getBlockState(north);
        if (state.getBlock() == this) {
            world.destroyBlock(north, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(north, world);
                }
            }, 100L);
        }
        if (stateUp.getBlock() == this) {
            world.destroyBlock(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(up, world);
                }
            }, 100L);
        }
        if (stateDown.getBlock() == this) {
            world.destroyBlock(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(down, world);
                }
            }, 100L);
        }
    }

    public void breakEast(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos east = posToBreak.east();
        final BlockPos up = east.above();
        final BlockPos down = east.below();
        BlockState stateDown = world.getBlockState(down);
        BlockState stateUp = world.getBlockState(up);
        BlockState state = world.getBlockState(east);
        if (state.getBlock() == this) {
            world.destroyBlock(east, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(east, world);
                }
            }, 100L);
        }
        if (stateUp.getBlock() == this) {
            world.destroyBlock(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(up, world);
                }
            }, 100L);
        }
        if (stateDown.getBlock() == this) {
            world.destroyBlock(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(down, world);
                }
            }, 100L);
        }
    }

    public void breakWest(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos west = posToBreak.west();
        final BlockPos up = west.above();
        final BlockPos down = west.below();
        BlockState stateDown = world.getBlockState(down);
        BlockState stateUp = world.getBlockState(up);
        BlockState state = world.getBlockState(west);
        if (state.getBlock() == this) {
            world.destroyBlock(west, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(west, world);
                }
            }, 100L);
        }
        if (stateUp.getBlock() == this) {
            world.destroyBlock(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(up, world);
                }
            }, 100L);
        }
        if (stateDown.getBlock() == this) {
            world.destroyBlock(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(down, world);
                }
            }, 100L);
        }
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)ContentHandler.rope.get(), ConfigHandler.getRopePerBridge()));
        drops.add(new ItemStack((ItemLike)this.getSlab(), ConfigHandler.getSlabsPerBridge()));
        return drops;
    }
}

