/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.block;

import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;

public class RopeLadderBlock
extends LadderBlock {
    private final Supplier<Block> slabSupplier;

    public RopeLadderBlock(BlockBehaviour.Properties properties, Supplier<Block> slabSupplier) {
        super(properties);
        this.slabSupplier = slabSupplier;
    }

    public Block getSlab() {
        return this.slabSupplier.get();
    }

    protected BlockState updateShape(BlockState state, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        Level level;
        if (!this.canSurvive(state, levelReader, pos) && levelReader instanceof Level && !(level = (Level)levelReader).getBlockState(pos.above()).is((Block)this)) {
            RopeLadderBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
        return super.updateShape(state, levelReader, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)ContentHandler.rope.get(), ConfigHandler.getRopePerLadder()));
        drops.add(new ItemStack((ItemLike)this.getSlab(), ConfigHandler.getWoodPerLadder()));
        return drops;
    }
}

