/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.handler.LadderBuildingHandler;
import com.mrtrollnugnug.ropebridge.handler.SlabPosHandler;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BridgeBuildingHandler {
    private BridgeBuildingHandler() {
    }

    public static void newBridge(Player player, ItemStack stack, BlockPos pos1, BlockPos pos2) {
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        LinkedList<SlabPosHandler> bridge = new LinkedList<SlabPosHandler>();
        boolean allClear = true;
        boolean rotate = BridgeBuildingHandler.getRotate(pos1, pos2);
        if (!rotate) {
            x1 = pos1.getX();
            y1 = pos1.getY();
            z1 = pos1.getZ();
            x2 = pos2.getX();
            y2 = pos2.getY();
            z2 = pos2.getZ();
        } else {
            x1 = pos1.getZ();
            y1 = pos1.getY();
            z1 = pos1.getX();
            x2 = pos2.getZ();
            y2 = pos2.getY();
            z2 = pos2.getX();
        }
        if (Math.abs(z2 - z1) > 3) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.notcardinal", new Object[0]);
            return;
        }
        double m = (double)(y2 - y1) / (double)(x2 - x1);
        if (!ConfigHandler.isIgnoreSlopeWarnings() && Math.abs(m) > 0.2) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.greatslope", new Object[0]);
            return;
        }
        double b = (double)y1 - m * (double)x1;
        double distance = Math.abs(x2 - x1);
        int distInt = Math.abs(x2 - x1);
        if (distInt < 2) {
            return;
        }
        if (!player.getAbilities().instabuild && !BridgeBuildingHandler.hasMaterials(player, distInt - 1)) {
            return;
        }
        for (int x = Math.min(x1, x2) + 1; x <= Math.max(x1, x2) - 1; ++x) {
            for (int y = Math.max(y1, y2); y >= Math.min(y1, y2) - distInt / 8 - 1; --y) {
                double funcVal = m * (double)x + b - distance / 1000.0 * Math.sin((double)(x - Math.min(x1, x2)) * (Math.PI / distance)) * (double)ConfigHandler.getBridgeDroopFactor() + ConfigHandler.getBridgeYOffset();
                if (!((double)y + 0.5 > funcVal) || !((double)y - 0.5 <= funcVal)) continue;
                int level = funcVal >= (double)y ? (funcVal >= (double)y + 0.25 ? 3 : 2) : (funcVal >= (double)y - 0.25 ? 1 : 0);
                allClear = BridgeBuildingHandler.addSlab(player.level(), bridge, x, y + 1, z1, level, rotate) && allClear;
            }
        }
        if (allClear) {
            Block slab = BridgeBuildingHandler.getSlabs(player);
            if (slab != null && !player.getAbilities().instabuild) {
                BridgeBuildingHandler.takeMaterials(player, distInt - 1);
                stack.hurtAndBreak(ConfigHandler.getBridgeDamage(), (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
            BridgeBuildingHandler.buildBridge(player.level(), bridge, slab, 0, rotate);
            ModUtils.unlockAdvancement(player, Constants.BUILD_BRIDGE_ADVANCEMENT);
        } else {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.obstruction", new Object[0]);
        }
    }

    private static boolean getRotate(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.getX() - p2.getX()) <= Math.abs(p1.getZ() - p2.getZ());
    }

    private static boolean hasMaterials(Player player, int dist) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getSlabsPerBridge() == 0 && ConfigHandler.getRopePerBridge() == 0;
        if (player.getAbilities().instabuild || noCost) {
            return true;
        }
        int ropeNeeded = dist * ConfigHandler.getRopePerBridge();
        int slabsNeeded = dist * ConfigHandler.getSlabsPerBridge();
        int slabsHad = 0;
        int ropeHad = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = (ItemStack)player.getInventory().items.get(i);
            if (stack.isEmpty()) continue;
            if (stack.is((Item)ContentHandler.rope.get())) {
                ropeHad += stack.getCount();
            }
            if (!stack.is(ItemTags.WOODEN_SLABS)) continue;
            slabsHad += stack.getCount();
        }
        if (slabsHad >= slabsNeeded && ropeHad >= ropeNeeded) {
            return true;
        }
        ModUtils.tellPlayer(player, "chat.ropebridge.info.underfunded_bridge", dist, ropeNeeded);
        return false;
    }

    private static void takeMaterials(Player player, int dist) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getSlabsPerBridge() == 0 && ConfigHandler.getRopePerBridge() == 0;
        if (player.getAbilities().instabuild || noCost) {
            return;
        }
        int slabsNeeded = dist * ConfigHandler.getSlabsPerBridge();
        int ropeNeeded = dist * ConfigHandler.getRopePerBridge();
        for (int i = 0; i < 36; ++i) {
            int toConsume;
            ItemStack stack = (ItemStack)player.getInventory().items.get(i);
            if (stack.isEmpty()) continue;
            if (ropeNeeded > 0 && stack.is((Item)ContentHandler.rope.get())) {
                toConsume = Math.min(stack.getCount(), ropeNeeded);
                ropeNeeded -= toConsume;
                stack.shrink(toConsume);
                continue;
            }
            if (slabsNeeded <= 0 || !stack.is(ItemTags.WOODEN_SLABS)) continue;
            toConsume = Math.min(stack.getCount(), slabsNeeded);
            slabsNeeded -= toConsume;
            stack.shrink(toConsume);
        }
    }

    private static boolean addSlab(Level blockGetter, LinkedList<SlabPosHandler> list, int x, int y, int z, int level, boolean rotate) {
        BlockPos pos = rotate ? new BlockPos(z, y, x) : new BlockPos(x, y, z);
        boolean isClear = ConfigHandler.isBreakThroughBlocks() || blockGetter.isEmptyBlock(pos) || LadderBuildingHandler.isReplaceable(blockGetter, pos, blockGetter.getBlockState(pos));
        list.add(new SlabPosHandler(pos, level, rotate));
        if (!isClear) {
            BridgeBuildingHandler.spawnSmoke(blockGetter, pos, 15);
        }
        return isClear;
    }

    private static void spawnSmoke(Level level, BlockPos pos, int times) {
        if (times > 0) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            final Level finLevel = level;
            final BlockPos finPos = pos;
            final int finTimes = times - 1;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.spawnSmoke(finLevel, finPos, finTimes);
                }
            }, 1000L);
        }
    }

    private static void buildBridge(final Level level, final List<SlabPosHandler> bridge, final Block slabBlock, final int index, final boolean rotated) {
        if (index < bridge.size()) {
            SlabPosHandler slab = bridge.get(index);
            int backLevel = index > 0 ? bridge.get(index - 1).getLevel() : 0;
            BlockState state = (BlockState)((BlockState)((BlockState)((Block)((DeferredBlock)ModUtils.map.get(slabBlock).getLeft()).get()).defaultBlockState().setValue((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(slab.getLevel()))).setValue((Property)RopeBridgeBlock.PROPERTY_BACK, (Comparable)Integer.valueOf(backLevel))).setValue((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(rotated));
            level.setBlockAndUpdate(slab.getBlockPos(), state);
            BridgeBuildingHandler.spawnSmoke(level, new BlockPos(slab.getBlockPos().getX(), slab.getBlockPos().getY(), slab.getBlockPos().getZ()), 1);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.buildBridge(level, bridge, slabBlock, index + 1, rotated);
                }
            }, 100L);
        }
    }

    private static Block getSlabs(Player player) {
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !stack.is(ItemTags.WOODEN_SLABS)) continue;
            return Block.byItem((Item)stack.getItem());
        }
        return Blocks.OAK_SLAB;
    }
}

