/*
 * Decompiled with CFR 0.152.
 */
package net.rpgbackpacks.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.rpgbackpacks.RpgBackpacksMod;
import net.rpgbackpacks.RpgBackpacksModElements;
import org.lwjgl.opengl.GL11;

@RpgBackpacksModElements.ModElement.Tag
public class LegendarybackpackGUI2Gui
extends RpgBackpacksModElements.ModElement {
    public static HashMap guistate = new HashMap();
    private static ContainerType<GuiContainerMod> containerType = null;

    public LegendarybackpackGUI2Gui(RpgBackpacksModElements instance) {
        super(instance, 20);
        this.elements.addNetworkMessage(ButtonPressedMessage.class, ButtonPressedMessage::buffer, ButtonPressedMessage::new, ButtonPressedMessage::handler);
        this.elements.addNetworkMessage(GUISlotChangedMessage.class, GUISlotChangedMessage::buffer, GUISlotChangedMessage::new, GUISlotChangedMessage::handler);
        containerType = new ContainerType((ContainerType.IFactory)new GuiContainerModFactory());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initElements() {
        DeferredWorkQueue.runLater(() -> ScreenManager.func_216911_a(containerType, GuiWindow::new));
    }

    @SubscribeEvent
    public void registerContainer(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(containerType.setRegistryName("legendarybackpack_gui_2"));
    }

    private static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
    }

    private static void handleSlotAction(PlayerEntity entity, int slotID, int changeType, int meta, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
    }

    public static class GUISlotChangedMessage {
        int slotID;
        int x;
        int y;
        int z;
        int changeType;
        int meta;

        public GUISlotChangedMessage(int slotID, int x, int y, int z, int changeType, int meta) {
            this.slotID = slotID;
            this.x = x;
            this.y = y;
            this.z = z;
            this.changeType = changeType;
            this.meta = meta;
        }

        public GUISlotChangedMessage(PacketBuffer buffer) {
            this.slotID = buffer.readInt();
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
            this.changeType = buffer.readInt();
            this.meta = buffer.readInt();
        }

        public static void buffer(GUISlotChangedMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.slotID);
            buffer.writeInt(message.x);
            buffer.writeInt(message.y);
            buffer.writeInt(message.z);
            buffer.writeInt(message.changeType);
            buffer.writeInt(message.meta);
        }

        public static void handler(GUISlotChangedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity entity = context.getSender();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                LegendarybackpackGUI2Gui.handleSlotAction((PlayerEntity)entity, slotID, changeType, meta, x, y, z);
            });
            context.setPacketHandled(true);
        }
    }

    public static class ButtonPressedMessage {
        int buttonID;
        int x;
        int y;
        int z;

        public ButtonPressedMessage(PacketBuffer buffer) {
            this.buttonID = buffer.readInt();
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
        }

        public ButtonPressedMessage(int buttonID, int x, int y, int z) {
            this.buttonID = buttonID;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static void buffer(ButtonPressedMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.buttonID);
            buffer.writeInt(message.x);
            buffer.writeInt(message.y);
            buffer.writeInt(message.z);
        }

        public static void handler(ButtonPressedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity entity = context.getSender();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                LegendarybackpackGUI2Gui.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z);
            });
            context.setPacketHandled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GuiWindow
    extends ContainerScreen<GuiContainerMod> {
        private World world;
        private int x;
        private int y;
        private int z;
        private PlayerEntity entity;
        private static final ResourceLocation texture = new ResourceLocation("rpg_backpacks:textures/legendarybackpack_gui_2.png");

        public GuiWindow(GuiContainerMod container, PlayerInventory inventory, ITextComponent text) {
            super((Container)container, inventory, text);
            this.world = container.world;
            this.x = container.x;
            this.y = container.y;
            this.z = container.z;
            this.entity = container.entity;
            this.field_146999_f = 392;
            this.field_147000_g = 221;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float par1, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            int k = (this.width - this.field_146999_f) / 2;
            int l = (this.height - this.field_147000_g) / 2;
            GuiWindow.blit((int)k, (int)l, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.field_146999_f, (int)this.field_147000_g);
        }

        public void tick() {
            super.tick();
        }

        protected void func_146979_b(int mouseX, int mouseY) {
            this.font.func_211126_b("Legendary Backpack", 149.0f, 120.0f, -3407668);
        }

        public boolean keyPressed(int key, int b, int c) {
            if (key == 256) {
                this.minecraft.field_71439_g.func_71053_j();
                return true;
            }
            return super.keyPressed(key, b, c);
        }

        public void removed() {
            super.removed();
            Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
        }

        public void init(Minecraft minecraft, int width, int height) {
            super.init(minecraft, width, height);
            minecraft.field_195559_v.func_197967_a(true);
        }
    }

    public static class GuiContainerMod
    extends Container
    implements Supplier<Map<Integer, Slot>> {
        private World world;
        private PlayerEntity entity;
        private int x;
        private int y;
        private int z;
        private IItemHandler internal;
        private Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
        private boolean bound = false;

        public GuiContainerMod(int id, PlayerInventory inv, PacketBuffer extraData) {
            super(containerType, id);
            int si;
            this.entity = inv.field_70458_d;
            this.world = inv.field_70458_d.field_70170_p;
            this.internal = new ItemStackHandler(176);
            BlockPos pos = null;
            if (extraData != null) {
                pos = extraData.func_179259_c();
                this.x = pos.func_177958_n();
                this.y = pos.func_177956_o();
                this.z = pos.func_177952_p();
            }
            if (pos != null) {
                if (extraData.readableBytes() == 1) {
                    byte hand = extraData.readByte();
                    ItemStack itemstack = hand == 0 ? this.entity.func_184614_ca() : this.entity.func_184592_cb();
                    itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                } else if (extraData.readableBytes() > 1) {
                    extraData.readByte();
                    Entity entity = this.world.func_73045_a(extraData.func_150792_a());
                    if (entity != null) {
                        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                            this.internal = capability;
                            this.bound = true;
                        });
                    }
                } else {
                    TileEntity ent;
                    TileEntity tileEntity = ent = inv.field_70458_d != null ? inv.field_70458_d.field_70170_p.func_175625_s(pos) : null;
                    if (ent != null) {
                        ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                            this.internal = capability;
                            this.bound = true;
                        });
                    }
                }
            }
            this.customSlots.put(0, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 0, 7, 8){}));
            this.customSlots.put(1, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 1, 25, 8){}));
            this.customSlots.put(2, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 2, 43, 8){}));
            this.customSlots.put(3, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 3, 61, 8){}));
            this.customSlots.put(4, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 4, 79, 8){}));
            this.customSlots.put(5, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 5, 97, 8){}));
            this.customSlots.put(6, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 6, 115, 8){}));
            this.customSlots.put(7, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 7, 133, 8){}));
            this.customSlots.put(8, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 8, 151, 8){}));
            this.customSlots.put(9, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 9, 169, 8){}));
            this.customSlots.put(10, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 10, 187, 8){}));
            this.customSlots.put(11, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 11, 205, 8){}));
            this.customSlots.put(12, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 12, 223, 8){}));
            this.customSlots.put(13, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 13, 241, 8){}));
            this.customSlots.put(14, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 14, 259, 8){}));
            this.customSlots.put(15, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 15, 277, 8){}));
            this.customSlots.put(16, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 16, 295, 8){}));
            this.customSlots.put(17, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 17, 313, 8){}));
            this.customSlots.put(18, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 18, 331, 8){}));
            this.customSlots.put(19, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 19, 349, 8){}));
            this.customSlots.put(20, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 20, 367, 8){}));
            this.customSlots.put(21, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 21, 7, 26){}));
            this.customSlots.put(22, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 22, 25, 26){}));
            this.customSlots.put(23, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 23, 43, 26){}));
            this.customSlots.put(24, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 24, 61, 26){}));
            this.customSlots.put(25, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 25, 79, 26){}));
            this.customSlots.put(26, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 26, 97, 26){}));
            this.customSlots.put(27, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 27, 115, 26){}));
            this.customSlots.put(28, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 28, 133, 26){}));
            this.customSlots.put(29, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 29, 151, 26){}));
            this.customSlots.put(30, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 30, 169, 26){}));
            this.customSlots.put(31, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 31, 187, 26){}));
            this.customSlots.put(32, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 32, 205, 26){}));
            this.customSlots.put(33, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 33, 223, 26){}));
            this.customSlots.put(34, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 34, 241, 26){}));
            this.customSlots.put(35, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 35, 259, 26){}));
            this.customSlots.put(36, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 36, 277, 26){}));
            this.customSlots.put(37, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 37, 295, 26){}));
            this.customSlots.put(38, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 38, 313, 26){}));
            this.customSlots.put(39, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 39, 331, 26){}));
            this.customSlots.put(40, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 40, 349, 26){}));
            this.customSlots.put(41, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 41, 367, 26){}));
            this.customSlots.put(42, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 42, 7, 44){}));
            this.customSlots.put(43, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 43, 25, 44){}));
            this.customSlots.put(44, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 44, 43, 44){}));
            this.customSlots.put(45, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 45, 61, 44){}));
            this.customSlots.put(46, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 46, 79, 44){}));
            this.customSlots.put(47, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 47, 97, 44){}));
            this.customSlots.put(48, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 48, 115, 44){}));
            this.customSlots.put(49, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 49, 133, 44){}));
            this.customSlots.put(50, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 50, 151, 44){}));
            this.customSlots.put(51, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 51, 169, 44){}));
            this.customSlots.put(52, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 52, 187, 44){}));
            this.customSlots.put(53, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 53, 205, 44){}));
            this.customSlots.put(54, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 54, 223, 44){}));
            this.customSlots.put(55, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 55, 241, 44){}));
            this.customSlots.put(56, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 56, 259, 44){}));
            this.customSlots.put(57, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 57, 277, 44){}));
            this.customSlots.put(58, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 58, 295, 44){}));
            this.customSlots.put(59, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 59, 313, 44){}));
            this.customSlots.put(60, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 60, 331, 44){}));
            this.customSlots.put(61, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 61, 349, 44){}));
            this.customSlots.put(62, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 62, 367, 44){}));
            this.customSlots.put(63, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 63, 7, 62){}));
            this.customSlots.put(64, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 64, 25, 62){}));
            this.customSlots.put(65, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 65, 43, 62){}));
            this.customSlots.put(66, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 66, 61, 62){}));
            this.customSlots.put(67, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 67, 79, 62){}));
            this.customSlots.put(68, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 68, 97, 62){}));
            this.customSlots.put(69, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 69, 115, 62){}));
            this.customSlots.put(70, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 70, 133, 62){}));
            this.customSlots.put(71, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 71, 151, 62){}));
            this.customSlots.put(72, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 72, 169, 62){}));
            this.customSlots.put(73, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 73, 187, 62){}));
            this.customSlots.put(74, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 74, 205, 62){}));
            this.customSlots.put(75, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 75, 223, 62){}));
            this.customSlots.put(76, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 76, 241, 62){}));
            this.customSlots.put(77, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 77, 259, 62){}));
            this.customSlots.put(78, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 78, 277, 62){}));
            this.customSlots.put(79, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 79, 295, 62){}));
            this.customSlots.put(80, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 80, 313, 62){}));
            this.customSlots.put(81, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 81, 331, 62){}));
            this.customSlots.put(82, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 82, 349, 62){}));
            this.customSlots.put(83, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 83, 367, 62){}));
            this.customSlots.put(84, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 84, 7, 80){}));
            this.customSlots.put(85, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 85, 25, 80){}));
            this.customSlots.put(86, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 86, 43, 80){}));
            this.customSlots.put(87, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 87, 61, 80){}));
            this.customSlots.put(88, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 88, 79, 80){}));
            this.customSlots.put(89, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 89, 97, 80){}));
            this.customSlots.put(90, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 90, 115, 80){}));
            this.customSlots.put(91, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 91, 133, 80){}));
            this.customSlots.put(92, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 92, 151, 80){}));
            this.customSlots.put(93, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 93, 169, 80){}));
            this.customSlots.put(94, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 94, 187, 80){}));
            this.customSlots.put(95, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 95, 205, 80){}));
            this.customSlots.put(96, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 96, 223, 80){}));
            this.customSlots.put(97, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 97, 241, 80){}));
            this.customSlots.put(98, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 98, 259, 80){}));
            this.customSlots.put(99, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 99, 277, 80){}));
            this.customSlots.put(100, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 100, 295, 80){}));
            this.customSlots.put(101, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 101, 313, 80){}));
            this.customSlots.put(102, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 102, 331, 80){}));
            this.customSlots.put(103, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 103, 349, 80){}));
            this.customSlots.put(104, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 104, 367, 80){}));
            this.customSlots.put(105, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 105, 7, 98){}));
            this.customSlots.put(106, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 106, 25, 98){}));
            this.customSlots.put(107, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 107, 43, 98){}));
            this.customSlots.put(108, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 108, 61, 98){}));
            this.customSlots.put(109, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 109, 79, 98){}));
            this.customSlots.put(110, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 110, 97, 98){}));
            this.customSlots.put(111, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 111, 115, 98){}));
            this.customSlots.put(112, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 112, 133, 98){}));
            this.customSlots.put(113, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 113, 151, 98){}));
            this.customSlots.put(114, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 114, 169, 98){}));
            this.customSlots.put(115, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 115, 187, 98){}));
            this.customSlots.put(116, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 116, 205, 98){}));
            this.customSlots.put(117, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 117, 223, 98){}));
            this.customSlots.put(118, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 118, 241, 98){}));
            this.customSlots.put(119, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 119, 259, 98){}));
            this.customSlots.put(120, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 120, 277, 98){}));
            this.customSlots.put(121, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 121, 295, 98){}));
            this.customSlots.put(122, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 122, 313, 98){}));
            this.customSlots.put(123, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 123, 331, 98){}));
            this.customSlots.put(124, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 124, 349, 98){}));
            this.customSlots.put(125, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 125, 367, 98){}));
            this.customSlots.put(126, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 126, 7, 121){}));
            this.customSlots.put(127, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 127, 25, 121){}));
            this.customSlots.put(128, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 128, 43, 121){}));
            this.customSlots.put(129, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 129, 61, 121){}));
            this.customSlots.put(130, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 130, 79, 121){}));
            this.customSlots.put(131, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 131, 295, 121){}));
            this.customSlots.put(132, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 132, 313, 121){}));
            this.customSlots.put(133, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 133, 331, 121){}));
            this.customSlots.put(134, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 134, 349, 121){}));
            this.customSlots.put(135, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 135, 367, 121){}));
            this.customSlots.put(136, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 136, 7, 139){}));
            this.customSlots.put(137, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 137, 25, 139){}));
            this.customSlots.put(138, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 138, 43, 139){}));
            this.customSlots.put(139, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 139, 61, 139){}));
            this.customSlots.put(140, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 140, 79, 139){}));
            this.customSlots.put(141, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 141, 295, 139){}));
            this.customSlots.put(142, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 142, 313, 139){}));
            this.customSlots.put(143, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 143, 331, 139){}));
            this.customSlots.put(144, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 144, 349, 139){}));
            this.customSlots.put(145, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 145, 367, 139){}));
            this.customSlots.put(146, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 146, 7, 157){}));
            this.customSlots.put(147, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 147, 25, 157){}));
            this.customSlots.put(148, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 148, 43, 157){}));
            this.customSlots.put(149, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 149, 61, 157){}));
            this.customSlots.put(150, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 150, 79, 157){}));
            this.customSlots.put(151, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 151, 295, 157){}));
            this.customSlots.put(152, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 152, 313, 157){}));
            this.customSlots.put(153, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 153, 331, 157){}));
            this.customSlots.put(154, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 154, 349, 157){}));
            this.customSlots.put(155, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 155, 367, 157){}));
            this.customSlots.put(156, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 156, 7, 175){}));
            this.customSlots.put(157, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 157, 25, 175){}));
            this.customSlots.put(158, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 158, 43, 175){}));
            this.customSlots.put(159, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 159, 61, 175){}));
            this.customSlots.put(160, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 160, 79, 175){}));
            this.customSlots.put(161, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 161, 295, 175){}));
            this.customSlots.put(162, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 162, 313, 175){}));
            this.customSlots.put(163, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 163, 331, 175){}));
            this.customSlots.put(164, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 164, 349, 175){}));
            this.customSlots.put(165, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 165, 367, 175){}));
            this.customSlots.put(166, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 166, 7, 197){}));
            this.customSlots.put(167, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 167, 25, 197){}));
            this.customSlots.put(168, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 168, 43, 197){}));
            this.customSlots.put(169, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 169, 61, 197){}));
            this.customSlots.put(170, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 170, 79, 197){}));
            this.customSlots.put(171, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 171, 295, 197){}));
            this.customSlots.put(172, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 172, 313, 197){}));
            this.customSlots.put(173, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 173, 331, 197){}));
            this.customSlots.put(174, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 174, 349, 197){}));
            this.customSlots.put(175, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 175, 367, 197){}));
            for (si = 0; si < 3; ++si) {
                for (int sj = 0; sj < 9; ++sj) {
                    this.func_75146_a(new Slot((IInventory)inv, sj + (si + 1) * 9, 116 + sj * 18, 139 + si * 18));
                }
            }
            for (si = 0; si < 9; ++si) {
                this.func_75146_a(new Slot((IInventory)inv, si, 116 + si * 18, 197));
            }
        }

        @Override
        public Map<Integer, Slot> get() {
            return this.customSlots;
        }

        public boolean func_75145_c(PlayerEntity player) {
            return true;
        }

        public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (index < 176) {
                    if (!this.func_75135_a(itemstack1, 176, this.field_75151_b.size(), true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(itemstack1, itemstack);
                } else if (!this.func_75135_a(itemstack1, 0, 176, false)) {
                    if (index < 203 ? !this.func_75135_a(itemstack1, 203, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 176, 203, false)) {
                        return ItemStack.field_190927_a;
                    }
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
            }
            return itemstack;
        }

        protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
            boolean flag = false;
            int i = startIndex;
            if (reverseDirection) {
                i = endIndex - 1;
            }
            if (stack.func_77985_e()) {
                while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                    ItemStack itemstack;
                    Slot slot = (Slot)this.field_75151_b.get(i);
                    if (slot.func_75214_a(itemstack = slot.func_75211_c()) && !itemstack.func_190926_b() && GuiContainerMod.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                        int maxSize;
                        int j = itemstack.func_190916_E() + stack.func_190916_E();
                        if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                            stack.func_190920_e(0);
                            itemstack.func_190920_e(j);
                            slot.func_75215_d(itemstack);
                            flag = true;
                        } else if (itemstack.func_190916_E() < maxSize) {
                            stack.func_190918_g(maxSize - itemstack.func_190916_E());
                            itemstack.func_190920_e(maxSize);
                            slot.func_75215_d(itemstack);
                            flag = true;
                        }
                    }
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            if (!stack.func_190926_b()) {
                i = reverseDirection ? endIndex - 1 : startIndex;
                while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                    Slot slot1 = (Slot)this.field_75151_b.get(i);
                    ItemStack itemstack1 = slot1.func_75211_c();
                    if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                        if (stack.func_190916_E() > slot1.func_75219_a()) {
                            slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                        } else {
                            slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                        }
                        slot1.func_75218_e();
                        flag = true;
                        break;
                    }
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            return flag;
        }

        public void func_75134_a(PlayerEntity playerIn) {
            block4: {
                super.func_75134_a(playerIn);
                if (this.bound || !(playerIn instanceof ServerPlayerEntity)) break block4;
                if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                    for (int j = 0; j < this.internal.getSlots(); ++j) {
                        playerIn.func_71019_a(this.internal.extractItem(j, this.internal.getStackInSlot(j).func_190916_E(), false), false);
                    }
                } else {
                    for (int i = 0; i < this.internal.getSlots(); ++i) {
                        playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, this.internal.extractItem(i, this.internal.getStackInSlot(i).func_190916_E(), false));
                    }
                }
            }
        }

        private void slotChanged(int slotid, int ctype, int meta) {
            if (this.world != null && this.world.field_72995_K) {
                RpgBackpacksMod.PACKET_HANDLER.sendToServer((Object)new GUISlotChangedMessage(slotid, this.x, this.y, this.z, ctype, meta));
                LegendarybackpackGUI2Gui.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
            }
        }
    }

    public static class GuiContainerModFactory
    implements IContainerFactory {
        public GuiContainerMod create(int id, PlayerInventory inv, PacketBuffer extraData) {
            return new GuiContainerMod(id, inv, extraData);
        }
    }
}

