/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.seals;

import com.buuz135.seals.SealInfo;
import com.buuz135.seals.client.SealButton;
import com.buuz135.seals.client.SealPlayerRenderer;
import com.buuz135.seals.config.JSONConfigLoader;
import com.buuz135.seals.config.SealManager;
import com.buuz135.seals.network.ClientSyncSealsMessage;
import com.buuz135.seals.network.SealRequestMessage;
import com.buuz135.seals.storage.SealWorldStorage;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="seals")
public class Seals {
    public static final SealManager SEAL_MANAGER = new SealManager();
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("seals", "network"), () -> "1.0", s -> true, s -> true);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<UUID> PATREONS = new ArrayList<UUID>();

    public Seals() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        new JSONConfigLoader();
        NETWORK.registerMessage(0, ClientSyncSealsMessage.class, ClientSyncSealsMessage::toBytes, packetBuffer -> new ClientSyncSealsMessage().fromBytes((ByteBuf)packetBuffer), ClientSyncSealsMessage::handle);
        NETWORK.registerMessage(1, SealRequestMessage.class, SealRequestMessage::toBytes, packetBuffer -> new SealRequestMessage().fromBytes((ByteBuf)packetBuffer), SealRequestMessage::handle);
        try {
            PATREONS.addAll(Seals.getPlayers(new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        this.replacePlayerRenderer();
        ClientAdvancementManager advancementManager = new ClientAdvancementManager(Minecraft.func_71410_x());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void replacePlayerRenderer() {
        Minecraft.func_71410_x().func_175598_ae().field_178637_m = new SealPlayerRenderer(Minecraft.func_71410_x().func_175598_ae());
        Minecraft.func_71410_x().func_175598_ae().field_178636_l.put("default", Minecraft.func_71410_x().func_175598_ae().field_178637_m);
        Minecraft.func_71410_x().func_175598_ae().field_178636_l.put("slim", new SealPlayerRenderer(Minecraft.func_71410_x().func_175598_ae(), true));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        World world = event.getPlayer().func_130014_f_();
        if (world instanceof ServerWorld && event.getPlayer() instanceof ServerPlayerEntity) {
            NETWORK.sendTo((Object)new ClientSyncSealsMessage(SealWorldStorage.get((ServerWorld)world).serializeNBT()), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiScreenEvent.InitGuiEvent.Post event) {
        block3: {
            block2: {
                if (!(event.getGui() instanceof AdvancementsScreen)) break block2;
                ArrayList<SealInfo> seals = new ArrayList<SealInfo>(SEAL_MANAGER.getSeals());
                seals.removeIf(sealInfo -> sealInfo.isInvisible() && !sealInfo.hasAchievedSealClient(Minecraft.func_71410_x().field_71439_g));
                Screen screen = event.getGui();
                int guiLeft = (screen.width - 252) / 2;
                int guiTop = (screen.height - 140) / 2;
                for (int i = 0; i < seals.size(); ++i) {
                    event.addWidget((Widget)new SealButton((SealInfo)seals.get(i), guiLeft - 26 * (i / 6 + 1), guiTop + 24 * (i % 6) - 6));
                }
                break block3;
            }
            if (!event.getGui().getClass().getName().equalsIgnoreCase("betteradvancements.gui.BetterAdvancementsScreen")) break block3;
            ArrayList<SealInfo> seals = new ArrayList<SealInfo>(SEAL_MANAGER.getSeals());
            seals.removeIf(sealInfo -> sealInfo.isInvisible() && !sealInfo.hasAchievedSealClient(Minecraft.func_71410_x().field_71439_g));
            for (int i = 0; i < seals.size(); ++i) {
                event.addWidget((Widget)new SealButton((SealInfo)seals.get(i), 5, 10 + 24 * i));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof AdvancementsScreen || event.getGui().getClass().getName().equalsIgnoreCase("betteradvancements.gui.BetterAdvancementsScreen")) {
            Screen screen = event.getGui();
            screen.buttons.stream().filter(widget -> widget instanceof SealButton).forEach(widget -> widget.render(event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()));
        }
    }

    private static List<UUID> getPlayers(URL url) {
        try {
            ArrayList<UUID> players = new ArrayList<UUID>();
            new JsonParser().parse(Seals.readUrl(url)).getAsJsonObject().get("uuid").getAsJsonArray().forEach(jsonElement -> players.add(UUID.fromString(jsonElement.getAsString())));
            return players;
        }
        catch (IOException var2) {
            var2.printStackTrace();
            return new ArrayList<UUID>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(URL url) throws IOException {
        try (BufferedReader reader = null;){
            int read;
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer buffer = new StringBuffer();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
    }
}

