/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.client.gui.ElectricEngineScreen;
import xyz.przemyk.simpleplanes.client.gui.FurnaceEngineScreen;
import xyz.przemyk.simpleplanes.client.gui.PlaneWorkbenchScreen;
import xyz.przemyk.simpleplanes.client.gui.RemoveUpgradesScreen;
import xyz.przemyk.simpleplanes.client.gui.StorageScreen;
import xyz.przemyk.simpleplanes.client.render.PlaneItemColors;
import xyz.przemyk.simpleplanes.client.render.PlaneRenderer;
import xyz.przemyk.simpleplanes.client.render.models.HelicopterModel;
import xyz.przemyk.simpleplanes.client.render.models.HelicopterPropellerModel;
import xyz.przemyk.simpleplanes.client.render.models.LargePlaneModel;
import xyz.przemyk.simpleplanes.client.render.models.PlaneModel;
import xyz.przemyk.simpleplanes.client.render.models.PropellerModel;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.network.BoostPacket;
import xyz.przemyk.simpleplanes.network.OpenEngineInventoryPacket;
import xyz.przemyk.simpleplanes.network.OpenInventoryPacket;
import xyz.przemyk.simpleplanes.network.PlaneNetworking;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding boostKey;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding openEngineInventoryKey;
    private static boolean playerRotationNeedToPop;
    private static boolean oldBoostState;
    public static final ResourceLocation HUD_TEXTURE;

    public static void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.PLANE.get()), manager -> new PlaneRenderer<PlaneEntity>(manager, new PlaneModel(), new PropellerModel(), 0.6f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.LARGE_PLANE.get()), manager -> new PlaneRenderer<LargePlaneEntity>(manager, new LargePlaneModel(), new PropellerModel(), 1.0f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.HELICOPTER.get()), manager -> new PlaneRenderer<PlaneEntity>(manager, new HelicopterModel(), new HelicopterPropellerModel(), 0.6f));
        boostKey = new KeyBinding("key.plane_boost.desc", 32, "key.simpleplanes.category");
        openEngineInventoryKey = new KeyBinding("key.plane_engine_open.desc", 88, "key.simpleplanes.category");
        ClientRegistry.registerKeyBinding((KeyBinding)boostKey);
        ClientRegistry.registerKeyBinding((KeyBinding)openEngineInventoryKey);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SimplePlanesContainers.PLANE_WORKBENCH.get()), PlaneWorkbenchScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SimplePlanesContainers.UPGRADES_REMOVAL.get()), RemoveUpgradesScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SimplePlanesContainers.STORAGE.get()), StorageScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SimplePlanesContainers.FURNACE_ENGINE.get()), FurnaceEngineScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SimplePlanesContainers.ELECTRIC_ENGINE.get()), ElectricEngineScreen::new);
    }

    public static void planeColor(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        SimplePlanesItems.getPlaneItems().forEach(item -> itemColors.func_199877_a(PlaneItemColors::getColor, new IItemProvider[]{item}));
    }

    public static void reloadTextures(TextureStitchEvent.Post event) {
        PlaneItemColors.clearCache();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.func_184208_bv();
        if (entity instanceof PlaneEntity) {
            boolean isPlayerRidingInFirstPersonView;
            PlaneEntity planeEntity = (PlaneEntity)entity;
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            playerRotationNeedToPop = true;
            double firstPersonYOffset = 0.7;
            boolean bl = isPlayerRidingInFirstPersonView = Minecraft.func_71410_x().field_71439_g != null && planeEntity.func_184196_w((Entity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_243228_bb == PointOfView.FIRST_PERSON;
            if (isPlayerRidingInFirstPersonView) {
                matrixStack.func_227861_a_(0.0, firstPersonYOffset, 0.0);
            }
            matrixStack.func_227861_a_(0.0, 0.7, 0.0);
            Quaternion quaternion = MathUtil.lerpQ(event.getPartialRenderTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.func_227066_a_(quaternion.func_195889_a(), -quaternion.func_195891_b(), -quaternion.func_195893_c(), quaternion.func_195894_d());
            matrixStack.func_227863_a_(quaternion);
            float rotationYaw = MathUtil.lerpAngle(event.getPartialRenderTick(), entity.field_70126_B, entity.field_70177_z);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotationYaw));
            matrixStack.func_227861_a_(0.0, -0.7, 0.0);
            if (isPlayerRidingInFirstPersonView) {
                matrixStack.func_227861_a_(0.0, -firstPersonYOffset, 0.0);
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.field_70759_as = planeEntity.field_70177_z * 2.0f - livingEntity.field_70759_as;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.field_70758_at = planeEntity.field_70126_B * 2.0f - livingEntity.field_70758_at;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        if (playerRotationNeedToPop) {
            playerRotationNeedToPop = false;
            event.getMatrixStack().func_227865_b_();
            Entity entity = event.getEntity().func_184208_bv();
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                event.getEntity().field_70759_as = planeEntity.field_70177_z * 2.0f - event.getEntity().field_70759_as;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                event.getEntity().field_70758_at = planeEntity.field_70126_B * 2.0f - event.getEntity().field_70758_at;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof ClientPlayerEntity) {
            if (player.func_184187_bx() instanceof PlaneEntity) {
                boolean isBoosting;
                PlaneEntity planeEntity = (PlaneEntity)player.func_184187_bx();
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71474_y.field_243228_bb == PointOfView.FIRST_PERSON) {
                    float yawDiff = planeEntity.field_70177_z - planeEntity.field_70126_B;
                    player.field_70177_z += yawDiff;
                    float relativePlayerYaw = MathHelper.func_76142_g((float)(player.field_70177_z - planeEntity.field_70177_z));
                    float clampedRelativePlayerYaw = MathHelper.func_76131_a((float)relativePlayerYaw, (float)-105.0f, (float)105.0f);
                    float diff = clampedRelativePlayerYaw - relativePlayerYaw;
                    player.field_70126_B += diff;
                    player.field_70177_z += diff;
                    player.func_70034_d(player.field_70177_z);
                    relativePlayerYaw = MathHelper.func_76142_g((float)(player.field_70125_A - 0.0f));
                    clampedRelativePlayerYaw = MathHelper.func_76131_a((float)relativePlayerYaw, (float)-50.0f, (float)50.0f);
                    float perc = (clampedRelativePlayerYaw - relativePlayerYaw) * 0.5f;
                    player.field_70127_C += perc;
                    player.field_70125_A += perc;
                } else {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                if (planeEntity.engineUpgrade != null && mc.field_71462_r == null && mc.field_213279_p == null && openEngineInventoryKey.func_151468_f() && planeEntity.engineUpgrade.canOpenGui()) {
                    PlaneNetworking.INSTANCE.sendToServer((Object)new OpenEngineInventoryPacket());
                }
                if ((isBoosting = boostKey.func_151470_d()) != oldBoostState || Math.random() < 0.1) {
                    PlaneNetworking.INSTANCE.sendToServer((Object)new BoostPacket(isBoosting));
                }
                oldBoostState = isBoosting;
            } else {
                oldBoostState = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        ActiveRenderInfo renderInfo = event.getInfo();
        Entity entity = renderInfo.func_216773_g();
        if (entity instanceof ClientPlayerEntity && entity.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity.func_184187_bx();
            ClientPlayerEntity playerEntity = (ClientPlayerEntity)entity;
            if (renderInfo.func_216770_i()) {
                renderInfo.func_216782_a(-renderInfo.func_216779_a(4.0 * (planeEntity.getCameraDistanceMultiplayer() - 1.0)), 0.0, 0.0);
            } else {
                double partialTicks = event.getRenderPartialTicks();
                Quaternion q_prev = planeEntity.getQ_Prev();
                int max = 105;
                float diff = (float)MathHelper.func_151237_a((double)MathUtil.wrapSubtractDegrees(planeEntity.field_70126_B, playerEntity.field_70126_B), (double)(-max), (double)max);
                float pitch = MathHelper.func_76131_a((float)event.getPitch(), (float)-45.0f, (float)45.0f);
                q_prev.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(diff));
                q_prev.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
                MathUtil.EulerAngles angles_prev = MathUtil.toEulerAngles(q_prev);
                Quaternion q_client = planeEntity.getQ_Client();
                diff = (float)MathHelper.func_151237_a((double)MathUtil.wrapSubtractDegrees(planeEntity.field_70177_z, playerEntity.field_70177_z), (double)(-max), (double)max);
                q_client.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(diff));
                q_client.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
                MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q_client);
                event.setPitch(-((float)MathUtil.lerpAngle180(partialTicks, angles_prev.pitch, angles.pitch)));
                event.setYaw((float)MathUtil.lerpAngle(partialTicks, angles_prev.yaw, angles.yaw));
                event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, angles_prev.roll, angles.roll)));
            }
        }
    }

    @SubscribeEvent
    public static void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        int scaledWidth = mc.func_228018_at_().func_198107_o();
        int scaledHeight = mc.func_228018_at_().func_198087_p();
        MatrixStack matrixStack = event.getMatrixStack();
        if (mc.field_71439_g.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)mc.field_71439_g.func_184187_bx();
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                mc.func_110434_K().func_110577_a(HUD_TEXTURE);
                int left_align = scaledWidth / 2 + 91;
                int health = (int)Math.ceil(planeEntity.getHealth());
                float healthMax = planeEntity.getMaxHealth();
                int hearts = (int)healthMax;
                if (hearts > 10) {
                    hearts = 10;
                }
                boolean FULL = false;
                int EMPTY = 16;
                int GOLD = 32;
                int right_height = 39;
                int max_row_size = 5;
                int heart = 0;
                while (hearts > 0) {
                    int top = scaledHeight - right_height;
                    int rowCount = Math.min(hearts, max_row_size);
                    hearts -= rowCount;
                    for (int i = 0; i < rowCount; ++i) {
                        int x = left_align - i * 16 - 16;
                        int vOffset = 35;
                        if (i + heart + 10 < health) {
                            ClientEventHandler.blit(matrixStack, 0, x, top, 32, vOffset, 16, 9);
                            continue;
                        }
                        if (i + heart < health) {
                            ClientEventHandler.blit(matrixStack, 0, x, top, 0, vOffset, 16, 9);
                            continue;
                        }
                        ClientEventHandler.blit(matrixStack, 0, x, top, 16, vOffset, 16, 9);
                    }
                    right_height += 10;
                    heart += max_row_size;
                }
                if (planeEntity.engineUpgrade != null) {
                    ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
                    HandSide primaryHand = mc.field_71439_g.func_184591_cq();
                    planeEntity.engineUpgrade.renderPowerHUD(matrixStack, primaryHand == HandSide.LEFT || offhandStack.func_190926_b() ? HandSide.LEFT : HandSide.RIGHT, scaledWidth, scaledHeight, event.getPartialTicks());
                }
                if (planeEntity.mountMessage) {
                    planeEntity.mountMessage = false;
                    if (planeEntity instanceof HelicopterEntity) {
                        mc.field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("helicopter.onboard", new Object[]{mc.field_71474_y.field_228046_af_.func_238171_j_(), boostKey.func_238171_j_()}), false);
                    } else {
                        mc.field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("plane.onboard", new Object[]{mc.field_71474_y.field_228046_af_.func_238171_j_(), boostKey.func_238171_j_()}), false);
                    }
                }
            } else if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
                event.setCanceled(true);
            }
        }
    }

    public static void renderHotbarItem(MatrixStack matrixStack, int x, int y, float partialTicks, ItemStack stack, Minecraft mc) {
        ItemRenderer itemRenderer = mc.func_175599_af();
        if (!stack.func_190926_b()) {
            float f = (float)stack.func_77988_m() - partialTicks;
            if (f > 0.0f) {
                matrixStack.func_227860_a_();
                float f1 = 1.0f + f / 5.0f;
                matrixStack.func_227861_a_((double)(x + 8), (double)(y + 12), 0.0);
                matrixStack.func_227862_a_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                matrixStack.func_227861_a_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            itemRenderer.func_184391_a((LivingEntity)mc.field_71439_g, stack, x, y);
            if (f > 0.0f) {
                matrixStack.func_227865_b_();
            }
            itemRenderer.func_175030_a(mc.field_71466_p, stack, x, y);
        }
    }

    public static void blit(MatrixStack matrixStack, int blitOffset, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)blitOffset, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)256, (int)256);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void planeInventory(GuiOpenEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getGui() instanceof InventoryScreen && player.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity plane = (PlaneEntity)player.func_184187_bx();
            if (plane.upgrades.containsKey(SimplePlanesUpgrades.CHEST.getId())) {
                event.setCanceled(true);
                PlaneNetworking.INSTANCE.sendToServer((Object)new OpenInventoryPacket());
            }
        }
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::planeColor);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::reloadTextures);
        playerRotationNeedToPop = false;
        oldBoostState = false;
        HUD_TEXTURE = new ResourceLocation("simpleplanes", "textures/gui/plane_hud.png");
    }
}

