/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.container;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import xyz.przemyk.simpleplanes.container.PlaneCraftingResultSlot;
import xyz.przemyk.simpleplanes.network.CycleItemsPacket;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRecipes;

public class PlaneWorkbenchContainer
extends Container {
    public static final ResourceLocation PLANE_MATERIALS = new ResourceLocation("simpleplanes", "plane_materials");
    private final ItemStackHandler itemHandler = new ItemStackHandler(3);
    private final IWorldPosCallable worldPosCallable;
    private final PlayerEntity player;
    private int selectedRecipe = 0;
    private final CompoundNBT resultItemTag = new CompoundNBT();
    private List<PlaneWorkbenchRecipe> recipeList;

    public PlaneWorkbenchContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public PlaneWorkbenchContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super((ContainerType)SimplePlanesContainers.PLANE_WORKBENCH.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.player = playerInventory.field_70458_d;
        worldPosCallable.func_221486_a((world, blockPos) -> {
            this.recipeList = world.func_199532_z().func_241447_a_(SimplePlanesRecipes.PLANE_WORKBENCH_RECIPE_TYPE);
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 0, 28, 47));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 1, 75, 47));
        this.func_75146_a((Slot)new PlaneCraftingResultSlot(this.player, this, (IItemHandler)this.itemHandler, 2, 134, 47));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public void updateCraftingResult() {
        this.worldPosCallable.func_221486_a((world, blockPos) -> this.updateCraftingResult((World)world, this.player));
    }

    public void cycleItems(CycleItemsPacket.TYPE type) {
        int prevSelectedRecipe = this.selectedRecipe;
        ItemStack ingredient = this.itemHandler.getStackInSlot(0);
        ItemStack material = this.itemHandler.getStackInSlot(1);
        switch (type) {
            case CRAFTING_LEFT: {
                do {
                    if (this.selectedRecipe == 0) {
                        this.selectedRecipe = this.recipeList.size() - 1;
                        continue;
                    }
                    --this.selectedRecipe;
                } while (this.selectedRecipe != prevSelectedRecipe && !this.recipeList.get(this.selectedRecipe).canCraft(ingredient, material));
                break;
            }
            case CRAFTING_RIGHT: {
                do {
                    if (this.selectedRecipe == this.recipeList.size() - 1) {
                        this.selectedRecipe = 0;
                        continue;
                    }
                    ++this.selectedRecipe;
                } while (this.selectedRecipe != prevSelectedRecipe && !this.recipeList.get(this.selectedRecipe).canCraft(ingredient, material));
            }
        }
        this.updateCraftingResult();
    }

    public void onCrafting() {
        if (!this.player.field_70170_p.field_72995_K) {
            PlaneWorkbenchRecipe recipe = this.recipeList.get(this.selectedRecipe);
            this.itemHandler.extractItem(0, recipe.ingredient.func_193365_a()[0].func_190916_E(), false);
            this.itemHandler.extractItem(1, recipe.materialAmount, false);
            this.updateCraftingResult();
        }
    }

    protected void updateCraftingResult(World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            ItemStack result = ItemStack.field_190927_a;
            ItemStack ingredientStack = this.itemHandler.getStackInSlot(0);
            ItemStack materialStack = this.itemHandler.getStackInSlot(1);
            Item materialItem = materialStack.func_77973_b();
            PlaneWorkbenchRecipe recipe = this.recipeList.get(this.selectedRecipe);
            if (recipe.canCraft(ingredientStack, materialStack) && materialItem instanceof BlockItem && BlockTags.func_199896_a().func_241834_b(PLANE_MATERIALS).func_230235_a_((Object)((BlockItem)materialItem).func_179223_d())) {
                result = recipe.result.func_77946_l();
                Block block = ((BlockItem)materialItem).func_179223_d();
                this.resultItemTag.func_74778_a("material", block.getRegistryName().toString());
                result.func_77983_a("EntityTag", (INBT)this.resultItemTag);
            }
            this.itemHandler.setStackInSlot(2, result);
            serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 2, result));
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.func_221486_a((world, blockPos) -> {
            if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                for (int i = 0; i < this.itemHandler.getSlots() - 1; ++i) {
                    playerIn.func_71019_a(this.itemHandler.getStackInSlot(i), false);
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
            } else {
                for (int i = 0; i < this.itemHandler.getSlots() - 1; ++i) {
                    playerIn.field_71071_by.func_191975_a(world, this.itemHandler.getStackInSlot(i));
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
            }
        });
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return PlaneWorkbenchContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get()));
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        this.updateCraftingResult();
        return itemStack;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                this.worldPosCallable.func_221486_a((p_217067_2_, p_217067_3_) -> itemstack1.func_77973_b().func_77622_d(itemstack1, p_217067_2_, playerIn));
                if (!this.func_75135_a(itemstack1, 10, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 10 && index < 39 ? !this.func_75135_a(itemstack1, 1, 10, false) && (index < 37 ? !this.func_75135_a(itemstack1, 37, 39, false) : !this.func_75135_a(itemstack1, 10, 37, false)) : !this.func_75135_a(itemstack1, 10, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }
}

