/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.tnt.TNTUpgrade;

public class LargePlaneEntity
extends PlaneEntity {
    public boolean hasBlockUpgrade = false;

    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        for (Entity entity : list) {
            if (this.field_70170_p.field_72995_K || this.func_184179_bs() instanceof PlayerEntity || entity.func_184196_w((Entity)this) || entity.func_184218_aH() || !(entity instanceof LivingEntity) || entity instanceof PlayerEntity) continue;
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    public boolean tryToAddUpgrade(PlayerEntity playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (!this.hasBlockUpgrade && this.func_184188_bt().size() < 2) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.func_77973_b());
            return upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)((Object)upgradeType))) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean tryToAddTNT(PlayerEntity playerEntity, ItemStack itemStack) {
        if (!this.hasBlockUpgrade && this.canAddUpgrade((UpgradeType)SimplePlanesUpgrades.TNT.get()) && this.func_184188_bt().size() < 2) {
            this.addUpgrade(playerEntity, itemStack, new TNTUpgrade(this));
            return true;
        }
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 10.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.LARGE_PLANE_FUEL_COST.get();
    }

    protected boolean func_184219_q(Entity passenger) {
        List passengers = this.func_184188_bt();
        if (passengers.size() > 1 || passengers.size() == 1 && this.hasBlockUpgrade || passenger.func_184187_bx() == this) {
            return false;
        }
        return !(passenger instanceof PlaneEntity);
    }

    @Override
    public void func_184232_k(Entity passenger) {
        List passengers = this.func_184188_bt();
        super.func_184232_k(passenger);
        if (passengers.indexOf(passenger) == 0) {
            passenger.func_70107_b(passenger.func_226277_ct_(), this.func_226278_cu_() + this.func_70042_X() + this.getEntityYOffset(passenger), passenger.func_226281_cx_());
        } else {
            this.updateSecondPassenger(passenger);
        }
    }

    public void updateSecondPassenger(Entity passenger) {
        Vector3f pos = this.transformPos(this.getSecondPassengerPos(passenger));
        passenger.func_70107_b(this.func_226277_ct_() + (double)pos.func_195899_a(), this.func_226278_cu_() + (double)pos.func_195900_b(), this.func_226281_cx_() + (double)pos.func_195902_c());
    }

    protected Vector3f getSecondPassengerPos(Entity passenger) {
        return new Vector3f(0.0f, (float)(super.func_70042_X() + this.getEntityYOffset(passenger)), -1.0f);
    }

    public double getEntityYOffset(Entity passenger) {
        if (passenger instanceof VillagerEntity) {
            return ((VillagerEntity)passenger).func_70631_g_() ? -0.1 : -0.3;
        }
        return passenger.func_70033_W();
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return 1.2;
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.LARGE_PLANE_ITEM.get();
    }
}

