/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.items;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class PlaneItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntityPredicates.field_180132_d.and(Entity::func_70067_L);
    private final Supplier<? extends EntityType<? extends PlaneEntity>> planeEntityType;

    public PlaneItem(Item.Properties properties, Supplier<? extends EntityType<? extends PlaneEntity>> planeEntityType) {
        super(properties.func_200917_a(1));
        this.planeEntityType = planeEntityType;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT entityTag = stack.func_179543_a("EntityTag");
        if (entityTag != null) {
            Block block;
            if (entityTag.func_74764_b("material") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entityTag.func_74779_i("material")))) != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("simpleplanes.material").func_230529_a_((ITextComponent)block.func_235333_g_()));
            }
            if (entityTag.func_74764_b("upgrades")) {
                CompoundNBT upgradesNBT = entityTag.func_74775_l("upgrades");
                for (String key : upgradesNBT.func_150296_c()) {
                    CompoundNBT upgradeNbt = upgradesNBT.func_74775_l(key);
                    ResourceLocation resourceLocation = new ResourceLocation(key);
                    if (upgradeNbt.func_74764_b("desc")) {
                        tooltip.add((ITextComponent)new StringTextComponent(upgradeNbt.func_74779_i("desc")));
                        continue;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("name." + resourceLocation.toString().replace(":", ".")));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult raytraceresult = PlaneItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        Vector3d vec3d = playerIn.func_70676_i(1.0f);
        List list = worldIn.func_175674_a((Entity)playerIn, playerIn.func_174813_aQ().func_216361_a(vec3d.func_186678_a(5.0)).func_186662_g(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vector3d vec3d1 = playerIn.func_174824_e(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!axisalignedbb.func_72318_a(vec3d1)) continue;
                return ActionResult.func_226250_c_((Object)itemstack);
            }
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            PlaneEntity planeEntity = (PlaneEntity)this.planeEntityType.get().func_200721_a(worldIn);
            planeEntity.func_70107_b(raytraceresult.func_216347_e().func_82615_a(), raytraceresult.func_216347_e().func_82617_b(), raytraceresult.func_216347_e().func_82616_c());
            planeEntity.field_70177_z = playerIn.field_70177_z;
            planeEntity.field_70126_B = playerIn.field_70126_B;
            planeEntity.func_200203_b(itemstack.func_200301_q());
            CompoundNBT entityTag = itemstack.func_179543_a("EntityTag");
            if (entityTag != null) {
                planeEntity.func_70037_a(entityTag);
            }
            if (!worldIn.func_226665_a__((Entity)planeEntity, planeEntity.func_174813_aQ().func_186662_g(-0.1))) {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)planeEntity);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> itemStacks) {
        if (this.func_194125_a(itemGroup)) {
            BlockTags.func_199896_a().func_241834_b(PlaneWorkbenchContainer.PLANE_MATERIALS).func_230236_b_().forEach(block -> {
                ItemStack itemStack = new ItemStack((IItemProvider)this);
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_74778_a("material", block.getRegistryName().toString());
                itemStack.func_77983_a("EntityTag", (INBT)itemTag);
                itemStacks.add((Object)itemStack);
            });
        }
    }
}

