/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;

public class RotationPacket {
    private final Quaternion quaternion;

    public RotationPacket(Quaternion quaternion) {
        this.quaternion = quaternion;
    }

    public RotationPacket(PacketBuffer buffer) {
        this.quaternion = (Quaternion)SimplePlanesDataSerializers.QUATERNION_SERIALIZER.func_187159_a(buffer);
    }

    public void toBytes(PacketBuffer buffer) {
        SimplePlanesDataSerializers.QUATERNION_SERIALIZER.func_187160_a(buffer, (Object)this.quaternion);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity sender = ctx.getSender();
            if (sender != null && sender.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)sender.func_184187_bx();
                planeEntity.setQ(this.quaternion);
                MathUtil.EulerAngles eulerAngles = MathUtil.toEulerAngles(this.quaternion);
                planeEntity.field_70177_z = (float)eulerAngles.yaw;
                planeEntity.field_70125_A = (float)eulerAngles.pitch;
                planeEntity.rotationRoll = (float)eulerAngles.roll;
                planeEntity.setQ_Client(this.quaternion);
            }
        });
        ctx.setPacketHandled(true);
    }
}

