/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRecipes;

public class PlaneWorkbenchRecipe
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final int ingredientAmount;
    public final int materialAmount;
    public final ItemStack result;

    public PlaneWorkbenchRecipe(ResourceLocation id, Ingredient ingredient, int ingredientAmount, int materialAmount, ItemStack result) {
        this.id = id;
        this.ingredient = ingredient;
        this.ingredientAmount = ingredientAmount;
        this.materialAmount = materialAmount;
        this.result = result;
    }

    public boolean canCraft(ItemStack ingredientStack, ItemStack materialStack) {
        return ingredientStack.func_190916_E() >= this.ingredientAmount && materialStack.func_190916_E() >= this.materialAmount && this.ingredient.test(ingredientStack);
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return SimplePlanesRecipes.PLANE_WORKBENCH_RECIPE_TYPE;
    }

    public boolean func_77569_a(IInventory p_77569_1_, World p_77569_2_) {
        return false;
    }

    public ItemStack func_77572_b(IInventory p_77572_1_) {
        return null;
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return false;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PlaneWorkbenchRecipe> {
        public Serializer() {
            this.setRegistryName("simpleplanes", "plane_workbench");
        }

        public PlaneWorkbenchRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            int ingredientAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"ingredient_amount");
            int materialAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"material_amount");
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new PlaneWorkbenchRecipe(id, ingredient, ingredientAmount, materialAmount, result);
        }

        @Nullable
        public PlaneWorkbenchRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int ingredientAmount = buffer.func_150792_a();
            int materialAmount = buffer.func_150792_a();
            ItemStack result = buffer.func_150791_c();
            return new PlaneWorkbenchRecipe(id, ingredient, ingredientAmount, materialAmount, result);
        }

        public void toNetwork(PacketBuffer buffer, PlaneWorkbenchRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150787_b(recipe.ingredientAmount);
            buffer.func_150787_b(recipe.materialAmount);
            buffer.func_150788_a(recipe.result);
        }
    }
}

