/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public abstract class Upgrade
extends CapabilityProvider<Upgrade>
implements INBTSerializable<CompoundNBT> {
    private final UpgradeType type;
    protected final PlaneEntity planeEntity;
    public boolean updateClient = false;
    public boolean removed = false;

    public PlaneEntity getPlaneEntity() {
        return this.planeEntity;
    }

    public Upgrade(UpgradeType type, PlaneEntity planeEntity) {
        super(Upgrade.class);
        this.type = type;
        this.planeEntity = planeEntity;
    }

    protected void updateClient() {
        this.updateClient = true;
    }

    public void remove() {
        this.removed = true;
        this.invalidateCaps();
    }

    public final UpgradeType getType() {
        return this.type;
    }

    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
    }

    public void tick() {
    }

    public abstract void render(MatrixStack var1, IRenderTypeBuffer var2, int var3, float var4);

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }

    public void onApply(ItemStack itemStack, PlayerEntity playerEntity) {
    }

    public abstract void writePacket(PacketBuffer var1);

    public abstract void readPacket(PacketBuffer var1);

    public abstract void dropItems();
}

