/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.booster;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.booster.BoosterModel;

public class BoosterUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/rocket.png");
    public static int FUEL_PER_GUNPOWDER = 20;
    public int fuel = 0;

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("fuel", this.fuel);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        this.fuel = compoundNBT.func_74762_e("fuel");
    }

    @Override
    public void writePacket(PacketBuffer buffer) {
        buffer.func_150787_b(this.fuel);
    }

    @Override
    public void readPacket(PacketBuffer buffer) {
        this.fuel = buffer.func_150792_a();
    }

    public BoosterUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.BOOSTER.get(), planeEntity);
    }

    @Override
    public void tick() {
        this.push();
    }

    @Override
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getPlayer().func_184586_b(event.getHand());
        if (this.fuel <= 0 && itemStack.func_77973_b().equals(Items.field_151016_H)) {
            if (!event.getPlayer().func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            this.fuel = FUEL_PER_GUNPOWDER;
        }
        this.push();
    }

    private void push() {
        if (this.fuel < 0) {
            return;
        }
        --this.fuel;
        this.updateClient();
        Vector3d m = this.planeEntity.func_213322_ci();
        float pitch = 0.0f;
        PlayerEntity player = this.planeEntity.getPlayer();
        if (player != null) {
            if (player.field_191988_bg > 0.0f) {
                if (this.planeEntity.func_70051_ag()) {
                    pitch += 2.0f;
                }
            } else if (player.field_191988_bg < 0.0f) {
                pitch -= 2.0f;
            }
        }
        if (this.planeEntity.field_70170_p.field_73012_v.nextInt(50) == 0) {
            this.planeEntity.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
        if (this.planeEntity instanceof HelicopterEntity) {
            pitch = 0.0f;
        }
        this.planeEntity.field_70125_A += pitch;
        Vector3d motion = MathUtil.rotationToVector(this.planeEntity.field_70177_z, this.planeEntity.field_70125_A, 0.05);
        this.planeEntity.func_213317_d(m.func_178787_e(motion));
        if (this.planeEntity.field_70170_p.field_72995_K) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197631_x, new Vector3f(-0.6f, 0.0f, -1.3f));
            this.spawnParticle((IParticleData)ParticleTypes.field_197631_x, new Vector3f(0.6f, 0.0f, -1.3f));
        }
    }

    public void spawnParticle(IParticleData particleData, Vector3f relPos) {
        relPos = new Vector3f(relPos.func_195899_a(), relPos.func_195900_b() - 0.3f, relPos.func_195902_c());
        relPos = this.planeEntity.transformPos(relPos);
        relPos = new Vector3f(relPos.func_195899_a(), relPos.func_195900_b() + 0.9f, relPos.func_195902_c());
        Vector3d motion = this.planeEntity.func_213322_ci();
        double speed = motion.func_72433_c() / 4.0;
        this.planeEntity.field_70170_p.func_195594_a(particleData, this.planeEntity.func_226277_ct_() + (double)relPos.func_195899_a(), this.planeEntity.func_226278_cu_() + (double)relPos.func_195900_b(), this.planeEntity.func_226281_cx_() + (double)relPos.func_195902_c(), motion.field_72450_a * speed, (motion.field_72448_b + 1.0) * speed, motion.field_72449_c * speed);
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(BoosterModel.INSTANCE.func_228282_a_(TEXTURE));
        BoosterModel.INSTANCE.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void dropItems() {
        this.planeEntity.func_199703_a((IItemProvider)SimplePlanesItems.BOOSTER.get());
    }
}

