/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.furnace;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.client.ClientEventHandler;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.container.FurnaceEngineContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class FurnaceEngineUpgrade
extends EngineUpgrade
implements INamedContainerProvider {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler();
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    public int burnTime;
    public int burnTimeTotal;

    public FurnaceEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.FURNACE_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (this.burnTime > 0) {
            this.burnTime -= this.planeEntity.getFuelCost();
            this.updateClient();
        } else {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
            int itemBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack);
            if (itemBurnTime > 0) {
                this.burnTimeTotal = itemBurnTime;
                this.burnTime = itemBurnTime;
                if (itemStack.hasContainerItem()) {
                    this.itemStackHandler.setStackInSlot(0, itemStack.getContainerItem());
                } else {
                    this.itemStackHandler.extractItem(0, 1, false);
                }
                this.updateClient();
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.burnTime > 0;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        matrixStack.func_227860_a_();
        EntityType entityType = this.planeEntity.func_200600_R();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.func_227861_a_(0.0, -0.8, 0.65);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            matrixStack.func_227861_a_(0.0, 0.0, 1.1);
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-0.4, -1.0, 0.3);
        matrixStack.func_227862_a_(0.82f, 0.82f, 0.82f);
        ClientUtil.renderItemModelAsBlock(matrixStack, Minecraft.func_71410_x(), buffer, packedLight, (Item)SimplePlanesItems.FURNACE_ENGINE.get());
        matrixStack.func_227865_b_();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("item", (INBT)this.itemStackHandler.serializeNBT());
        compound.func_74768_a("burnTime", this.burnTime);
        compound.func_74768_a("burnTimeTotal", this.burnTimeTotal);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("item"));
        this.burnTime = compound.func_74762_e("burnTime");
        this.burnTimeTotal = compound.func_74762_e("burnTimeTotal");
    }

    @Override
    public void writePacket(PacketBuffer buffer) {
        buffer.func_150788_a(this.itemStackHandler.getStackInSlot(0));
        buffer.func_150787_b(this.burnTime);
        buffer.func_150787_b(this.burnTimeTotal);
    }

    @Override
    public void readPacket(PacketBuffer buffer) {
        this.itemStackHandler.setStackInSlot(0, buffer.func_150791_c());
        this.burnTime = buffer.func_150792_a();
        this.burnTimeTotal = buffer.func_150792_a();
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public void openGui(ServerPlayerEntity playerEntity) {
        NetworkHooks.openGui((ServerPlayerEntity)playerEntity, (INamedContainerProvider)this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("simpleplanes.furnace_engine_container");
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FurnaceEngineContainer(id, playerInventory, (IItemHandler)this.itemStackHandler, new IIntArray(){

            public int func_221476_a(int index) {
                if (index == 0) {
                    return FurnaceEngineUpgrade.this.burnTime;
                }
                return FurnaceEngineUpgrade.this.burnTimeTotal;
            }

            public void func_221477_a(int index, int value) {
            }

            public int func_221478_a() {
                return 2;
            }
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void dropItems() {
        this.planeEntity.func_199703_a((IItemProvider)SimplePlanesItems.FURNACE_ENGINE.get());
        this.planeEntity.func_199701_a_(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public void renderPowerHUD(MatrixStack matrixStack, HandSide side, int scaledWidth, int scaledHeight, float partialTicks) {
        ItemStack fuelStack;
        int i = scaledWidth / 2;
        Minecraft mc = Minecraft.func_71410_x();
        if (side == HandSide.LEFT) {
            ClientEventHandler.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 40, 0, 44, 22, 40);
        } else {
            ClientEventHandler.blit(matrixStack, -90, i + 91, scaledHeight - 40, 0, 44, 22, 40);
        }
        if (this.burnTime > 0) {
            int burnTimeTotal2 = this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal;
            int burnLeftScaled = this.burnTime * 13 / burnTimeTotal2;
            if (side == HandSide.LEFT) {
                ClientEventHandler.blit(matrixStack, -90, i - 91 - 29 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            } else {
                ClientEventHandler.blit(matrixStack, -90, i + 91 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            }
        }
        if (!(fuelStack = this.itemStackHandler.getStackInSlot(0)).func_190926_b()) {
            int i2 = scaledHeight - 16 - 3;
            if (side == HandSide.LEFT) {
                ClientEventHandler.renderHotbarItem(matrixStack, i - 91 - 26, i2, partialTicks, fuelStack, mc);
            } else {
                ClientEventHandler.renderHotbarItem(matrixStack, i + 91 + 3, i2, partialTicks, fuelStack, mc);
            }
        }
    }
}

