/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.storage;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.przemyk.simpleplanes.compat.IronChestsCompat;
import xyz.przemyk.simpleplanes.container.StorageContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class ChestUpgrade
extends LargeUpgrade
implements INamedContainerProvider {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(27);
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    public Item chestType = Items.field_221675_bZ;

    public ChestUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.CHEST.get(), planeEntity);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = this.itemStackHandler.serializeNBT();
        nbt.func_74778_a("ChestType", this.chestType.getRegistryName().toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.itemStackHandler.deserializeNBT(nbt);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("ChestType")));
        this.chestType = item == null ? Items.field_221675_bZ : item;
    }

    @Override
    public void writePacket(PacketBuffer buffer) {
        buffer.writeRegistryId((IForgeRegistryEntry)this.chestType);
    }

    @Override
    public void readPacket(PacketBuffer buffer) {
        this.chestType = (Item)buffer.readRegistryIdSafe(Item.class);
    }

    @Override
    public void dropItems() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            this.planeEntity.func_199701_a_(itemStack);
        }
        this.planeEntity.func_199703_a((IItemProvider)this.chestType);
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        matrixStack.func_227860_a_();
        EntityType entityType = this.planeEntity.func_200600_R();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.func_227861_a_(0.0, 0.0, -0.3);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            matrixStack.func_227861_a_(0.0, 0.0, 0.1);
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-0.4, -1.0, -1.3);
        matrixStack.func_227862_a_(0.82f, 0.82f, 0.82f);
        BlockState state = this.chestType instanceof BlockItem ? ((BlockItem)this.chestType).func_179223_d().func_176223_P() : Blocks.field_150486_ae.func_176223_P();
        Minecraft.func_71410_x().func_175602_ab().renderBlock(state, matrixStack, buffer, packedLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("simpleplanes:chest");
    }

    public Container createMenu(int id, PlayerInventory playerInventoryIn, PlayerEntity playerEntity) {
        return new StorageContainer(id, playerInventoryIn, (IItemHandler)this.itemStackHandler, this.chestType.getRegistryName().toString());
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onApply(ItemStack itemStack, PlayerEntity playerEntity) {
        this.chestType = itemStack.func_77973_b();
        this.itemStackHandler.setSize(IronChestsCompat.getSize(this.chestType.getRegistryName().toString()));
    }
}

