/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AddEntryLootModifier
extends LootModifier {
    private static final Gson GSON = Deserializers.m_78799_().create();
    private final LootPoolEntryContainer entry;
    private final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;
    private final boolean requireEmpty;

    protected AddEntryLootModifier(LootItemCondition[] conditionsIn, LootPoolEntryContainer entry, LootItemFunction[] functions, boolean requireEmpty) {
        super(conditionsIn);
        this.entry = entry;
        this.functions = functions;
        this.combinedFunctions = LootItemFunctions.m_80770_((BiFunction[])functions);
        this.requireEmpty = requireEmpty;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        block3: {
            block2: {
                if (!this.requireEmpty) break block2;
                if (!generatedLoot.isEmpty()) break block3;
            }
            Consumer consumer = LootItemFunction.m_80724_(this.combinedFunctions, generatedLoot::add, (LootContext)context);
            this.entry.m_6562_(context, generator -> generator.m_6941_(consumer, context));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddEntryLootModifier> {
        public AddEntryLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            LootPoolEntryContainer entry = (LootPoolEntryContainer)GSON.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)object, (String)"entry"), LootPoolEntryContainer.class);
            LootItemFunction[] functions = object.has("functions") ? (LootItemFunction[])GSON.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)"functions"), LootItemFunction[].class) : new LootItemFunction[]{};
            boolean requireEmpty = GsonHelper.m_13855_((JsonObject)object, (String)"require_empty", (boolean)false);
            return new AddEntryLootModifier(conditions, entry, functions, requireEmpty);
        }

        public JsonObject write(AddEntryLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("require_empty", Boolean.valueOf(instance.requireEmpty));
            object.add("entry", GSON.toJsonTree((Object)instance.entry, LootPoolEntryContainer.class));
            object.add("functions", GSON.toJsonTree((Object)instance.functions, LootItemFunction[].class));
            return object;
        }
    }
}

