/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data.gen;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import knightminer.simplytea.block.TeaTrunkBlock;
import knightminer.simplytea.core.Registration;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLootTableGenerator
extends BlockLoot {
    private final ResourceLocation LEAVES_ID = new ResourceLocation("simplytea", "blocks/tea_leaves");

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "simplytea".equals(Objects.requireNonNull(block.getRegistryName()).m_135827_())).collect(Collectors.toList());
    }

    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.addTables();
        HashSet set = Sets.newHashSet();
        for (Block block : this.getKnownBlocks()) {
            ResourceLocation name = block.m_60589_();
            if (name == BuiltInLootTables.f_78712_ || !set.add(name)) continue;
            LootTable.Builder builder = (LootTable.Builder)this.f_124070_.remove(name);
            if (builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", name, block.getRegistryName()));
            }
            consumer.accept(name, builder);
        }
        LootTable.Builder leavesBuilder = (LootTable.Builder)this.f_124070_.remove(this.LEAVES_ID);
        if (leavesBuilder == null) {
            throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", this.LEAVES_ID, Registration.tea_tree.getRegistryName()));
        }
        consumer.accept(this.LEAVES_ID, leavesBuilder);
        if (!this.f_124070_.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.f_124070_.keySet());
        }
    }

    protected void addTables() {
        this.m_124288_(Registration.tea_fence);
        this.m_124288_(Registration.tea_fence_gate);
        this.m_124288_((Block)Registration.tea_sapling);
        this.m_124252_(Registration.potted_tea_sapling);
        this.f_124070_.put(this.LEAVES_ID, LootTable.m_79147_().m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Registration.tea_leaf))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Registration.tea_leaf).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.55f, (int)2)))).m_79161_(LootPool.m_79043_().m_6509_(ExplosionCondition.m_81661_()).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f})).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Registration.tea_sapling))));
        this.m_124175_(Registration.tea_trunk, block -> LootTable.m_79147_().m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Registration.tea_stick))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Registration.tea_stick).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.55f, (int)2)))).m_79161_(LootPool.m_79043_().m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)TeaTrunkBlock.CLIPPED, false))).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)this.LEAVES_ID))));
    }
}

