/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.item;

import java.util.List;
import javax.annotation.Nullable;
import knightminer.simplytea.core.config.TeaDrink;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class TeaCupItem
extends Item {
    public static final String HONEY_TAG = "with_honey";
    private static final Component WITH_HONEY = new TranslatableComponent("item.simplytea.cup.with_honey").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)16748822)));

    public TeaCupItem(Item.Properties props) {
        super(props);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return stack.m_41720_().m_41472_() ? UseAnim.DRINK : UseAnim.NONE;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.m_41773_() + 1 >= stack.m_41776_()) {
            return super.getContainerItem(stack);
        }
        stack = stack.m_41777_();
        stack.m_41721_(stack.m_41773_() + 1);
        return stack;
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity living) {
        if (this.m_41472_()) {
            TeaDrink drink;
            MobEffectInstance effectInstance;
            ItemStack result = stack.getContainerItem();
            boolean hasHoney = TeaCupItem.hasHoney(stack, HONEY_TAG);
            living.curePotionEffects(stack);
            living.m_5584_(worldIn, stack);
            FoodProperties food = this.getFoodProperties(stack, living);
            if (food instanceof TeaDrink && (effectInstance = (drink = (TeaDrink)food).getEffect(hasHoney)) != null) {
                living.m_7292_(effectInstance);
            }
            return result;
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (TeaCupItem.hasHoney(stack, HONEY_TAG)) {
            tooltip.add(WITH_HONEY);
        }
    }

    public static ItemStack withHoney(ItemStack stack, String tag) {
        stack.m_41784_().m_128379_(tag, true);
        return stack;
    }

    public static boolean hasHoney(ItemStack stack, String tag) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_(tag);
    }
}

