/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data.gen;

import java.util.Objects;
import java.util.function.Consumer;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.data.SimplyTags;
import knightminer.simplytea.data.gen.ShapelessHoneyRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String m_6055_() {
        return "Simply Tea Recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(SimplyTags.Items.TEA_CROP), (ItemLike)Registration.black_tea, (float)0.35f, (int)200, (SimpleCookingSerializer)RecipeSerializer.f_44093_).m_126132_("has_item", (CriterionTriggerInstance)RecipeGenerator.m_206406_(SimplyTags.Items.TEA_CROP)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)Registration.tea_fence, (int)2).m_126130_("sss").m_126130_("sss").m_126127_(Character.valueOf('s'), (ItemLike)Registration.tea_stick).m_126132_("has_stick", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Registration.tea_stick)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)Registration.tea_fence_gate).m_126130_("sss").m_126130_(" s ").m_126130_("sss").m_126127_(Character.valueOf('s'), (ItemLike)Registration.tea_stick).m_126132_("has_stick", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Registration.tea_stick)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)Registration.unfired_cup, (int)2).m_126130_("CBC").m_126130_(" C ").m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42461_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42499_).m_126132_("has_item", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42461_)).m_176498_(consumer);
        RecipeGenerator.fire(consumer, (ItemLike)Registration.unfired_cup, (ItemLike)Registration.cup);
        ShapedRecipeBuilder.m_126116_((ItemLike)Registration.unfired_teapot).m_126130_("CBC").m_126130_("CC ").m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42461_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42499_).m_126132_("has_item", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42461_)).m_176498_(consumer);
        RecipeGenerator.fire(consumer, (ItemLike)Registration.unfired_teapot, (ItemLike)Registration.teapot);
        RecipeGenerator.boil(consumer, (ItemLike)Registration.teapot_water, (ItemLike)Registration.teapot_hot);
        RecipeGenerator.boil(consumer, (ItemLike)Registration.teapot_milk, (ItemLike)Registration.teapot_frothed);
        ShapedRecipeBuilder.m_126118_((ItemLike)Registration.teabag, (int)4).m_126130_("  S").m_126130_("PP ").m_126130_("PP ").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126132_("has_floral", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_41939_)).m_126132_("has_leaf", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Registration.tea_leaf)).m_176498_(consumer);
        RecipeGenerator.addTeaWithBag(consumer, (ItemLike)Items.f_41939_, (ItemLike)Registration.teabag_floral, (ItemLike)Registration.cup_tea_floral);
        RecipeGenerator.addTeaWithBag(consumer, (ItemLike)Registration.tea_leaf, (ItemLike)Registration.teabag_green, (ItemLike)Registration.cup_tea_green);
        RecipeGenerator.addTeaWithBag(consumer, (ItemLike)Registration.black_tea, (ItemLike)Registration.teabag_black, (ItemLike)Registration.cup_tea_black);
        RecipeGenerator.addTeaWithBag(consumer, (ItemLike)Registration.chorus_petal, (ItemLike)Registration.teabag_chorus, (ItemLike)Registration.cup_tea_chorus);
        RecipeGenerator.addTea(consumer, (ItemLike)Registration.cup_cocoa, new ItemLike[]{Items.f_42533_, Items.f_42533_, Registration.teapot_frothed});
        RecipeGenerator.addHoney(consumer, (ItemLike)Registration.cup_cocoa, (ItemLike)Registration.tea_stick, "with_cinnamon");
        RecipeGenerator.addTea(consumer, (ItemLike)Registration.cup_tea_chai, new ItemLike[]{Registration.teabag_black, Registration.tea_stick, Registration.teapot_frothed});
        RecipeGenerator.addHoney(consumer, (ItemLike)Registration.cup_tea_chai);
        ShapelessRecipeBuilder.m_126189_((ItemLike)Registration.cup_tea_iced).m_126209_((ItemLike)Registration.cup).m_126209_((ItemLike)Registration.teabag_green).m_126209_((ItemLike)Items.f_42410_).m_206419_(SimplyTags.Items.ICE_CUBES).m_126132_("has_ice", (CriterionTriggerInstance)RecipeGenerator.m_206406_(SimplyTags.Items.ICE_CUBES)).m_176498_(consumer);
        RecipeGenerator.addHoney(consumer, (ItemLike)Registration.cup_tea_iced);
    }

    private static ResourceLocation suffix(ItemLike item, String suffix) {
        ResourceLocation name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
        return new ResourceLocation(name.m_135827_(), name.m_135815_() + suffix);
    }

    private static void fire(Consumer<FinishedRecipe> consumer, ItemLike unfired, ItemLike fired) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{unfired}), (ItemLike)fired, (float)0.35f, (int)300).m_126132_("has_unfired", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)unfired)).m_176498_(consumer);
    }

    private static void boil(Consumer<FinishedRecipe> consumer, ItemLike cold, ItemLike hot) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{cold}), (ItemLike)hot, (float)0.35f, (int)900, (SimpleCookingSerializer)RecipeSerializer.f_44094_).m_126132_("has_unfired", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)cold)).m_126140_(consumer, RecipeGenerator.suffix(hot, "_campfire"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{cold}), (ItemLike)hot, (float)0.35f, (int)300).m_126132_("has_unfired", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)cold)).m_126140_(consumer, RecipeGenerator.suffix(hot, "_smelting"));
    }

    private static void addTea(Consumer<FinishedRecipe> consumer, ItemLike filledCup, ItemLike ... ingredients) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_126189_((ItemLike)filledCup);
        builder.m_126209_((ItemLike)Registration.cup);
        for (ItemLike ingredient : ingredients) {
            builder.m_126209_(ingredient);
        }
        builder.m_126132_("has_bag", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)ingredients[0]));
        builder.m_176498_(consumer);
    }

    public static void addHoney(Consumer<FinishedRecipe> consumer, ItemLike tea) {
        RecipeGenerator.addHoney(consumer, tea, (ItemLike)Items.f_42787_, "with_honey");
    }

    public static void addHoney(Consumer<FinishedRecipe> consumer, ItemLike tea, ItemLike honey, String tag) {
        ResourceLocation recipeId = RecipeGenerator.suffix(tea, "_" + tag);
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        builder.m_138386_("has_item", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)honey)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        ResourceLocation advancementId = new ResourceLocation(recipeId.m_135827_(), "recipes/" + Objects.requireNonNull(tea.m_5456_().m_41471_()).m_40783_() + "/" + recipeId.m_135815_());
        consumer.accept(new ShapelessHoneyRecipe.Finished(recipeId, "simplytea:" + tag, tea, Ingredient.m_43929_((ItemLike[])new ItemLike[]{honey}), tag, advancementId, builder));
    }

    private static void addTeaWithBag(Consumer<FinishedRecipe> consumer, ItemLike leaf, ItemLike filledTeabag, ItemLike filledCup) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)filledTeabag).m_126145_("simplytea:teabag").m_126209_((ItemLike)Registration.teabag).m_126209_(leaf).m_126209_(leaf).m_126132_("has_leaf", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)leaf)).m_176498_(consumer);
        RecipeGenerator.addTea(consumer, filledCup, new ItemLike[]{filledTeabag, Registration.teapot_hot});
        RecipeGenerator.addHoney(consumer, filledCup);
    }
}

