/*
 * Decompiled with CFR 0.152.
 */
package spikesandgrasscovering.mod.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import spikesandgrasscovering.mod.SpikesandGrassCovering;
import spikesandgrasscovering.mod.init.ModBlocks;
import spikesandgrasscovering.mod.init.ModItems;
import spikesandgrasscovering.mod.util.interfaces.IHasModel;

public class BlockGrassCovering
extends Block
implements IHasModel {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(1.0, 0.87, 1.0, 0.0, 1.0, 0.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(1.0, 0.87, 1.0, 0.0, 1.0, 0.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(1.0, 0.87, 1.0, 0.0, 1.0, 0.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(1.0, 0.87, 1.0, 0.0, 1.0, 0.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(1.0, 0.87, 1.0, 0.0, 1.0, 0.0);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(1.0, 0.87, 1.0, 0.0, 1.0, 0.0);

    public BlockGrassCovering(String name, Material material, CreativeTabs tab) {
        super(Material.field_151577_b);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(tab);
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(name));
    }

    @Override
    public void registerModels() {
        SpikesandGrassCovering.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return DOWN_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return UP_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            worldIn.func_175698_g(pos);
        }
        super.func_176199_a(worldIn, pos, entityIn);
        BlockGrassCovering.spawnParticles(worldIn, pos);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.8;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175698_g(pos);
        worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d0, d1, d2, 1.0, 1.0, 1.0, new int[]{Block.func_149682_b((Block)ModBlocks.BLOCK_GRASS_COVERING)});
    }

    private static void spawnParticles(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d3 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d3 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177956_o() - 0.0625;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 0) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 0))) continue;
            worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) / 1.0f), (double)pos.func_177956_o() + (double)(worldIn.field_73012_v.nextFloat() / -1.0f - worldIn.field_73012_v.nextFloat()) / -1.3, (double)((float)pos.func_177952_p() + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) / 1.0f), 0.0, 0.0, 0.0, new int[]{Block.func_149682_b((Block)ModBlocks.BLOCK_GRASS_COVERING)});
        }
    }

    public boolean blocksLight(IBlockState state) {
        return true;
    }

    public boolean isSolid(IBlockState state) {
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos posOff = pos.func_177972_a(facing);
            IBlockState blockstate = world.func_180495_p(posOff);
            if (!blockstate.func_177230_c().isSideSolid(blockstate, (IBlockAccess)world, posOff, facing.func_176734_d()) && blockstate.func_177230_c() != this) continue;
            return true;
        }
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!this.canBlockStay((World)world, pos)) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175671_l(pos.func_177984_a()) < 4 && worldIn.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) {
                worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            } else if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177984_a());
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    if (iblockstate1.func_177230_c() != Blocks.field_150346_d || iblockstate1.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || worldIn.func_175671_l(blockpos.func_177984_a()) < 4 || iblockstate.getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) continue;
                    worldIn.func_175656_a(blockpos, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }

    public MapColor getMapColor(IBlockState state) {
        return MapColor.field_151661_c;
    }
}

