/*
 * Decompiled with CFR 0.152.
 */
package spikesandgrasscovering.mod.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import spikesandgrasscovering.mod.SpikesandGrassCovering;
import spikesandgrasscovering.mod.init.ModBlocks;
import spikesandgrasscovering.mod.init.ModItems;
import spikesandgrasscovering.mod.util.interfaces.IHasModel;

public class BlockSpikes
extends Block
implements IHasModel {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(1.0, 1.0, 0.7, 0.0, 0.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.3, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(1.0, 1.0, 0.3, 0.0, 0.0, 0.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(1.0, 0.0, 0.0, 0.7, 1.0, 1.0);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(1.0, 0.7, 1.0, 0.0, 1.0, 0.0);

    public BlockSpikes(String name, Material material, CreativeTabs tab) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(tab);
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(name));
    }

    @Override
    public void registerModels() {
        SpikesandGrassCovering.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.func_176198_a(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return this.func_176223_P();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public MapColor getMapColor() {
        return MapColor.field_151660_b;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean blocksLight(IBlockState state) {
        return false;
    }

    public boolean isSolid(IBlockState state) {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity.field_70143_R >= 5.0f) {
            entity.func_70097_a(DamageSource.field_76379_h, 20.0f);
            return;
        }
        double motionX = entity.field_70159_w;
        double motionY = entity.field_70181_x;
        double motionZ = entity.field_70179_y;
        int damageTodo = (int)((motionX + motionY + motionZ) / 1.5);
        entity.func_70097_a(DamageSource.field_76377_j, (float)(4 + damageTodo));
    }
}

