/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.client.gui.BlackBoardGui;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class BlackboardBlock
extends Block
implements IWaterLoggable {
    public static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    public static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlackboardBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)tileentity;
            if (worldIn.func_201670_d()) {
                BlackBoardGui.open(te);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BlackboardBlockTile();
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            tooltip.add(new TranslationTextComponent("message.supplementaries.blackboard", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ItemStack getBlackboardItem(BlackboardBlockTile te) {
        CompoundNBT compoundnbt;
        ItemStack itemstack = new ItemStack((IItemProvider)this);
        if (!te.isEmpty() && !(compoundnbt = te.saveItemNBT(new CompoundNBT())).isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof BlackboardBlockTile) {
            ItemStack itemstack = this.getBlackboardItem((BlackboardBlockTile)tileentity);
            return Collections.singletonList(itemstack);
        }
        return super.func_220076_a(state, builder);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BlackboardBlockTile) {
            return this.getBlackboardItem((BlackboardBlockTile)te);
        }
        return super.func_185473_a(worldIn, pos, state);
    }
}

