/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CrankBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE_DOWN = VoxelShapes.func_197873_a((double)0.125, (double)0.6875, (double)0.875, (double)0.875, (double)1.0, (double)0.125);
    protected static final VoxelShape SHAPE_UP = VoxelShapes.func_197873_a((double)0.125, (double)0.3125, (double)0.125, (double)0.875, (double)0.0, (double)0.875);
    protected static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197873_a((double)0.125, (double)0.125, (double)0.6875, (double)0.875, (double)0.875, (double)1.0);
    protected static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197873_a((double)0.875, (double)0.125, (double)0.3125, (double)0.125, (double)0.875, (double)0.0);
    protected static final VoxelShape SHAPE_EAST = VoxelShapes.func_197873_a((double)0.3125, (double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875);
    protected static final VoxelShape SHAPE_WEST = VoxelShapes.func_197873_a((double)0.6875, (double)0.125, (double)0.875, (double)1.0, (double)0.875, (double)0.125);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CrankBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176734_d() == stateIn.func_177229_b((IProperty)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return CrankBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)direction);
        }
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            Direction direction = ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d();
            double d0 = (double)pos.func_177958_n() + 0.5 + 0.1 * (double)direction.func_82601_c() + 0.2 * (double)direction.func_82601_c();
            double d1 = (double)pos.func_177956_o() + 0.5 + 0.1 * (double)direction.func_96559_d() + 0.2 * (double)direction.func_96559_d();
            double d2 = (double)pos.func_177952_p() + 0.5 + 0.1 * (double)direction.func_82599_e() + 0.2 * (double)direction.func_82599_e();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
            return ActionResultType.SUCCESS;
        }
        this.activate(state, worldIn, pos, player.func_225608_bj_());
        float f = 0.4f;
        worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        return ActionResultType.CONSUME;
    }

    public void activate(BlockState state, World world, BlockPos pos, boolean ccw) {
        state = (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf((16 + (Integer)state.func_177229_b((IProperty)POWER) + (ccw ? -1 : 1)) % 16));
        world.func_180501_a(pos, state, 3);
        this.updateNeighbors(state, world, pos);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_177229_b((IProperty)FACING) == side ? (Integer)blockState.func_177229_b((IProperty)POWER) : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    private void updateNeighbors(BlockState state, World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d()), (Block)this);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if ((Integer)state.func_177229_b((IProperty)POWER) != 0) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((IProperty)POWER) > 0 && rand.nextFloat() < 0.25f) {
            Direction direction = ((Direction)stateIn.func_177229_b((IProperty)FACING)).func_176734_d();
            double d0 = (double)pos.func_177958_n() + 0.5 + 0.1 * (double)direction.func_82601_c() + 0.2 * (double)direction.func_82601_c();
            double d1 = (double)pos.func_177956_o() + 0.5 + 0.1 * (double)direction.func_96559_d() + 0.2 * (double)direction.func_96559_d();
            double d2 = (double)pos.func_177952_p() + 0.5 + 0.1 * (double)direction.func_82599_e() + 0.2 * (double)direction.func_82599_e();
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, 0.5f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_181623_g() {
        return true;
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity2) {
        return PathNodeType.OPEN;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            default: {
                return SHAPE_SOUTH;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: 
        }
        return SHAPE_DOWN;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, POWER, WATERLOGGED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            Direction direction1 = direction.func_176734_d();
            if (!(blockstate = (BlockState)blockstate.func_206870_a((IProperty)FACING, (Comparable)direction1)).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return (BlockState)blockstate.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }
}

