/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.lang.reflect.Field;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class FaucetBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197873_a((double)0.6875, (double)0.3125, (double)1.0, (double)0.3125, (double)0.9375, (double)0.3125);
    protected static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.9375, (double)0.6875);
    protected static final VoxelShape SHAPE_WEST = VoxelShapes.func_197873_a((double)1.0, (double)0.3125, (double)0.3125, (double)0.3125, (double)0.9375, (double)0.6875);
    protected static final VoxelShape SHAPE_EAST = VoxelShapes.func_197873_a((double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.9375, (double)0.3125);
    protected static final VoxelShape SHAPE_NORTH_JAR = VoxelShapes.func_197873_a((double)0.6875, (double)0.0, (double)1.0, (double)0.3125, (double)0.625, (double)0.3125);
    protected static final VoxelShape SHAPE_SOUTH_JAR = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)0.625, (double)0.6875);
    protected static final VoxelShape SHAPE_WEST_JAR = VoxelShapes.func_197873_a((double)1.0, (double)0.0, (double)0.3125, (double)0.3125, (double)0.625, (double)0.6875);
    protected static final VoxelShape SHAPE_EAST_JAR = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.6875, (double)0.6875, (double)0.625, (double)0.3125);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty HAS_WATER = BlockProperties.HAS_WATER;
    public static final BooleanProperty HAS_JAR = BlockProperties.HAS_JAR;
    public static final BooleanProperty EXTENDED = BlockStateProperties.field_208174_a;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public FaucetBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HAS_JAR, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)HAS_WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((IProperty)HAS_JAR)).booleanValue()) {
            switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                default: {
                    return SHAPE_NORTH_JAR;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_JAR;
                }
                case EAST: {
                    return SHAPE_EAST_JAR;
                }
                case WEST: 
            }
            return SHAPE_WEST_JAR;
        }
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        float f = (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        this.updateBlock(state, worldIn, pos, true);
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updateBlock(state, worldIn, pos, false);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
        this.updateBlock(state, world, pos, false);
    }

    public void updateBlock(BlockState state, World world, BlockPos pos, boolean toggle) {
        TileEntity tileentity;
        boolean haswater;
        BlockPos backpos = pos.func_177967_a((Direction)state.func_177229_b((IProperty)FACING), -1);
        BlockState backblock = world.func_180495_p(backpos);
        TileEntity backtile = world.func_175625_s(pos.func_177967_a((Direction)state.func_177229_b((IProperty)FACING), -1));
        boolean ispowered = world.func_175687_A(pos) > 0;
        boolean ishoney = backblock.func_177230_c() instanceof BeehiveBlock && (Integer)backblock.func_177229_b((IProperty)BlockStateProperties.field_227036_ao_) > 0;
        boolean backjar = backblock.func_177230_c() instanceof JarBlock;
        boolean isjarliquid = backjar && backblock.func_177230_c().getBeaconColorMultiplier(backblock, (IWorldReader)world, backpos, backpos) != null;
        boolean iswater = world.func_204610_c(backpos).func_206884_a(FluidTags.field_206959_a) || backblock.func_177230_c() instanceof CauldronBlock && backblock.func_185888_a(world, backpos) > 0;
        BlockState downstate = world.func_180495_p(pos.func_177977_b());
        boolean hasjar = downstate.func_177230_c() instanceof JarBlock;
        boolean isTank = false;
        boolean bl = haswater = ishoney || iswater || isjarliquid || isTank;
        if (ispowered != (Boolean)state.func_177229_b((IProperty)POWERED) || haswater != (Boolean)state.func_177229_b((IProperty)HAS_WATER) || hasjar != (Boolean)state.func_177229_b((IProperty)HAS_JAR) || toggle || backjar != (Boolean)state.func_177229_b((IProperty)EXTENDED)) {
            world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(ispowered))).func_206870_a((IProperty)HAS_WATER, (Comparable)Boolean.valueOf(haswater))).func_206870_a((IProperty)HAS_JAR, (Comparable)Boolean.valueOf(hasjar))).func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(backjar))).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(toggle ^ (Boolean)state.func_177229_b((IProperty)ENABLED))), 2);
        }
        int newcolor = -2;
        if (ishoney) {
            newcolor = CommonUtil.JarLiquidType.HONEY.color;
        } else if (isjarliquid) {
            tileentity = world.func_175625_s(backpos);
            if (tileentity instanceof JarBlockTile) {
                newcolor = ((JarBlockTile)tileentity).color;
            }
        } else if (iswater) {
            newcolor = -1;
        } else if (isTank) {
            newcolor = FaucetBlock.getFluidTankColor(backtile);
        }
        if (newcolor != -2 && (tileentity = world.func_175625_s(pos)) instanceof FaucetBlockTile) {
            ((FaucetBlockTile)tileentity).watercolor = newcolor;
        }
        if (!hasjar && haswater && (Boolean)state.func_177229_b((IProperty)ENABLED) ^ toggle ^ ispowered && downstate.func_177230_c() instanceof ConcretePowderBlock) {
            try {
                Field f = ObfuscationReflectionHelper.findField(ConcretePowderBlock.class, (String)"field_200294_a");
                f.setAccessible(true);
                world.func_180501_a(pos.func_177977_b(), (BlockState)f.get(downstate.func_177230_c()), 18);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getFluidTankColor(TileEntity te) {
        return (Integer)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(iFluidHandler -> iFluidHandler.getFluidInTank(0).getFluid().getAttributes().getColor()).orElse((Object)0xFFFFFF);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u) ^ (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208180_g);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{EXTENDED, FACING, ENABLED, POWERED, HAS_WATER, HAS_JAR, WATERLOGGED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        boolean flag = world.func_204610_c(pos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        boolean hasjar = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof JarBlock;
        Direction dir = context.func_196000_l();
        if (context.func_196000_l() == Direction.UP || context.func_196000_l() == Direction.DOWN) {
            dir = Direction.NORTH;
        }
        boolean jarbehind = world.func_180495_p(pos.func_177972_a(dir.func_176734_d())).func_177230_c() instanceof JarBlock;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)dir)).func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(jarbehind))).func_206870_a((IProperty)HAS_JAR, (Comparable)Boolean.valueOf(hasjar))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        super.func_180655_c(state, world, pos, random);
        if (this.isOpen(state) && ((Boolean)state.func_177229_b((IProperty)HAS_WATER)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)HAS_JAR)).booleanValue()) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int l = 0; l < 4; ++l) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197618_k, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FaucetBlockTile();
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }
}

