/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.HangingFlowerPotBlockTile;
import net.mehvahdjukaar.supplementaries.common.FlowerPotHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class HangingFlowerPotBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final BooleanProperty TILE = BlockProperties.TILE;

    public HangingFlowerPotBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)TILE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new StringTextComponent("You shouldn't have this").func_211708_a(TextFormatting.GRAY));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return context.func_196000_l() == Direction.DOWN ? super.func_196258_a(context) : null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TILE});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof HangingFlowerPotBlockTile) {
            HangingFlowerPotBlockTile te = (HangingFlowerPotBlockTile)tileEntity;
            Block pot = te.pot.func_177230_c();
            if (pot instanceof FlowerPotBlock && FlowerPotHelper.isEmptyPot((Block)((FlowerPotBlock)pot).getEmptyPot())) {
                boolean isPotEmpty;
                ItemStack itemstack = player.func_184586_b(handIn);
                Item item2 = itemstack.func_77973_b();
                Block newPot = item2 instanceof BlockItem ? FlowerPotHelper.fullPots.get(((FlowerPotBlock)pot).getEmptyPot()).getOrDefault(((BlockItem)item2).func_179223_d().getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get() : Blocks.field_150350_a;
                boolean isEmptyFlower = newPot == Blocks.field_150350_a;
                if (isEmptyFlower != (isPotEmpty = FlowerPotHelper.isEmptyPot(pot))) {
                    if (isPotEmpty) {
                        te.setHeldBlock(newPot.func_176223_P());
                        player.func_195066_a(Stats.field_188088_V);
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                    } else {
                        ItemStack flowerItem = pot.func_185473_a((IBlockReader)worldIn, pos, state);
                        if (!flowerItem.equals(new ItemStack((IItemProvider)this))) {
                            if (itemstack.func_190926_b()) {
                                player.func_184611_a(handIn, flowerItem);
                            } else if (!player.func_191521_c(flowerItem)) {
                                player.func_71019_a(flowerItem, false);
                            }
                        }
                        te.setHeldBlock(((FlowerPotBlock)pot).getEmptyPot().func_176223_P());
                    }
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TILE) != false ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HangingFlowerPotBlockTile();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Block b;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof HangingFlowerPotBlockTile && (b = ((HangingFlowerPotBlockTile)te).pot.func_177230_c()) instanceof FlowerPotBlock) {
            Block flower = ((FlowerPotBlock)b).func_220276_d();
            if (flower == Blocks.field_150350_a) {
                return new ItemStack((IItemProvider)((FlowerPotBlock)b).getEmptyPot());
            }
            return new ItemStack((IItemProvider)flower);
        }
        return new ItemStack((IItemProvider)Blocks.field_150457_bL, 1);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        Block b;
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof HangingFlowerPotBlockTile && (b = ((HangingFlowerPotBlockTile)tileentity).pot.func_177230_c()) instanceof FlowerPotBlock) {
            return Arrays.asList(new ItemStack((IItemProvider)((FlowerPotBlock)b).func_220276_d()), new ItemStack((IItemProvider)((FlowerPotBlock)b).getEmptyPot()));
        }
        return super.func_220076_a(state, builder);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return HangingFlowerPotBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177984_a(), (Direction)Direction.DOWN);
    }
}

