/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.supplementaries.block.blocks.PistonLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.PistonLauncherHeadBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.PistonLauncherArmBlockTile;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PistonLauncherBlock
extends Block {
    protected static final VoxelShape PISTON_BASE_EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_WEST_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape PISTON_BASE_NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_UP_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_DOWN_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty EXTENDED = BlockStateProperties.field_208181_h;

    public PistonLauncherBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    public PushReaction func_149656_h(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EXTENDED) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)EXTENDED);
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EXTENDED);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, EXTENDED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
            switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                case DOWN: {
                    return PISTON_BASE_DOWN_AABB;
                }
                default: {
                    return PISTON_BASE_UP_AABB;
                }
                case NORTH: {
                    return PISTON_BASE_NORTH_AABB;
                }
                case SOUTH: {
                    return PISTON_BASE_SOUTH_AABB;
                }
                case WEST: {
                    return PISTON_BASE_WEST_AABB;
                }
                case EAST: 
            }
            return PISTON_BASE_EAST_AABB;
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.checkForMove(state, worldIn, pos);
    }

    public void checkForMove(BlockState state, World world, BlockPos pos) {
        if (!world.func_201670_d()) {
            boolean flag = this.shouldBeExtended(world, pos, (Direction)state.func_177229_b((IProperty)FACING));
            BlockPos _bp = pos.func_177971_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176730_m());
            if (flag && !((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
                boolean flag2 = false;
                BlockState targetblock = world.func_180495_p(_bp);
                if (targetblock.func_185905_o() == PushReaction.DESTROY || targetblock.func_196958_f()) {
                    TileEntity tileentity = targetblock.hasTileEntity() ? world.func_175625_s(_bp) : null;
                    PistonLauncherBlock.func_220059_a((BlockState)targetblock, (World)world, (BlockPos)_bp, (TileEntity)tileentity);
                    flag2 = true;
                }
                if (flag2) {
                    world.func_180501_a(_bp, (BlockState)((BlockState)((Block)Registry.PISTON_LAUNCHER_ARM.get()).func_176223_P().func_206870_a((IProperty)PistonLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(true)));
                    world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.53f, world.field_73012_v.nextFloat() * 0.25f + 0.45f);
                }
            } else if (!flag && ((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue()) {
                BlockState bs = world.func_180495_p(_bp);
                if (bs.func_177230_c() instanceof PistonLauncherHeadBlock && state.func_177229_b((IProperty)FACING) == bs.func_177229_b((IProperty)FACING)) {
                    world.func_180501_a(_bp, (BlockState)((BlockState)((Block)Registry.PISTON_LAUNCHER_ARM.get()).func_176223_P().func_206870_a((IProperty)PistonLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
                    world.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.53f, world.field_73012_v.nextFloat() * 0.15f + 0.45f);
                } else if (bs.func_177230_c() instanceof PistonLauncherArmBlock && state.func_177229_b((IProperty)FACING) == bs.func_177229_b((IProperty)FACING) && world.func_175625_s(_bp) instanceof PistonLauncherArmBlockTile) {
                    world.func_205220_G_().func_205360_a(pos, (Object)world.func_180495_p(pos).func_177230_c(), 1);
                }
            }
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !worldIn.func_175709_b(pos.func_177972_a(direction), direction)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
        this.checkForMove(state, world, pos);
    }
}

