/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.items.KeyItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.TripWireHookBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SafeBlock
extends Block
implements IWaterLoggable {
    public static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;

    public SafeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{OPEN, FACING, WATERLOGGED});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SafeBlockTile) {
            ((SafeBlockTile)tileentity).barrelTick();
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SafeBlockTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SafeBlockTile) {
            SafeBlockTile safe = (SafeBlockTile)tileentity;
            ItemStack stack = player.func_184586_b(handIn);
            Item item2 = stack.func_77973_b();
            boolean cleared = false;
            if (ServerConfigs.cached.SAFE_SIMPLE) {
                if ((item2 instanceof BlockItem && ((BlockItem)item2).func_179223_d() instanceof TripWireHookBlock || item2 instanceof KeyItem) && (safe.isOwnedBy(player) || safe.isNotOwnedBy(player) && player.func_184812_l_())) {
                    cleared = true;
                }
            } else if (player.func_225608_bj_() && item2 instanceof KeyItem && (player.func_184812_l_() || stack.func_200301_q().getString().equals(safe.password))) {
                cleared = true;
            }
            if (cleared) {
                safe.clearOwner();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.cleared", new Object[0]), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.5f, 1.5f);
                return ActionResultType.CONSUME;
            }
            BlockPos p = pos.func_177972_a((Direction)state.func_177229_b((IProperty)FACING));
            if (!worldIn.func_180495_p(p).func_215686_e((IBlockReader)worldIn, p)) {
                if (ServerConfigs.cached.SAFE_SIMPLE) {
                    UUID owner = safe.owner;
                    if (owner == null) {
                        owner = player.func_110124_au();
                        safe.setOwner(owner);
                    }
                    if (!owner.equals(player.func_110124_au())) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.owner", new Object[]{safe.ownerName}), true);
                        if (!player.func_184812_l_()) {
                            return ActionResultType.CONSUME;
                        }
                    }
                } else {
                    String key = safe.password;
                    if (key == null) {
                        if (item2 instanceof KeyItem) {
                            safe.password = stack.func_200301_q().getString();
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.assigned_key", new Object[]{safe.password}), true);
                            worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.5f, 1.5f);
                            return ActionResultType.CONSUME;
                        }
                    } else if (!SafeBlock.isKeyInInventory(player, safe.password) && !player.func_184812_l_()) {
                        return ActionResultType.CONSUME;
                    }
                }
                player.func_213829_a((INamedContainerProvider)tileentity);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public static boolean isKeyInInventory(PlayerEntity player, String key) {
        AtomicReference _iitemhandlerref = new AtomicReference();
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(_iitemhandlerref::set);
        if (_iitemhandlerref.get() != null) {
            boolean hasKey = false;
            for (int _idx = 0; _idx < ((IItemHandler)_iitemhandlerref.get()).getSlots(); ++_idx) {
                ItemStack stack = ((IItemHandler)_iitemhandlerref.get()).getStackInSlot(_idx);
                if (!(stack.func_77973_b() instanceof KeyItem)) continue;
                hasKey = true;
                String s = stack.func_200301_q().getString();
                if (!s.equals(key)) continue;
                return true;
            }
            if (hasKey) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.incorrect_key", new Object[0]), true);
                return false;
            }
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.locked", new Object[0]), true);
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            if (ServerConfigs.cached.SAFE_SIMPLE) {
                UUID id;
                if (compoundnbt.func_74764_b("Owner") && !(id = compoundnbt.func_186857_a("Owner")).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                    String name = compoundnbt.func_74779_i("OwnerName");
                    tooltip.add(new TranslationTextComponent("container.supplementaries.safe.owner", new Object[]{name}).func_211708_a(TextFormatting.GRAY));
                    return;
                }
                if (compoundnbt.func_150297_b("LootTable", 8)) {
                    tooltip.add(new StringTextComponent("???????").func_211708_a(TextFormatting.GRAY));
                }
                if (compoundnbt.func_150297_b("Items", 9)) {
                    NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                    ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                    int i = 0;
                    int j = 0;
                    for (ItemStack itemstack : nonnulllist) {
                        if (itemstack.func_190926_b()) continue;
                        ++j;
                        if (i > 4) continue;
                        ++i;
                        ITextComponent iformattabletextcomponent = itemstack.func_200301_q().func_212638_h();
                        iformattabletextcomponent.func_150258_a(" x").func_150258_a(String.valueOf(itemstack.func_190916_E()));
                        tooltip.add(iformattabletextcomponent.func_211708_a(TextFormatting.GRAY));
                    }
                    if (j - i > 0) {
                        tooltip.add(new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_211708_a(TextFormatting.ITALIC).func_211708_a(TextFormatting.GRAY));
                    }
                }
                return;
            }
            if (compoundnbt.func_74764_b("Password")) {
                tooltip.add(new TranslationTextComponent("message.supplementaries.safe.bound", new Object[0]).func_211708_a(TextFormatting.GRAY));
                return;
            }
        }
        tooltip.add(new TranslationTextComponent("message.supplementaries.safe.unbound", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    public ItemStack getSafeItem(SafeBlockTile te) {
        CompoundNBT compoundnbt = te.saveToNbt(new CompoundNBT());
        ItemStack itemstack = new ItemStack((IItemProvider)this.getBlock());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        if (te.func_145818_k_()) {
            itemstack.func_200302_a(te.func_200201_e());
        }
        return itemstack;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        TileEntity tileentity;
        if (ServerConfigs.cached.SAFE_UNBREAKABLE && (tileentity = world.func_175625_s(pos)) instanceof SafeBlockTile) {
            SafeBlockTile te = (SafeBlockTile)tileentity;
            if (ServerConfigs.cached.SAFE_SIMPLE) {
                if (!player.func_184812_l_() && te.isNotOwnedBy(player)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.owner", new Object[]{te.ownerName}), true);
                    return false;
                }
            } else if (!player.func_184812_l_() && !SafeBlock.isKeyInInventory(player, te.password)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.safe.locked", new Object[]{te.ownerName}), true);
                return false;
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SafeBlockTile) {
            SafeBlockTile te = (SafeBlockTile)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !te.func_191420_l()) {
                ItemStack itemstack = this.getSafeItem(te);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                te.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof SafeBlockTile) {
            SafeBlockTile te = (SafeBlockTile)tileentity;
            ItemStack itemstack = this.getSafeItem(te);
            return Collections.singletonList(itemstack);
        }
        return super.func_220076_a(state, builder);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        CompoundNBT compoundnbt;
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof SafeBlockTile && !(compoundnbt = ((SafeBlockTile)te).saveToNbt(new CompoundNBT())).isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SafeBlockTile) {
            if (stack.func_82837_s()) {
                ((LockableTileEntity)tileentity).func_213903_a(stack.func_200301_q());
            }
            if (placer instanceof PlayerEntity && ((SafeBlockTile)tileentity).owner == null) {
                ((SafeBlockTile)tileentity).setOwner(placer.func_110124_au());
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof SafeBlockTile) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }
}

