/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.client.gui.SignPostGui;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.CompassItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.extensions.IForgeBlock;

public class SignPostBlock
extends Block
implements IWaterLoggable,
IForgeBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)24.0, (double)11.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SignPostBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof SignPostBlockTile) {
            return ((SignPostBlockTile)te).fenceBlock.func_185903_a(player, worldIn, pos);
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity2) {
        BlockState s;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SignPostBlockTile && (s = ((SignPostBlockTile)te).fenceBlock) != null) {
            return s.getSoundType(world, pos, entity2);
        }
        return super.getSoundType(state, world, pos, entity2);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SignPostBlockTile) {
            MapData data;
            SignPostBlockTile te = (SignPostBlockTile)tileentity;
            ItemStack itemstack = player.func_184586_b(handIn);
            Item item2 = itemstack.func_77973_b();
            if (item2 instanceof FilledMapItem && (data = FilledMapItem.func_195950_a((ItemStack)itemstack, (World)worldIn)) != null) {
                data.func_204269_a((IWorld)worldIn, pos);
                return ActionResultType.SUCCESS;
            }
            boolean server = !worldIn.func_201670_d();
            boolean emptyhand = itemstack.func_190926_b();
            boolean isDye = item2 instanceof DyeItem && player.field_71075_bZ.field_75099_e;
            boolean isSneaking = player.func_225608_bj_() && emptyhand;
            boolean isSignPost = item2 instanceof SignPostItem;
            boolean isCompass = item2 instanceof CompassItem;
            if (isDye) {
                if (te.textHolder.setTextColor(((DyeItem)itemstack.func_77973_b()).func_195962_g())) {
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    if (server) {
                        te.func_70296_d();
                    }
                }
            } else if (isSneaking) {
                boolean up;
                double y = hit.func_216347_e().field_72448_b;
                boolean bl = up = y % (double)((int)y) > 0.5;
                if (up) {
                    te.leftUp = !te.leftUp;
                } else {
                    boolean bl2 = te.leftDown = !te.leftDown;
                }
                if (server) {
                    te.func_70296_d();
                }
            } else {
                if (isSignPost) {
                    return ActionResultType.PASS;
                }
                if (!server) {
                    SignPostGui.open(te);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SignPostBlockTile) {
            boolean up;
            SignPostBlockTile tile = (SignPostBlockTile)te;
            double y = target.func_216347_e().field_72448_b;
            boolean bl = up = y % (double)((int)y) > 0.5;
            if (up && tile.up) {
                return new ItemStack((IItemProvider)Registry.SIGN_POST_ITEMS.get(tile.woodTypeUp).get());
            }
            if (!up && tile.down) {
                return new ItemStack((IItemProvider)Registry.SIGN_POST_ITEMS.get(tile.woodTypeDown).get());
            }
            return new ItemStack((IItemProvider)tile.fenceBlock.func_177230_c());
        }
        return new ItemStack((IItemProvider)Registry.SIGN_POST_ITEMS.get(VanillaWoodTypes.OAK).get());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof SignPostBlockTile) {
            ItemStack s;
            SignPostBlockTile tile = (SignPostBlockTile)tileentity;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((IItemProvider)tile.fenceBlock.func_177230_c()));
            if (tile.up) {
                s = new ItemStack((IItemProvider)Registry.SIGN_POST_ITEMS.get(tile.woodTypeUp).get());
                list.add(s);
            }
            if (tile.down) {
                s = new ItemStack((IItemProvider)Registry.SIGN_POST_ITEMS.get(tile.woodTypeDown).get());
                list.add(s);
            }
            return list;
        }
        return super.func_220076_a(state, builder);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        float angle = rot.equals((Object)Rotation.CLOCKWISE_90) ? 90.0f : -90.0f;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)te;
            boolean success = false;
            if (tile.up) {
                tile.yawUp = MathHelper.func_76142_g((float)(tile.yawUp + angle));
                success = true;
            }
            if (tile.down) {
                tile.yawDown = MathHelper.func_76142_g((float)(tile.yawDown + angle));
                success = true;
            }
            if (success) {
                tile.func_70296_d();
            }
        }
        return state;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SignPostBlockTile();
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }
}

