/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class SwayingBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty EXTENSION = BlockProperties.EXTENSION;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SwayingBlock(Block.Properties properties) {
        super(properties);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == ((Direction)stateIn.func_177229_b((IProperty)FACING)).func_176734_d() ? (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : this.getConnectedState(stateIn, facingState, worldIn, facingPos)) : stateIn;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState getConnectedState(BlockState state, BlockState facingState, IWorld world, BlockPos pos) {
        int ext = CommonUtil.getPostSize(facingState, pos, (IWorldReader)world);
        return (BlockState)state.func_206870_a((IProperty)EXTENSION, (Comparable)Integer.valueOf(ext));
    }

    public static Vec3d copyCentered(Vec3i toCopy) {
        return new Vec3d((double)toCopy.func_177958_n() + 0.5, (double)toCopy.func_177956_o() + 0.5, (double)toCopy.func_177952_p() + 0.5);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity2) {
        super.func_196262_a(state, world, pos, entity2);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof SwayingBlockTile) {
            SwayingBlockTile te = (SwayingBlockTile)tileentity;
            Vec3d mot = entity2.func_213322_ci();
            double v = mot.func_72430_b(SwayingBlock.copyCentered(te.getDirection().func_176746_e().func_176730_m()));
            if (v != 0.0) {
                boolean bl = te.inv = v < 0.0;
            }
            if (mot.func_72433_c() > 0.05) {
                te.counter = 0;
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, EXTENSION, WATERLOGGED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }
}

