/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;

public class ClockBlockTile
extends TileEntity
implements ITickableTileEntity {
    public float roll = 0.0f;
    public float prevRoll = 0.0f;
    public float targetRoll = 0.0f;
    public float sRoll = 0.0f;
    public float sPrevRoll = 0.0f;
    public float sTargetRoll = 0.0f;
    public int power = 0;
    private int offset = 0;
    private boolean updateOffset = true;

    public ClockBlockTile() {
        super((TileEntityType)Registry.CLOCK_BLOCK_TILE.get());
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.prevRoll = this.roll = compound.func_74760_g("MinRoll");
        this.targetRoll = this.roll;
        this.sPrevRoll = this.sRoll = compound.func_74760_g("SecRoll");
        this.sTargetRoll = this.sRoll;
        this.power = compound.func_74762_e("Power");
    }

    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("MinRoll", this.targetRoll);
        compound.func_74776_a("SecRoll", this.sTargetRoll);
        compound.func_74768_a("Power", this.power);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateInitialTime() {
        int time = (int)(this.field_145850_b.func_72820_D() % 24000L);
        this.updateTime(time);
        this.roll = this.targetRoll;
        this.prevRoll = this.targetRoll;
        this.sRoll = this.sTargetRoll;
        this.sPrevRoll = this.sTargetRoll;
    }

    public void updateTime(int time) {
        int minute = MathHelper.func_76125_a((int)(time % 1000 / 20), (int)0, (int)50);
        int hour = MathHelper.func_76125_a((int)(time / 1000), (int)0, (int)24);
        if (!this.field_145850_b.field_72995_K) {
            int p;
            BlockState state = this.func_195044_w();
            if (hour != (Integer)state.func_177229_b((IProperty)ClockBlock.HOUR)) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)ClockBlock.HOUR, (Comparable)Integer.valueOf(hour)), 4);
            }
            if ((p = MathHelper.func_76125_a((int)(time / 1500), (int)0, (int)15)) != this.power) {
                this.power = p;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
        this.targetRoll = hour * 30 % 360;
        this.sTargetRoll = ((float)minute * 7.2f + 180.0f) % 360.0f;
    }

    public void onLoad() {
    }

    private void calculateOffset() {
        long dayTime = this.field_145850_b.func_72820_D() % 24000L % 20L;
        long gameTime = this.field_145850_b.func_82737_E() % 24000L % 20L;
        this.offset = (int)(dayTime - gameTime);
    }

    public void func_73660_a() {
        float r;
        int time;
        int n = time = this.field_145850_b.func_82736_K().func_223586_b(GameRules.field_223607_j) ? (int)(this.field_145850_b.func_72820_D() % 24000L) : (int)(this.field_145850_b.func_82737_E() % 24000L);
        if (this.field_145850_b != null && time % 20 == 0) {
            this.updateTime((int)(this.field_145850_b.func_72820_D() % 24000L));
        }
        this.prevRoll = this.roll;
        if (this.roll != this.targetRoll) {
            r = (this.roll + 8.0f) % 360.0f;
            if (r >= this.targetRoll && r <= this.targetRoll + 8.0f) {
                r = this.targetRoll;
            }
            this.roll = r;
        }
        this.sPrevRoll = this.sRoll;
        if (this.sRoll != this.sTargetRoll) {
            r = (this.sRoll + 8.0f) % 360.0f;
            if (r >= this.sTargetRoll && r <= this.sTargetRoll + 8.0f) {
                r = this.sTargetRoll;
            }
            this.sRoll = r;
        }
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)ClockBlock.FACING);
    }
}

