/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Random;
import java.util.stream.IntStream;
import net.mehvahdjukaar.supplementaries.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;

public class FaucetBlockTile
extends TileEntity
implements ITickableTileEntity {
    private int transferCooldown = 0;
    protected final Random rand = new Random();
    public int watercolor = 4340983;

    public FaucetBlockTile() {
        super((TileEntityType)Registry.FAUCET_TILE.get());
    }

    public double func_145833_n() {
        return 80.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(0, -1, 0), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean flag;
            if (this.isOnTransferCooldown()) {
                --this.transferCooldown;
            } else if (this.isOpen() && (flag = this.tryExtract())) {
                this.transferCooldown = 20;
            }
        }
    }

    private boolean tryExtract() {
        BlockPos behind = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)FaucetBlock.FACING), -1);
        BlockState backstate = this.field_145850_b.func_180495_p(behind);
        if (backstate.func_177230_c() instanceof BeehiveBlock && (Integer)backstate.func_177229_b((IProperty)BlockStateProperties.field_227036_ao_) > 0) {
            if (this.hasJar() && this.addItemToJar(new ItemStack((IItemProvider)Items.field_226638_pX_))) {
                this.field_145850_b.func_180501_a(behind, (BlockState)backstate.func_206870_a((IProperty)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf((Integer)backstate.func_177229_b((IProperty)BlockStateProperties.field_227036_ao_) - 1)), 3);
                return true;
            }
            return false;
        }
        if (backstate.func_177230_c() instanceof CauldronBlock && (Integer)backstate.func_177229_b((IProperty)BlockStateProperties.field_208130_ae) > 0 && this.field_145850_b.func_175625_s(behind) == null) {
            if (this.hasJar() && this.addItemToJar(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b))) {
                this.field_145850_b.func_180501_a(behind, (BlockState)backstate.func_206870_a((IProperty)BlockStateProperties.field_208130_ae, (Comparable)Integer.valueOf((Integer)backstate.func_177229_b((IProperty)BlockStateProperties.field_208130_ae) - 1)), 3);
                return true;
            }
            return false;
        }
        return this.pullItems();
    }

    public boolean isOpen() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208194_u) ^ (Boolean)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208180_g);
    }

    public boolean hasWater() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)FaucetBlock.HAS_WATER);
    }

    public boolean hasJar() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)FaucetBlock.HAS_JAR);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private boolean addItemToJar(ItemStack itemstack) {
        JarBlockTile jartileentity;
        TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileentity instanceof JarBlockTile && (jartileentity = (JarBlockTile)tileentity).func_94041_b(0, itemstack)) {
            ItemStack it = itemstack.func_77946_l();
            itemstack.func_190918_g(1);
            jartileentity.addItem(it, 1);
            jartileentity.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean pullItemFromSlot(IInventory inventoryIn, int index, Direction direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        BlockPos backpos = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D), -1);
        if (this.hasJar()) {
            if (this.field_145850_b.func_180495_p(backpos).func_177230_c() instanceof JarBlock && !itemstack.func_190926_b() && this.addItemToJar(itemstack)) {
                inventoryIn.func_70296_d();
                return true;
            }
            return false;
        }
        if (!itemstack.func_190926_b() && FaucetBlockTile.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack it = itemstack.func_77946_l();
            itemstack.func_190918_g(1);
            inventoryIn.func_70296_d();
            it.func_190920_e(1);
            ItemEntity drop = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, it);
            drop.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
            this.field_145850_b.func_217376_c((Entity)drop);
            float f = (this.rand.nextFloat() - 0.5f) / 4.0f;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.3f, 0.5f + f);
            return true;
        }
        return false;
    }

    public boolean pullItems() {
        IInventory iinventory = this.getSourceInventory();
        if (iinventory != null) {
            Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D);
            return FaucetBlockTile.func_213972_a(iinventory, direction).anyMatch(p_213971_3_ -> this.pullItemFromSlot(iinventory, p_213971_3_, direction));
        }
        return false;
    }

    public IInventory getSourceInventory() {
        BlockPos behind = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D), -1);
        IInventory firstinv = HopperTileEntity.func_195484_a((World)this.func_145831_w(), (BlockPos)behind);
        if (firstinv != null) {
            return firstinv;
        }
        if (this.field_145850_b.func_180495_p(behind).func_215686_e((IBlockReader)this.field_145850_b, this.field_174879_c)) {
            return HopperTileEntity.func_195484_a((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D), -2));
        }
        return null;
    }

    private static IntStream func_213972_a(IInventory inv, Direction dir) {
        return inv instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inv).func_180463_a(dir)) : IntStream.range(0, inv.func_70302_i_());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.watercolor = compound.func_74762_e("Watercolor");
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Watercolor", this.watercolor);
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int updateClientWaterColor() {
        this.watercolor = BiomeColors.func_228363_c_((ILightReader)this.field_145850_b, (BlockPos)this.field_174879_c);
        return this.watercolor;
    }
}

