/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.util.IMobHolder;
import net.mehvahdjukaar.supplementaries.block.util.LiquidHolder;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.DrinkHelper;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;

public class JarBlockTile
extends ItemDisplayTile
implements ITickableTileEntity,
IMobHolder {
    public int color = 0xFFFFFF;
    public float liquidLevel = 0.0f;
    public CommonUtil.JarLiquidType liquidType = CommonUtil.JarLiquidType.EMPTY;
    public MobHolder mobHolder = new MobHolder(this.field_145850_b, this.field_174879_c);
    public LiquidHolder liquidHolder = new LiquidHolder(this.field_145850_b, this.field_174879_c);

    public JarBlockTile() {
        super((TileEntityType)Registry.JAR_TILE.get());
    }

    @Override
    public MobHolder getMobHolder() {
        return this.mobHolder;
    }

    public double func_145833_n() {
        return 80.0;
    }

    public void onLoad() {
        this.mobHolder.setWorldAndPos(this.field_145850_b, this.field_174879_c);
        this.liquidHolder.setWorldAndPos(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void func_70296_d() {
        this.updateTile();
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        super.func_70296_d();
    }

    public void updateTile() {
        ItemStack stack = this.func_70301_a(0);
        this.liquidHolder.updateLiquid(stack);
        this.liquidType = CommonUtil.getJarContentTypeFromItem(stack);
        this.liquidLevel = this.liquidType.isFish() ? 0.625f : (float)this.func_70301_a(0).func_190916_E() / (float)ServerConfigs.cached.JAR_CAPACITY * 0.75f;
        this.color = this.liquidType.isWater() ? -1 : (this.liquidType == CommonUtil.JarLiquidType.POTION ? PotionUtils.func_190932_c((ItemStack)stack) : this.liquidType.color);
    }

    public boolean handleInteraction(PlayerEntity player, Hand hand) {
        ItemStack handstack = player.func_184586_b(hand);
        Item handitem = handstack.func_77973_b();
        boolean isbucket = handitem == Items.field_151133_ar;
        boolean isbottle = handitem == Items.field_151069_bo;
        boolean isbowl = handitem == Items.field_151054_z;
        boolean isempty = handstack.func_190926_b();
        boolean candrinkfromjar = ServerConfigs.cached.JAR_EAT;
        if (isempty && !player.func_225608_bj_()) {
            ItemStack stack = this.func_70301_a(0);
            Item it = stack.func_77973_b();
            if (stack.func_222117_E()) {
                if (player.func_71043_e(false) && candrinkfromjar) {
                    CompoundNBT compoundnbt;
                    if (this.field_145850_b.field_72995_K) {
                        return true;
                    }
                    Food food = it.func_219967_s();
                    int div = CommonUtil.getLiquidCountFromItem(it);
                    player.func_71024_bL().func_75122_a(food.func_221466_a() / div, food.func_221469_b() / (float)div);
                    if (it instanceof SuspiciousStewItem && (compoundnbt = stack.func_77978_p()) != null && compoundnbt.func_150297_b("Effects", 9)) {
                        ListNBT listnbt = compoundnbt.func_150295_c("Effects", 10);
                        for (int i = 0; i < listnbt.size(); ++i) {
                            Effect effect;
                            int j = 160;
                            CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                            if (compoundnbt1.func_150297_b("EffectDuration", 3)) {
                                j = compoundnbt1.func_74762_e("EffectDuration") / div;
                            }
                            if ((effect = Effect.func_188412_a((int)compoundnbt1.func_74771_c("EffectId"))) == null) continue;
                            player.func_195064_c(new EffectInstance(effect, j));
                        }
                    }
                    this.extractItem(1);
                    this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (this.liquidType == CommonUtil.JarLiquidType.COOKIES) {
                    this.handleExtractItem(1, handstack, player, hand);
                    return true;
                }
            } else if (it instanceof PotionItem && candrinkfromjar) {
                if (this.field_145850_b.field_72995_K) {
                    return true;
                }
                for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)stack)) {
                    if (effectinstance.func_188419_a().func_76403_b()) {
                        effectinstance.func_188419_a().func_180793_a((Entity)player, (Entity)player, (LivingEntity)player, effectinstance.func_76458_c(), 1.0);
                        continue;
                    }
                    player.func_195064_c(new EffectInstance(effectinstance));
                }
                this.extractItem(1);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else {
            if (this.func_94041_b(0, handstack)) {
                this.handleAddItem(handstack, player, hand);
                return true;
            }
            if (isbottle) {
                if (this.liquidType.bottle && this.handleExtractItem(1, handstack, player, hand)) {
                    this.field_145850_b.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_151069_bo));
                    return true;
                }
                return false;
            }
            if (isbucket) {
                if (this.liquidType.bucket && this.handleExtractItem(3, handstack, player, hand)) {
                    this.field_145850_b.func_184133_a(player, player.func_180425_c(), this.liquidType.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_151133_ar));
                    return true;
                }
                return false;
            }
            if (isbowl) {
                if (this.liquidType.bowl && this.handleExtractItem(2, handstack, player, hand)) {
                    this.field_145850_b.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_151054_z));
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public ItemStack extractItem(int amount) {
        amount = this.liquidType.isFish() ? 1 : amount;
        ItemStack mystack = this.func_70301_a(0);
        int count = mystack.func_190916_E();
        if (count >= amount) {
            ItemStack extracted = mystack.func_77946_l();
            extracted.func_190920_e(1);
            if (this.liquidType == CommonUtil.JarLiquidType.WATER && amount == 3) {
                extracted = new ItemStack((IItemProvider)Items.field_151131_as);
            }
            mystack.func_190920_e(Math.max(0, count - amount));
            return extracted;
        }
        return null;
    }

    public boolean handleExtractItem(int amount, ItemStack handstack, @Nullable PlayerEntity player, @Nullable Hand handIn) {
        ItemStack extracted = this.extractItem(amount);
        if (extracted != null) {
            player.func_184611_a(handIn, DrinkHelper.fill(handstack.func_77946_l(), player, extracted, true));
            return true;
        }
        return false;
    }

    public void handleAddItem(ItemStack handstack, @Nullable PlayerEntity player, @Nullable Hand handIn) {
        boolean isWaterBucket;
        ItemStack it = handstack.func_77946_l();
        Item i = it.func_77973_b();
        int count = CommonUtil.getLiquidCountFromItem(i);
        boolean bl = isWaterBucket = i == Items.field_151131_as;
        if (isWaterBucket) {
            it = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
        }
        this.addItem(it, count);
        this.updateTile();
        if (player != null && handIn != null) {
            if (!player.func_184812_l_()) {
                ItemStack returnItem = new ItemStack((IItemProvider)(isWaterBucket ? Items.field_151133_ar : this.liquidType.getReturnItem()));
                player.func_184611_a(handIn, DrinkHelper.fill(handstack.func_77946_l(), player, returnItem, false));
            }
            if (this.liquidType.makesSound()) {
                this.field_145850_b.func_184133_a(player, player.func_180425_c(), SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void addItem(ItemStack itemstack, int amount) {
        if (this.func_191420_l()) {
            itemstack.func_190920_e(amount);
            NonNullList stacks = NonNullList.func_191197_a((int)1, (Object)itemstack);
            this.func_199721_a((NonNullList<ItemStack>)stacks);
        } else {
            this.func_70301_a(0).func_190917_f(Math.min(amount, this.func_70297_j_() - this.func_70301_a(0).func_190916_E()));
        }
    }

    public boolean isFull() {
        return this.liquidType.isFish() || this.func_70301_a(0).func_190916_E() >= this.func_70297_j_();
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        CommonUtil.JarLiquidType lt;
        if (!this.mobHolder.isEmpty()) {
            if (!this.func_145818_k_()) {
                return false;
            }
            if (!this.func_200201_e().toString().toLowerCase().contains("cum")) {
                return false;
            }
        }
        if (stack.func_77973_b() == Items.field_151131_as) {
            stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
        }
        if (!(lt = CommonUtil.getJarContentTypeFromItem(stack)).isEmpty() && index == 0) {
            ItemStack currentStack = this.func_70301_a(0);
            if (this.func_191420_l()) {
                return true;
            }
            if (!this.isFull() && this.liquidType == lt) {
                if (this.liquidType == CommonUtil.JarLiquidType.COOKIES && !this.func_180462_a(0, stack, null)) {
                    return false;
                }
                return currentStack.func_196082_o().equals((Object)stack.func_196082_o());
            }
        }
        return false;
    }

    public void saveToNbt(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, (NonNullList)this.stacks, (boolean)false);
            if (this.liquidLevel != 0.0f) {
                compound.func_74776_a("liquidLevel", this.liquidLevel);
                compound.func_74768_a("liquidType", this.liquidType.ordinal());
                compound.func_74768_a("liquidColor", this.liquidType.bucket ? this.liquidType.color : this.color);
            }
        }
        this.mobHolder.write(compound);
        this.liquidHolder.write(compound);
        if (!compound.isEmpty()) {
            stack.func_77983_a("BlockEntityTag", (INBT)compound);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.liquidLevel = compound.func_74760_g("liquid_level");
        this.color = compound.func_74762_e("liquid_color");
        this.liquidType = CommonUtil.JarLiquidType.values()[compound.func_74762_e("liquid_type")];
        this.mobHolder.read(compound);
        this.liquidHolder.read(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)this.stacks);
        }
        compound.func_74768_a("liquid_color", this.color);
        compound.func_74776_a("liquid_level", this.liquidLevel);
        compound.func_74768_a("liquid_type", this.liquidType.ordinal());
        this.mobHolder.write(compound);
        this.liquidHolder.write(compound);
        return compound;
    }

    public boolean hasContent() {
        return !this.func_191420_l() || !this.mobHolder.isEmpty();
    }

    @Override
    public int func_70297_j_() {
        return ServerConfigs.cached.JAR_CAPACITY;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.jar", new Object[0]);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return CommonUtil.isCookie(stack.func_77973_b()) && (this.func_191420_l() || stack.func_77973_b() == this.func_70301_a(0).func_77973_b());
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return this.liquidType == CommonUtil.JarLiquidType.COOKIES;
    }

    public int updateClientWaterColor() {
        this.color = BiomeColors.func_228363_c_((ILightReader)this.field_145850_b, (BlockPos)this.field_174879_c);
        return this.color;
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)ClockBlock.FACING);
    }

    public void func_73660_a() {
        this.mobHolder.tick();
    }
}

