/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.supplementaries.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TurnTableBlockTile
extends TileEntity
implements ITickableTileEntity {
    private int cooldown = 5;
    private boolean canRotate = false;
    public int cat = 0;

    public TurnTableBlockTile() {
        super((TileEntityType)Registry.TURN_TABLE_TILE.get());
    }

    public void tryRotate() {
        this.canRotate = true;
        this.cooldown = TurnTableBlock.getPeriod(this.func_195044_w());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.cat = Math.max(this.cat - 1, 0);
            if (this.cooldown == 0) {
                boolean success = this.handleRotation();
                this.cooldown = TurnTableBlock.getPeriod(this.func_195044_w());
                this.canRotate = success && (Integer)this.func_195044_w().func_177229_b((IProperty)TurnTableBlock.POWER) != 0;
            } else if (this.canRotate) {
                --this.cooldown;
            }
        }
    }

    private boolean isInBlacklist(BlockState state) {
        if (state.func_177230_c() instanceof BedBlock) {
            return true;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208140_ao) && state.func_177229_b((IProperty)BlockStateProperties.field_208140_ao) != ChestType.SINGLE) {
            return true;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208181_h) && ((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208181_h)).booleanValue()) {
            return true;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208195_v)) {
            return true;
        }
        return ServerConfigs.cached.TURN_TABLE_BLACKLIST.contains(state.func_177230_c().getRegistryName().toString());
    }

    private boolean doRotateBlocks(BlockState oldstate, BlockState newState, BlockPos pos) {
        if (newState != oldstate) {
            if (newState.func_196955_c((IWorldReader)this.field_145850_b, pos)) {
                BlockPos otherPos;
                BlockState neighbour;
                Direction d;
                int i;
                this.field_145850_b.func_180501_a(pos, newState, 3);
                for (i = 0; i < 6; ++i) {
                    d = Direction.func_82600_a((int)i);
                    BlockState updatedNewState = newState.func_196956_a(d, neighbour = this.field_145850_b.func_180495_p(otherPos = pos.func_177972_a(d)), (IWorld)this.field_145850_b, pos, otherPos);
                    if (updatedNewState.func_196958_f()) {
                        this.field_145850_b.func_180501_a(pos, oldstate, 3);
                        return false;
                    }
                    this.field_145850_b.func_180501_a(pos, updatedNewState, 3);
                    newState = updatedNewState;
                }
                for (i = 0; i < 6; ++i) {
                    d = Direction.func_82600_a((int)i);
                    otherPos = pos.func_177972_a(d);
                    neighbour = this.field_145850_b.func_180495_p(otherPos);
                    BlockState updatedNeighbour = neighbour.func_196956_a(d.func_176734_d(), newState, (IWorld)this.field_145850_b, otherPos, pos);
                    if (updatedNeighbour == neighbour) continue;
                    this.field_145850_b.func_180501_a(otherPos, updatedNeighbour, 3);
                }
            }
            return true;
        }
        return false;
    }

    public Vec3d toVector3d(Direction dir) {
        return new Vec3d((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
    }

    public boolean handleRotation() {
        World world = this.field_145850_b;
        BlockPos mypos = this.field_174879_c;
        BlockState state = this.func_195044_w();
        Direction mydir = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BlockPos targetpos = mypos.func_177972_a(mydir);
        BlockState _bs = world.func_180495_p(targetpos);
        if (this.isInBlacklist(_bs)) {
            return false;
        }
        boolean ccw = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208188_o) ^ state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) == Direction.DOWN;
        Rotation rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        try {
            if (mydir.func_176740_k() == Direction.Axis.Y) {
                if (_bs.func_177230_c() instanceof SignPostBlock) {
                    _bs.rotate((IWorld)world, targetpos, rot);
                    return true;
                }
                BlockState rotatedstate = _bs.rotate((IWorld)world, targetpos, rot);
                return this.doRotateBlocks(_bs, rotatedstate, targetpos);
            }
            if (_bs.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
                Vec3d targetvec = this.toVector3d((Direction)_bs.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
                Vec3d myvec = this.toVector3d(mydir);
                if (!ccw) {
                    targetvec.func_216372_d(-1.0, -1.0, -1.0);
                }
                if ((myvec = myvec.func_72431_c(targetvec)).equals((Object)new Vec3d(0.0, 0.0, 0.0))) {
                    return false;
                }
                Direction newdir = Direction.func_210769_a((double)myvec.func_82615_a(), (double)myvec.func_82617_b(), (double)myvec.func_82616_c());
                return this.doRotateBlocks(_bs, (BlockState)_bs.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)newdir), targetpos);
            }
            if (_bs.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
                Direction.Axis targetaxis = (Direction.Axis)_bs.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
                Direction.Axis myaxis = mydir.func_176740_k();
                if (myaxis == targetaxis) {
                    return false;
                }
                if (myaxis == Direction.Axis.X) {
                    return this.doRotateBlocks(_bs, (BlockState)_bs.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)(targetaxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)), targetpos);
                }
                if (myaxis == Direction.Axis.Z) {
                    return this.doRotateBlocks(_bs, (BlockState)_bs.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)(targetaxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)), targetpos);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.cooldown = compound.func_74762_e("Cooldown");
        this.canRotate = compound.func_74767_n("CanRotate");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Cooldown", this.cooldown);
        compound.func_74757_a("CanRotate", this.canRotate);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

